/*
 * Decompiled with CFR 0.152.
 */
package org.simdjson;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.simdjson.IntegerUtils;
import org.simdjson.Tape;

public class JsonValue {
    private final Tape tape;
    private final byte[] buffer;
    private final int tapeIdx;
    private final byte[] stringBuffer;

    JsonValue(Tape tape, int tapeIdx, byte[] stringBuffer, byte[] buffer) {
        this.tape = tape;
        this.tapeIdx = tapeIdx;
        this.stringBuffer = stringBuffer;
        this.buffer = buffer;
    }

    public boolean isArray() {
        return this.tape.getType(this.tapeIdx) == '[';
    }

    public boolean isObject() {
        return this.tape.getType(this.tapeIdx) == '{';
    }

    public boolean isLong() {
        return this.tape.getType(this.tapeIdx) == 'l';
    }

    public boolean isDouble() {
        return this.tape.getType(this.tapeIdx) == 'd';
    }

    public boolean isBoolean() {
        char type = this.tape.getType(this.tapeIdx);
        return type == 't' || type == 'f';
    }

    public boolean isNull() {
        return this.tape.getType(this.tapeIdx) == 'n';
    }

    public boolean isString() {
        return this.tape.getType(this.tapeIdx) == '\"';
    }

    public Iterator<JsonValue> arrayIterator() {
        return new ArrayIterator(this.tapeIdx);
    }

    public Iterator<Map.Entry<String, JsonValue>> objectIterator() {
        return new ObjectIterator(this.tapeIdx);
    }

    public long asLong() {
        return this.tape.getInt64Value(this.tapeIdx);
    }

    public double asDouble() {
        return this.tape.getDouble(this.tapeIdx);
    }

    public boolean asBoolean() {
        return this.tape.getType(this.tapeIdx) == 't';
    }

    public String asString() {
        return this.getString(this.tapeIdx);
    }

    private String getString(int tapeIdx) {
        int stringBufferIdx = (int)this.tape.getValue(tapeIdx);
        int len = IntegerUtils.toInt(this.stringBuffer, stringBufferIdx);
        return new String(this.stringBuffer, stringBufferIdx + 4, len, StandardCharsets.UTF_8);
    }

    public JsonValue get(String name) {
        byte[] bytes = name.getBytes(StandardCharsets.UTF_8);
        int idx = this.tapeIdx + 1;
        int endIdx = this.tape.getMatchingBraceIndex(this.tapeIdx) - 1;
        while (idx < endIdx) {
            int stringBufferIdx = (int)this.tape.getValue(idx);
            int len = IntegerUtils.toInt(this.stringBuffer, stringBufferIdx);
            int valIdx = this.tape.computeNextIndex(idx);
            idx = this.tape.computeNextIndex(valIdx);
            int stringBufferFromIdx = stringBufferIdx + 4;
            int stringBufferToIdx = stringBufferFromIdx + len;
            if (Arrays.compare(bytes, 0, bytes.length, this.stringBuffer, stringBufferFromIdx, stringBufferToIdx) != 0) continue;
            return new JsonValue(this.tape, valIdx, this.stringBuffer, this.buffer);
        }
        return null;
    }

    public int getSize() {
        return this.tape.getScopeCount(this.tapeIdx);
    }

    public String toString() {
        switch (this.tape.getType(this.tapeIdx)) {
            case 'l': {
                return String.valueOf(this.asLong());
            }
            case 'd': {
                return String.valueOf(this.asDouble());
            }
            case 'f': 
            case 't': {
                return String.valueOf(this.asBoolean());
            }
            case '\"': {
                return this.asString();
            }
            case 'n': {
                return "null";
            }
            case '{': {
                return "<object>";
            }
            case '[': {
                return "<array>";
            }
        }
        return "unknown";
    }

    private class ArrayIterator
    implements Iterator<JsonValue> {
        private final int endIdx;
        private int idx;

        ArrayIterator(int startIdx) {
            this.idx = startIdx + 1;
            this.endIdx = JsonValue.this.tape.getMatchingBraceIndex(startIdx) - 1;
        }

        @Override
        public boolean hasNext() {
            return this.idx < this.endIdx;
        }

        @Override
        public JsonValue next() {
            if (this.hasNext()) {
                JsonValue value = new JsonValue(JsonValue.this.tape, this.idx, JsonValue.this.stringBuffer, JsonValue.this.buffer);
                this.idx = JsonValue.this.tape.computeNextIndex(this.idx);
                return value;
            }
            throw new NoSuchElementException("No more elements");
        }
    }

    private class ObjectIterator
    implements Iterator<Map.Entry<String, JsonValue>> {
        private final int endIdx;
        private int idx;

        ObjectIterator(int startIdx) {
            this.idx = startIdx + 1;
            this.endIdx = JsonValue.this.tape.getMatchingBraceIndex(startIdx) - 1;
        }

        @Override
        public boolean hasNext() {
            return this.idx < this.endIdx;
        }

        @Override
        public Map.Entry<String, JsonValue> next() {
            String key = JsonValue.this.getString(this.idx);
            this.idx = JsonValue.this.tape.computeNextIndex(this.idx);
            JsonValue value = new JsonValue(JsonValue.this.tape, this.idx, JsonValue.this.stringBuffer, JsonValue.this.buffer);
            this.idx = JsonValue.this.tape.computeNextIndex(this.idx);
            return new ObjectField(key, value);
        }
    }

    private static class ObjectField
    implements Map.Entry<String, JsonValue> {
        private final String key;
        private final JsonValue value;

        ObjectField(String key, JsonValue value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public JsonValue getValue() {
            return this.value;
        }

        @Override
        public JsonValue setValue(JsonValue value) {
            throw new UnsupportedOperationException("Object fields are immutable");
        }
    }
}

