/*
 * Decompiled with CFR 0.152.
 */
package org.simdjson;

import org.simdjson.BitIndexes;
import org.simdjson.JsonIterator;
import org.simdjson.JsonValue;
import org.simdjson.SchemaBasedJsonIterator;
import org.simdjson.StructuralIndexer;
import org.simdjson.Utf8Validator;

public class SimdJsonParser {
    private static final int PADDING = 64;
    private static final int DEFAULT_CAPACITY = 0x2200000;
    private static final int DEFAULT_MAX_DEPTH = 1024;
    private final StructuralIndexer indexer;
    private final BitIndexes bitIndexes;
    private final JsonIterator jsonIterator;
    private final SchemaBasedJsonIterator schemaBasedJsonIterator;
    private final byte[] paddedBuffer;

    public SimdJsonParser() {
        this(0x2200000, 1024);
    }

    public SimdJsonParser(int capacity, int maxDepth) {
        this.bitIndexes = new BitIndexes(capacity);
        byte[] stringBuffer = new byte[capacity];
        this.jsonIterator = new JsonIterator(this.bitIndexes, stringBuffer, capacity, maxDepth, 64);
        this.schemaBasedJsonIterator = new SchemaBasedJsonIterator(this.bitIndexes, stringBuffer, 64);
        this.paddedBuffer = new byte[capacity];
        this.indexer = new StructuralIndexer(this.bitIndexes);
    }

    public <T> T parse(byte[] buffer, int len, Class<T> expectedType) {
        byte[] padded = this.padIfNeeded(buffer, len);
        this.reset();
        this.stage1(padded, len);
        return this.schemaBasedJsonIterator.walkDocument(padded, len, expectedType);
    }

    public JsonValue parse(byte[] buffer, int len) {
        byte[] padded = this.padIfNeeded(buffer, len);
        this.reset();
        this.stage1(padded, len);
        return this.jsonIterator.walkDocument(padded, len);
    }

    private byte[] padIfNeeded(byte[] buffer, int len) {
        if (buffer.length - len < 64) {
            System.arraycopy(buffer, 0, this.paddedBuffer, 0, len);
            return this.paddedBuffer;
        }
        return buffer;
    }

    private void reset() {
        this.bitIndexes.reset();
        this.jsonIterator.reset();
    }

    private void stage1(byte[] buffer, int length) {
        Utf8Validator.validate(buffer, length);
        this.indexer.index(buffer, length);
    }
}

