/*
 * Decompiled with CFR 0.152.
 */
package org.simdjson;

import java.util.Arrays;
import jdk.incubator.vector.ByteVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorOperators;
import jdk.incubator.vector.VectorShuffle;
import jdk.incubator.vector.VectorSpecies;
import org.simdjson.BitIndexes;
import org.simdjson.JsonParsingException;
import org.simdjson.VectorUtils;

class StructuralIndexer {
    private static final int VECTOR_BIT_SIZE = VectorUtils.BYTE_SPECIES.vectorBitSize();
    private static final int STEP_SIZE = 64;
    private static final byte BACKSLASH = 92;
    private static final byte QUOTE = 34;
    private static final byte SPACE = 32;
    private static final byte LAST_CONTROL_CHARACTER = 31;
    private static final long EVEN_BITS_MASK = 0x5555555555555555L;
    private static final long ODD_BITS_MASK = -6148914691236517206L;
    private static final byte LOW_NIBBLE_MASK = 15;
    private static final ByteVector WHITESPACE_TABLE = VectorUtils.repeat(new byte[]{32, 100, 100, 100, 17, 100, 113, 2, 100, 9, 10, 112, 100, 13, 100, 100});
    private static final ByteVector OP_TABLE = VectorUtils.repeat(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 58, 123, 44, 125, 0, 0});
    private static final byte[] LAST_BLOCK_SPACES = new byte[64];
    private final BitIndexes bitIndexes;
    private final byte[] lastBlock = new byte[64];

    StructuralIndexer(BitIndexes bitIndexes) {
        this.bitIndexes = bitIndexes;
    }

    void index(byte[] buffer, int length) {
        this.bitIndexes.reset();
        switch (VECTOR_BIT_SIZE) {
            case 256: {
                this.index256(buffer, length);
                break;
            }
            case 512: {
                this.index512(buffer, length);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported vector width: " + VECTOR_BIT_SIZE * 64);
            }
        }
    }

    private void index256(byte[] buffer, int length) {
        long escaped;
        long backslash1;
        long prevInString = 0L;
        long prevEscaped = 0L;
        long prevStructurals = 0L;
        long unescapedCharsError = 0L;
        long prevScalar = 0L;
        int loopBound = ByteVector.SPECIES_512.loopBound(length);
        int blockIndex = 0;
        for (int offset = 0; offset < loopBound; offset += 64) {
            long escaped2;
            long backslash12;
            ByteVector chunk0 = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_256, (byte[])buffer, (int)offset);
            ByteVector chunk1 = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_256, (byte[])buffer, (int)(offset + 32));
            long backslash0 = chunk0.eq((byte)92).toLong();
            long backslash = backslash0 | (backslash12 = chunk1.eq((byte)92).toLong()) << 32;
            if (backslash == 0L) {
                escaped2 = prevEscaped;
                prevEscaped = 0L;
            } else {
                long followsEscape = (backslash &= prevEscaped ^ 0xFFFFFFFFFFFFFFFFL) << 1 | prevEscaped;
                long oddSequenceStarts = backslash & 0xAAAAAAAAAAAAAAAAL & (followsEscape ^ 0xFFFFFFFFFFFFFFFFL);
                long sequencesStartingOnEvenBits = oddSequenceStarts + backslash;
                prevEscaped = (oddSequenceStarts >>> 1) + (backslash >>> 1) + (oddSequenceStarts & backslash & 1L) >>> 63;
                long invertMask = sequencesStartingOnEvenBits << 1;
                escaped2 = (0x5555555555555555L ^ invertMask) & followsEscape;
            }
            long unescaped0 = chunk0.compare(VectorOperators.ULE, (byte)31).toLong();
            long unescaped1 = chunk1.compare(VectorOperators.ULE, (byte)31).toLong();
            long unescaped = unescaped0 | unescaped1 << 32;
            long quote0 = chunk0.eq((byte)34).toLong();
            long quote1 = chunk1.eq((byte)34).toLong();
            long quote = (quote0 | quote1 << 32) & (escaped2 ^ 0xFFFFFFFFFFFFFFFFL);
            long inString = StructuralIndexer.prefixXor(quote) ^ prevInString;
            prevInString = inString >> 63;
            VectorShuffle chunk0Low = chunk0.and((byte)15).toShuffle();
            VectorShuffle chunk1Low = chunk1.and((byte)15).toShuffle();
            long whitespace0 = chunk0.eq((Vector)WHITESPACE_TABLE.rearrange(chunk0Low)).toLong();
            long whitespace1 = chunk1.eq((Vector)WHITESPACE_TABLE.rearrange(chunk1Low)).toLong();
            long whitespace = whitespace0 | whitespace1 << 32;
            ByteVector curlified0 = chunk0.or((byte)32);
            ByteVector curlified1 = chunk1.or((byte)32);
            long op0 = curlified0.eq((Vector)OP_TABLE.rearrange(chunk0Low)).toLong();
            long op1 = curlified1.eq((Vector)OP_TABLE.rearrange(chunk1Low)).toLong();
            long op = op0 | op1 << 32;
            long scalar = (op | whitespace) ^ 0xFFFFFFFFFFFFFFFFL;
            long nonQuoteScalar = scalar & (quote ^ 0xFFFFFFFFFFFFFFFFL);
            long followsNonQuoteScalar = nonQuoteScalar << 1 | prevScalar;
            prevScalar = nonQuoteScalar >>> 63;
            long potentialScalarStart = scalar & (followsNonQuoteScalar ^ 0xFFFFFFFFFFFFFFFFL);
            long potentialStructuralStart = op | potentialScalarStart;
            this.bitIndexes.write(blockIndex, prevStructurals);
            blockIndex += 64;
            prevStructurals = potentialStructuralStart & (inString ^ quote ^ 0xFFFFFFFFFFFFFFFFL);
            unescapedCharsError |= unescaped & inString;
        }
        byte[] remainder = this.remainder(buffer, length, blockIndex);
        ByteVector chunk0 = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_256, (byte[])remainder, (int)0);
        ByteVector chunk1 = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_256, (byte[])remainder, (int)32);
        long backslash0 = chunk0.eq((byte)92).toLong();
        long backslash = backslash0 | (backslash1 = chunk1.eq((byte)92).toLong()) << 32;
        if (backslash == 0L) {
            escaped = prevEscaped;
        } else {
            long followsEscape = (backslash &= prevEscaped ^ 0xFFFFFFFFFFFFFFFFL) << 1 | prevEscaped;
            long oddSequenceStarts = backslash & 0xAAAAAAAAAAAAAAAAL & (followsEscape ^ 0xFFFFFFFFFFFFFFFFL);
            long sequencesStartingOnEvenBits = oddSequenceStarts + backslash;
            long invertMask = sequencesStartingOnEvenBits << 1;
            escaped = (0x5555555555555555L ^ invertMask) & followsEscape;
        }
        long unescaped0 = chunk0.compare(VectorOperators.ULE, (byte)31).toLong();
        long unescaped1 = chunk1.compare(VectorOperators.ULE, (byte)31).toLong();
        long unescaped = unescaped0 | unescaped1 << 32;
        long quote0 = chunk0.eq((byte)34).toLong();
        long quote1 = chunk1.eq((byte)34).toLong();
        long quote = (quote0 | quote1 << 32) & (escaped ^ 0xFFFFFFFFFFFFFFFFL);
        long inString = StructuralIndexer.prefixXor(quote) ^ prevInString;
        prevInString = inString >> 63;
        VectorShuffle chunk0Low = chunk0.and((byte)15).toShuffle();
        VectorShuffle chunk1Low = chunk1.and((byte)15).toShuffle();
        long whitespace0 = chunk0.eq((Vector)WHITESPACE_TABLE.rearrange(chunk0Low)).toLong();
        long whitespace1 = chunk1.eq((Vector)WHITESPACE_TABLE.rearrange(chunk1Low)).toLong();
        long whitespace = whitespace0 | whitespace1 << 32;
        ByteVector curlified0 = chunk0.or((byte)32);
        ByteVector curlified1 = chunk1.or((byte)32);
        long op0 = curlified0.eq((Vector)OP_TABLE.rearrange(chunk0Low)).toLong();
        long op1 = curlified1.eq((Vector)OP_TABLE.rearrange(chunk1Low)).toLong();
        long op = op0 | op1 << 32;
        long scalar = (op | whitespace) ^ 0xFFFFFFFFFFFFFFFFL;
        long nonQuoteScalar = scalar & (quote ^ 0xFFFFFFFFFFFFFFFFL);
        long followsNonQuoteScalar = nonQuoteScalar << 1 | prevScalar;
        long potentialScalarStart = scalar & (followsNonQuoteScalar ^ 0xFFFFFFFFFFFFFFFFL);
        long potentialStructuralStart = op | potentialScalarStart;
        this.bitIndexes.write(blockIndex, prevStructurals);
        prevStructurals = potentialStructuralStart & (inString ^ quote ^ 0xFFFFFFFFFFFFFFFFL);
        unescapedCharsError |= unescaped & inString;
        this.bitIndexes.write(blockIndex += 64, prevStructurals);
        this.bitIndexes.finish();
        if (prevInString != 0L) {
            throw new JsonParsingException("Unclosed string. A string is opened, but never closed.");
        }
        if (unescapedCharsError != 0L) {
            throw new JsonParsingException("Unescaped characters. Within strings, there are characters that should be escaped.");
        }
    }

    private void index512(byte[] buffer, int length) {
        long escaped;
        long prevInString = 0L;
        long prevEscaped = 0L;
        long prevStructurals = 0L;
        long unescapedCharsError = 0L;
        long prevScalar = 0L;
        int loopBound = ByteVector.SPECIES_512.loopBound(length);
        int blockIndex = 0;
        for (int offset = 0; offset < loopBound; offset += 64) {
            long escaped2;
            ByteVector chunk = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_512, (byte[])buffer, (int)offset);
            long backslash = chunk.eq((byte)92).toLong();
            if (backslash == 0L) {
                escaped2 = prevEscaped;
                prevEscaped = 0L;
            } else {
                long followsEscape = (backslash &= prevEscaped ^ 0xFFFFFFFFFFFFFFFFL) << 1 | prevEscaped;
                long oddSequenceStarts = backslash & 0xAAAAAAAAAAAAAAAAL & (followsEscape ^ 0xFFFFFFFFFFFFFFFFL);
                long sequencesStartingOnEvenBits = oddSequenceStarts + backslash;
                prevEscaped = (oddSequenceStarts >>> 1) + (backslash >>> 1) + (oddSequenceStarts & backslash & 1L) >>> 63;
                long invertMask = sequencesStartingOnEvenBits << 1;
                escaped2 = (0x5555555555555555L ^ invertMask) & followsEscape;
            }
            long unescaped = chunk.compare(VectorOperators.ULE, (byte)31).toLong();
            long quote = chunk.eq((byte)34).toLong() & (escaped2 ^ 0xFFFFFFFFFFFFFFFFL);
            long inString = StructuralIndexer.prefixXor(quote) ^ prevInString;
            prevInString = inString >> 63;
            VectorShuffle chunkLow = chunk.and((byte)15).toShuffle();
            long whitespace = chunk.eq((Vector)WHITESPACE_TABLE.rearrange(chunkLow)).toLong();
            ByteVector curlified = chunk.or((byte)32);
            long op = curlified.eq((Vector)OP_TABLE.rearrange(chunkLow)).toLong();
            long scalar = (op | whitespace) ^ 0xFFFFFFFFFFFFFFFFL;
            long nonQuoteScalar = scalar & (quote ^ 0xFFFFFFFFFFFFFFFFL);
            long followsNonQuoteScalar = nonQuoteScalar << 1 | prevScalar;
            prevScalar = nonQuoteScalar >>> 63;
            long potentialScalarStart = scalar & (followsNonQuoteScalar ^ 0xFFFFFFFFFFFFFFFFL);
            long potentialStructuralStart = op | potentialScalarStart;
            this.bitIndexes.write(blockIndex, prevStructurals);
            blockIndex += 64;
            prevStructurals = potentialStructuralStart & (inString ^ quote ^ 0xFFFFFFFFFFFFFFFFL);
            unescapedCharsError |= unescaped & inString;
        }
        byte[] remainder = this.remainder(buffer, length, blockIndex);
        ByteVector chunk = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_512, (byte[])remainder, (int)0);
        long backslash = chunk.eq((byte)92).toLong();
        if (backslash == 0L) {
            escaped = prevEscaped;
        } else {
            long followsEscape = (backslash &= prevEscaped ^ 0xFFFFFFFFFFFFFFFFL) << 1 | prevEscaped;
            long oddSequenceStarts = backslash & 0xAAAAAAAAAAAAAAAAL & (followsEscape ^ 0xFFFFFFFFFFFFFFFFL);
            long sequencesStartingOnEvenBits = oddSequenceStarts + backslash;
            long invertMask = sequencesStartingOnEvenBits << 1;
            escaped = (0x5555555555555555L ^ invertMask) & followsEscape;
        }
        long unescaped = chunk.compare(VectorOperators.ULE, (byte)31).toLong();
        long quote = chunk.eq((byte)34).toLong() & (escaped ^ 0xFFFFFFFFFFFFFFFFL);
        long inString = StructuralIndexer.prefixXor(quote) ^ prevInString;
        prevInString = inString >> 63;
        VectorShuffle chunkLow = chunk.and((byte)15).toShuffle();
        long whitespace = chunk.eq((Vector)WHITESPACE_TABLE.rearrange(chunkLow)).toLong();
        ByteVector curlified = chunk.or((byte)32);
        long op = curlified.eq((Vector)OP_TABLE.rearrange(chunkLow)).toLong();
        long scalar = (op | whitespace) ^ 0xFFFFFFFFFFFFFFFFL;
        long nonQuoteScalar = scalar & (quote ^ 0xFFFFFFFFFFFFFFFFL);
        long followsNonQuoteScalar = nonQuoteScalar << 1 | prevScalar;
        long potentialScalarStart = scalar & (followsNonQuoteScalar ^ 0xFFFFFFFFFFFFFFFFL);
        long potentialStructuralStart = op | potentialScalarStart;
        this.bitIndexes.write(blockIndex, prevStructurals);
        prevStructurals = potentialStructuralStart & (inString ^ quote ^ 0xFFFFFFFFFFFFFFFFL);
        unescapedCharsError |= unescaped & inString;
        this.bitIndexes.write(blockIndex += 64, prevStructurals);
        this.bitIndexes.finish();
        if (prevInString != 0L) {
            throw new JsonParsingException("Unclosed string. A string is opened, but never closed.");
        }
        if (unescapedCharsError != 0L) {
            throw new JsonParsingException("Unescaped characters. Within strings, there are characters that should be escaped.");
        }
    }

    private byte[] remainder(byte[] buffer, int length, int idx) {
        System.arraycopy(LAST_BLOCK_SPACES, 0, this.lastBlock, 0, this.lastBlock.length);
        System.arraycopy(buffer, idx, this.lastBlock, 0, length - idx);
        return this.lastBlock;
    }

    private static long prefixXor(long bitmask) {
        bitmask ^= bitmask << 1;
        bitmask ^= bitmask << 2;
        bitmask ^= bitmask << 4;
        bitmask ^= bitmask << 8;
        bitmask ^= bitmask << 16;
        bitmask ^= bitmask << 32;
        return bitmask;
    }

    static {
        Arrays.fill(LAST_BLOCK_SPACES, (byte)32);
    }
}

