/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.lightningcsv;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Stream;
import org.simpleflatmapper.lightningcsv.CloseableCsvReader;
import org.simpleflatmapper.lightningcsv.CsvReader;
import org.simpleflatmapper.lightningcsv.Row;
import org.simpleflatmapper.lightningcsv.parser.AbstractCharConsumer;
import org.simpleflatmapper.lightningcsv.parser.CellConsumer;
import org.simpleflatmapper.lightningcsv.parser.CellPreProcessor;
import org.simpleflatmapper.lightningcsv.parser.CharBuffer;
import org.simpleflatmapper.lightningcsv.parser.CharConsumerFactory;
import org.simpleflatmapper.lightningcsv.parser.CharSequenceCharBuffer;
import org.simpleflatmapper.lightningcsv.parser.NoopCellPreProcessor;
import org.simpleflatmapper.lightningcsv.parser.ReaderCharBuffer;
import org.simpleflatmapper.lightningcsv.parser.StringArrayCellConsumer;
import org.simpleflatmapper.lightningcsv.parser.TextFormat;
import org.simpleflatmapper.lightningcsv.parser.TrimCellPreProcessor;
import org.simpleflatmapper.lightningcsv.parser.UnescapeCellPreProcessor;
import org.simpleflatmapper.lightningcsv.parser.YamlCellPreProcessor;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.CloseableIterator;
import org.simpleflatmapper.util.ParallelReader;

public final class CsvParser {
    public static final int DEFAULT_MAX_BUFFER_SIZE_8M = 0x800000;
    public static final int DEFAULT_BUFFER_SIZE_4K = 4096;
    public static final Charset DEFAULT_CHARSET = Charset.defaultCharset();
    private static final CharConsumerFactory CHAR_CONSUMER_FACTORY = CharConsumerFactory.newInstance();
    private static final OnReaderFactory<CloseableCsvReader, AbstractDSL<?>> CREATE_CLOSEABLE_CSV_READER = new OnReaderFactory<CloseableCsvReader, AbstractDSL<?>>(){

        @Override
        public CloseableCsvReader apply(Reader reader, AbstractDSL<?> dsl) throws IOException {
            return new CloseableCsvReader(dsl.reader(reader), reader);
        }
    };
    private static final OnReaderFactory<CloseableIterator<String[]>, AbstractDSL<?>> CREATE_CLOSEABLE_ITERATOR = new OnReaderFactory<CloseableIterator<String[]>, AbstractDSL<?>>(){

        @Override
        public CloseableIterator<String[]> apply(Reader reader, AbstractDSL<?> dsl) throws IOException {
            return new CloseableIterator(dsl.iterator(reader), (Closeable)reader);
        }
    };
    private static final OnReaderFactory<CloseableIterator<Row>, AbstractDSL<?>> CREATE_CLOSEABLE_ROW_ITERATOR = new OnReaderFactory<CloseableIterator<Row>, AbstractDSL<?>>(){

        @Override
        public CloseableIterator<Row> apply(Reader reader, AbstractDSL<?> dsl) throws IOException {
            return new CloseableIterator(dsl.rowIterator(reader), (Closeable)reader);
        }
    };

    public static DSL separator(char c) {
        return (DSL)CsvParser.dsl().separator(c);
    }

    public static DSL bufferSize(int size) {
        return (DSL)CsvParser.dsl().bufferSize(size);
    }

    public static DSL maxBufferSize(int size) {
        return (DSL)CsvParser.dsl().maxBufferSize(size);
    }

    public static DSL quote(char c) {
        return (DSL)CsvParser.dsl().quote(c);
    }

    public static DSL skip(int skip) {
        return (DSL)CsvParser.dsl().skip(skip);
    }

    public static DSL dsl() {
        return new DSL();
    }

    public static DSL limit(int limit) {
        return (DSL)CsvParser.dsl().limit(limit);
    }

    public static CsvReader reader(Reader reader) throws IOException {
        return CsvParser.dsl().reader(reader);
    }

    public static CsvReader reader(CharSequence content) throws IOException {
        return CsvParser.dsl().reader(content);
    }

    public static CsvReader reader(String content) throws IOException {
        return CsvParser.dsl().reader(content);
    }

    public static CloseableCsvReader reader(File file) throws IOException {
        return CsvParser.dsl().reader(file);
    }

    public static Iterator<String[]> iterator(Reader reader) throws IOException {
        return CsvParser.dsl().iterator(reader);
    }

    public static Iterator<String[]> iterator(CharSequence content) throws IOException {
        return CsvParser.dsl().iterator(content);
    }

    public static CloseableIterator<String[]> iterator(File file) throws IOException {
        return CsvParser.dsl().iterator(file);
    }

    public static <H extends CheckedConsumer<String[]>> H forEach(Reader reader, H consumer) throws IOException {
        return CsvParser.dsl().forEach(reader, consumer);
    }

    public static <H extends CheckedConsumer<String[]>> H forEach(CharSequence content, H consumer) throws IOException {
        return CsvParser.dsl().forEach(content, consumer);
    }

    public static <H extends CheckedConsumer<String[]>> H forEach(File file, H consumer) throws IOException {
        return CsvParser.dsl().forEach(file, consumer);
    }

    public static <CC extends CellConsumer> CC parse(Reader reader, CC cellConsumer) throws IOException {
        return CsvParser.dsl().parse(reader, cellConsumer);
    }

    public static <CC extends CellConsumer> CC parse(CharSequence content, CC cellConsumer) throws IOException {
        return CsvParser.dsl().parse(content, cellConsumer);
    }

    public static <CC extends CellConsumer> CC parse(String content, CC cellConsumer) throws IOException {
        return CsvParser.dsl().parse(content, cellConsumer);
    }

    public static <CC extends CellConsumer> CC parse(File file, CC cellConsumer) throws IOException {
        return CsvParser.dsl().parse(file, cellConsumer);
    }

    private static Reader newReader(File file) throws IOException {
        return CsvParser.newReader(file, DEFAULT_CHARSET);
    }

    private static Reader newReader(File file, Charset charset) throws IOException {
        FileChannel fileChannel = FileChannel.open(file.toPath(), new OpenOption[0]);
        try {
            return Channels.newReader(fileChannel, charset.newDecoder(), -1);
        }
        catch (Throwable e) {
            CsvParser.safeClose(fileChannel);
            throw e;
        }
    }

    private static void safeClose(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Reader newReaderJava6(File file, Charset charset) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        FileChannel fileChannel = null;
        try {
            fileChannel = randomAccessFile.getChannel();
            return Channels.newReader(fileChannel, charset.newDecoder(), -1);
        }
        catch (RuntimeException t) {
            CsvParser.safeClose(fileChannel);
            CsvParser.safeClose(randomAccessFile);
            throw t;
        }
        catch (Error t) {
            CsvParser.safeClose(fileChannel);
            CsvParser.safeClose(randomAccessFile);
            throw t;
        }
    }

    public static Stream<String[]> stream(Reader r) throws IOException {
        return CsvParser.dsl().stream(r);
    }

    @Deprecated
    public static Stream<String[]> stream(File file) throws IOException {
        return CsvParser.dsl().stream(file);
    }

    public static <R> R stream(File file, Function<Stream<String[]>, R> function) throws IOException {
        return CsvParser.dsl().stream(file, function);
    }

    public static Stream<String[]> stream(String content) throws IOException {
        return CsvParser.dsl().stream(content);
    }

    public static <R, D extends AbstractDSL<?>> R onReader(File file, D dsl, OnReaderFactory<R, ? super D> factory) throws IOException {
        Reader reader = CsvParser.newReader(file);
        try {
            return factory.apply(reader, dsl);
        }
        catch (IOException ioe) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ioe;
        }
    }

    public static interface OnReaderFactory<T, D extends AbstractDSL<?>> {
        public T apply(Reader var1, D var2) throws IOException;
    }

    public static final class DSL
    extends AbstractDSL<DSL> {
        protected DSL() {
        }

        protected DSL(char separatorChar, char quoteChar, char escapeChar, int bufferSize, int skip, int limit, int maxBufferSize, AbstractDSL.StringPostProcessing stringPostProcessing, org.simpleflatmapper.util.Function<? super CellConsumer, ? extends CellConsumer> cellConsumerWrapper, boolean yamlComment, boolean parallelReader, boolean specialisedCharConsumer) {
            super(separatorChar, quoteChar, escapeChar, bufferSize, skip, limit, maxBufferSize, stringPostProcessing, cellConsumerWrapper, yamlComment, parallelReader, specialisedCharConsumer);
        }

        public DSL trimSpaces() {
            return new DSL(this.separatorChar, this.quoteChar, this.escapeChar, this.bufferSize, this.skip, this.limit, this.maxBufferSize, AbstractDSL.StringPostProcessing.TRIM_AND_UNESCAPE, (org.simpleflatmapper.util.Function<? super CellConsumer, ? extends CellConsumer>)this.cellConsumerWrapper, this.yamlComment, this.parallelReader, this.specialisedCharConsumer);
        }

        public DSLYamlComment withYamlComments() {
            return new DSLYamlComment(this.separatorChar, this.quoteChar, this.escapeChar, this.bufferSize, this.skip, this.limit, this.maxBufferSize, this.stringPostProcessing, (org.simpleflatmapper.util.Function<? super CellConsumer, ? extends CellConsumer>)new org.simpleflatmapper.util.Function<CellConsumer, CellConsumer>(){

                public CellConsumer apply(CellConsumer cellConsumer) {
                    TextFormat textFormat = this.getTextFormat();
                    return new YamlCellPreProcessor.YamlCellConsumer(cellConsumer, null, this.getCellTransformer(textFormat, stringPostProcessing));
                }
            }, true, this.parallelReader, this.specialisedCharConsumer);
        }

        public DSLYamlComment withYamlCommentsAsCell() {
            return new DSLYamlComment(this.separatorChar, this.quoteChar, this.escapeChar, this.bufferSize, this.skip, this.limit, this.maxBufferSize, this.stringPostProcessing, (org.simpleflatmapper.util.Function<? super CellConsumer, ? extends CellConsumer>)new org.simpleflatmapper.util.Function<CellConsumer, CellConsumer>(){

                public CellConsumer apply(CellConsumer cellConsumer) {
                    TextFormat textFormat = this.getTextFormat();
                    return new YamlCellPreProcessor.YamlCellConsumer(cellConsumer, cellConsumer, this.getCellTransformer(textFormat, stringPostProcessing));
                }
            }, true, this.parallelReader, this.specialisedCharConsumer);
        }

        public DSL disableUnescaping() {
            return new DSL(this.separatorChar, this.quoteChar, this.escapeChar, this.bufferSize, this.skip, this.limit, this.maxBufferSize, AbstractDSL.StringPostProcessing.NONE, (org.simpleflatmapper.util.Function<? super CellConsumer, ? extends CellConsumer>)this.cellConsumerWrapper, this.yamlComment, this.parallelReader, this.specialisedCharConsumer);
        }

        @Override
        protected DSL newDSL(char separatorChar, char quoteChar, char escapeChar, int bufferSize, int skip, int limit, int maxBufferSize, AbstractDSL.StringPostProcessing stringPostProcessing, org.simpleflatmapper.util.Function<? super CellConsumer, ? extends CellConsumer> cellConsumerWrapper, boolean yamlComment, boolean parallelReader, boolean specialisedCharConsumer) {
            return new DSL(separatorChar, quoteChar, escapeChar, bufferSize, skip, limit, maxBufferSize, stringPostProcessing, cellConsumerWrapper, yamlComment, parallelReader, specialisedCharConsumer);
        }
    }

    public static abstract class AbstractDSL<D extends AbstractDSL<D>> {
        protected final char separatorChar;
        protected final char quoteChar;
        protected final char escapeChar;
        protected final int bufferSize;
        protected final int skip;
        protected final int limit;
        protected final int maxBufferSize;
        protected final StringPostProcessing stringPostProcessing;
        protected final org.simpleflatmapper.util.Function<? super CellConsumer, ? extends CellConsumer> cellConsumerWrapper;
        protected final boolean yamlComment;
        protected final boolean parallelReader;
        protected final boolean specialisedCharConsumer;

        protected AbstractDSL() {
            this.separatorChar = (char)44;
            this.quoteChar = (char)34;
            this.escapeChar = (char)34;
            this.bufferSize = 4096;
            this.skip = 0;
            this.limit = -1;
            this.maxBufferSize = 0x800000;
            this.stringPostProcessing = StringPostProcessing.UNESCAPE;
            this.cellConsumerWrapper = null;
            this.yamlComment = false;
            this.parallelReader = false;
            this.specialisedCharConsumer = true;
        }

        protected AbstractDSL(char separatorChar, char quoteChar, char escapeChar, int bufferSize, int skip, int limit, int maxBufferSize, StringPostProcessing stringPostProcessing, org.simpleflatmapper.util.Function<? super CellConsumer, ? extends CellConsumer> cellConsumerWrapper, boolean yamlComment, boolean parallelReader, boolean specialisedCharConsumer) {
            this.separatorChar = separatorChar;
            this.quoteChar = quoteChar;
            this.escapeChar = escapeChar;
            this.bufferSize = bufferSize;
            this.skip = skip;
            this.limit = limit;
            this.maxBufferSize = maxBufferSize;
            this.stringPostProcessing = stringPostProcessing;
            this.cellConsumerWrapper = cellConsumerWrapper;
            this.yamlComment = yamlComment;
            this.parallelReader = parallelReader;
            this.specialisedCharConsumer = specialisedCharConsumer;
        }

        public final <CC extends CellConsumer> CC parse(Reader reader, CC cellConsumer) throws IOException {
            return this.parse(this.charBuffer(reader), cellConsumer);
        }

        public final <CC extends CellConsumer> CC parse(String content, CC cellConsumer) throws IOException {
            return this.parse(this.charBuffer(content), cellConsumer);
        }

        public final <CC extends CellConsumer> CC parse(CharSequence content, CC cellConsumer) throws IOException {
            return this.parse(this.charBuffer(content), cellConsumer);
        }

        private <CC extends CellConsumer> CC parse(CharBuffer charBuffer, CC cellConsumer) throws IOException {
            CsvReader csvreader = this.reader(charBuffer);
            if (this.limit == -1) {
                return csvreader.parseAll(cellConsumer);
            }
            return csvreader.parseRows(cellConsumer, this.limit);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <CC extends CellConsumer> CC parse(File file, CC cellConsumer) throws IOException {
            Reader reader = CsvParser.newReader(file);
            CC CC = this.parse(reader, cellConsumer);
            return CC;
            finally {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }

        public final CsvReader reader(Reader reader) throws IOException {
            return this.reader(this.charBuffer((Reader)(this.parallelReader ? new ParallelReader(reader) : reader)));
        }

        public final CsvReader reader(CharSequence content) throws IOException {
            return this.reader(this.charBuffer(content));
        }

        public final CsvReader reader(String content) throws IOException {
            return this.reader(this.charBuffer(content));
        }

        private CsvReader reader(CharBuffer charBuffer) throws IOException {
            CsvReader csvReader = new CsvReader(this.charConsumer(charBuffer), this.cellConsumerWrapper);
            csvReader.skipRows(this.skip);
            return csvReader;
        }

        protected CharBuffer charBuffer(Reader reader) throws IOException {
            return new ReaderCharBuffer(this.bufferSize, this.maxBufferSize, reader);
        }

        protected CharBuffer charBuffer(CharSequence content) throws IOException {
            return new CharSequenceCharBuffer(content);
        }

        protected CharBuffer charBuffer(String content) throws IOException {
            return new CharSequenceCharBuffer(content);
        }

        public final CloseableCsvReader reader(File file) throws IOException {
            return (CloseableCsvReader)CsvParser.onReader(file, this, CREATE_CLOSEABLE_CSV_READER);
        }

        public final Iterator<String[]> iterator(Reader reader) throws IOException {
            return this.reader(reader).iterator();
        }

        public final Iterator<String[]> iterator(CharSequence content) throws IOException {
            return this.reader(content).iterator();
        }

        public final Iterator<String[]> iterator(String content) throws IOException {
            return this.reader(content).iterator();
        }

        public final CloseableIterator<String[]> iterator(File file) throws IOException {
            return (CloseableIterator)CsvParser.onReader(file, this, CREATE_CLOSEABLE_ITERATOR);
        }

        public final Iterator<Row> rowIterator(Reader reader) throws IOException {
            return this.reader(reader).rowIterator();
        }

        public final Iterator<Row> rowIterator(CharSequence content) throws IOException {
            return this.reader(content).rowIterator();
        }

        public final Iterator<Row> rowIterator(String content) throws IOException {
            return this.reader(content).rowIterator();
        }

        public final CloseableIterator<Row> rowIterator(File file) throws IOException {
            return (CloseableIterator)CsvParser.onReader(file, this, CREATE_CLOSEABLE_ROW_ITERATOR);
        }

        public final <H extends CheckedConsumer<String[]>> H forEach(Reader reader, H consumer) throws IOException {
            return this.reader(reader).read(consumer);
        }

        public final <H extends CheckedConsumer<String[]>> H forEach(CharSequence content, H consumer) throws IOException {
            return this.reader(content).read(consumer);
        }

        public final <H extends CheckedConsumer<String[]>> H forEach(String content, H consumer) throws IOException {
            return this.reader(content).read(consumer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <H extends CheckedConsumer<String[]>> H forEach(File file, H consumer) throws IOException {
            try (CloseableCsvReader csvReader = this.reader(file);){
                csvReader.read(consumer);
            }
            return consumer;
        }

        public final Stream<String[]> stream(Reader reader) throws IOException {
            return this.reader(reader).stream();
        }

        public final Stream<String[]> stream(CharSequence content) throws IOException {
            return this.reader(content).stream();
        }

        public final Stream<String[]> stream(String content) throws IOException {
            return this.reader(content).stream();
        }

        public final Stream<Row> rowStream(Reader reader) throws IOException {
            return this.reader(reader).rowStream();
        }

        public final Stream<Row> rowStream(CharSequence content) throws IOException {
            return this.reader(content).rowStream();
        }

        public final Stream<Row> rowStream(String content) throws IOException {
            return this.reader(content).rowStream();
        }

        @Deprecated
        public final Stream<String[]> stream(File file) throws IOException {
            return CsvParser.onReader(file, this, (reader, dsl) -> (Stream)dsl.stream(reader).onClose(() -> {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }));
        }

        public final <R> R stream(File file, Function<Stream<String[]>, R> function) throws IOException {
            Reader reader = CsvParser.newReader(file);
            try {
                return function.apply(this.stream(reader));
            }
            catch (IOException ioe) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw ioe;
            }
        }

        public final <R> R rowStream(File file, Function<Stream<Row>, R> function) throws IOException {
            Reader reader = CsvParser.newReader(file);
            try {
                return function.apply(this.rowStream(reader));
            }
            catch (IOException ioe) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw ioe;
            }
        }

        protected final AbstractCharConsumer charConsumer(CharBuffer charBuffer) {
            TextFormat textFormat = this.getTextFormat();
            CellPreProcessor cellTransformer = this.getCellTransformer(textFormat, this.stringPostProcessing);
            return CHAR_CONSUMER_FACTORY.newCharConsumer(textFormat, charBuffer, cellTransformer, this.specialisedCharConsumer);
        }

        protected TextFormat getTextFormat() {
            return new TextFormat(this.separatorChar, this.quoteChar, this.escapeChar, this.yamlComment);
        }

        protected CellPreProcessor getCellTransformer(TextFormat textFormat, StringPostProcessing stringPostProcessing) {
            switch (stringPostProcessing) {
                case TRIM_AND_UNESCAPE: {
                    return new TrimCellPreProcessor(this.getUnescapeCellTransformer(textFormat));
                }
                case UNESCAPE: {
                    return this.getUnescapeCellTransformer(textFormat);
                }
                case NONE: {
                    return NoopCellPreProcessor.INSTANCE;
                }
            }
            throw new IllegalStateException("Could not instantiate char consumer " + String.valueOf((Object)stringPostProcessing));
        }

        protected CellPreProcessor getUnescapeCellTransformer(TextFormat textFormat) {
            return new UnescapeCellPreProcessor(textFormat.escapeChar, textFormat.quoteChar);
        }

        public final int maxBufferSize() {
            return this.maxBufferSize;
        }

        public final int bufferSize() {
            return this.bufferSize;
        }

        public final int limit() {
            return this.limit;
        }

        public final int skip() {
            return this.skip;
        }

        public final char separator() {
            return this.separatorChar;
        }

        public final char quote() {
            return this.quoteChar;
        }

        public D separator(char c) {
            return this.newDSL(c, this.quoteChar, this.escapeChar, this.bufferSize, this.skip, this.limit, this.maxBufferSize, this.stringPostProcessing, this.cellConsumerWrapper, this.yamlComment, this.parallelReader, this.specialisedCharConsumer);
        }

        public D quote(char c) {
            return this.newDSL(this.separatorChar, c, this.escapeChar, this.bufferSize, this.skip, this.limit, this.maxBufferSize, this.stringPostProcessing, this.cellConsumerWrapper, this.yamlComment, this.parallelReader, this.specialisedCharConsumer);
        }

        public D escape(char c) {
            return this.newDSL(this.separatorChar, this.quoteChar, c, this.bufferSize, this.skip, this.limit, this.maxBufferSize, this.stringPostProcessing, this.cellConsumerWrapper, this.yamlComment, this.parallelReader, this.specialisedCharConsumer);
        }

        public D bufferSize(int size) {
            return this.newDSL(this.separatorChar, this.quoteChar, this.escapeChar, size, this.skip, this.limit, this.maxBufferSize, this.stringPostProcessing, this.cellConsumerWrapper, this.yamlComment, this.parallelReader, this.specialisedCharConsumer);
        }

        public D skip(int skip) {
            return this.newDSL(this.separatorChar, this.quoteChar, this.escapeChar, this.bufferSize, skip, this.limit, this.maxBufferSize, this.stringPostProcessing, this.cellConsumerWrapper, this.yamlComment, this.parallelReader, this.specialisedCharConsumer);
        }

        public D limit(int limit) {
            return this.newDSL(this.separatorChar, this.quoteChar, this.escapeChar, this.bufferSize, this.skip, limit, this.maxBufferSize, this.stringPostProcessing, this.cellConsumerWrapper, this.yamlComment, this.parallelReader, this.specialisedCharConsumer);
        }

        public D parallelReader() {
            return this.newDSL(this.separatorChar, this.quoteChar, this.escapeChar, this.bufferSize, this.skip, this.limit, this.maxBufferSize, this.stringPostProcessing, this.cellConsumerWrapper, this.yamlComment, true, this.specialisedCharConsumer);
        }

        public D serialReader() {
            return this.newDSL(this.separatorChar, this.quoteChar, this.escapeChar, this.bufferSize, this.skip, this.limit, this.maxBufferSize, this.stringPostProcessing, this.cellConsumerWrapper, this.yamlComment, false, this.specialisedCharConsumer);
        }

        public D disableSpecialisedCharConsumer() {
            return this.newDSL(this.separatorChar, this.quoteChar, this.escapeChar, this.bufferSize, this.skip, this.limit, this.maxBufferSize, this.stringPostProcessing, this.cellConsumerWrapper, this.yamlComment, this.parallelReader, false);
        }

        public D maxBufferSize(int maxBufferSize) {
            return this.newDSL(this.separatorChar, this.quoteChar, this.escapeChar, this.bufferSize, this.skip, this.limit, maxBufferSize, this.stringPostProcessing, this.cellConsumerWrapper, this.yamlComment, this.parallelReader, this.specialisedCharConsumer);
        }

        protected abstract D newDSL(char var1, char var2, char var3, int var4, int var5, int var6, int var7, StringPostProcessing var8, org.simpleflatmapper.util.Function<? super CellConsumer, ? extends CellConsumer> var9, boolean var10, boolean var11, boolean var12);

        protected static enum StringPostProcessing {
            NONE,
            UNESCAPE,
            TRIM_AND_UNESCAPE;

        }
    }

    public static final class DSLYamlComment
    extends AbstractDSL<DSLYamlComment> {
        private static final OnReaderFactory<CloseableCsvReader, DSLYamlComment> CREATE_CLOSEABLE_CSV_RAW_READER = new OnReaderFactory<CloseableCsvReader, DSLYamlComment>(){

            @Override
            public CloseableCsvReader apply(Reader reader, DSLYamlComment dsl) throws IOException {
                return new CloseableCsvReader(dsl.rawReader(dsl.charBuffer(reader)), reader);
            }
        };

        protected DSLYamlComment(char separatorChar, char quoteChar, char escapeChar, int bufferSize, int skip, int limit, int maxBufferSize, AbstractDSL.StringPostProcessing stringPostProcessing, org.simpleflatmapper.util.Function<? super CellConsumer, ? extends CellConsumer> cellConsumerWrapper, boolean yamlComment, boolean parallelReader, boolean specialisedCharConsumer) {
            super(separatorChar, quoteChar, escapeChar, bufferSize, skip, limit, maxBufferSize, stringPostProcessing, cellConsumerWrapper, yamlComment, parallelReader, specialisedCharConsumer);
        }

        private CsvReader rawReader(CharBuffer charBuffer) throws IOException {
            CsvReader csvReader = new CsvReader(this.charConsumer(charBuffer), null);
            csvReader.skipRows(this.skip);
            return csvReader;
        }

        public void forEach(Reader reader, CheckedConsumer<String[]> rowConsumer, CheckedConsumer<String> commentConsumer) throws IOException {
            this._forEach(this.rawReader(this.charBuffer(reader)), rowConsumer, commentConsumer);
        }

        public void forEach(CharSequence content, CheckedConsumer<String[]> rowConsumer, CheckedConsumer<String> commentConsumer) throws IOException {
            this._forEach(this.rawReader(this.charBuffer(content)), rowConsumer, commentConsumer);
        }

        public void forEach(String content, CheckedConsumer<String[]> rowConsumer, CheckedConsumer<String> commentConsumer) throws IOException {
            this._forEach(this.rawReader(this.charBuffer(content)), rowConsumer, commentConsumer);
        }

        private void _forEach(CsvReader reader, CheckedConsumer<String[]> rowConsumer, CheckedConsumer<String> commentConsumer) throws IOException {
            reader.parseAll(this.newYamlCellConsumer(rowConsumer, commentConsumer));
        }

        private YamlCellPreProcessor.YamlCellConsumer newYamlCellConsumer(CheckedConsumer<String[]> rowConsumer, CheckedConsumer<String> commentConsumer) {
            TextFormat textFormat = this.getTextFormat();
            return new YamlCellPreProcessor.YamlCellConsumer(StringArrayCellConsumer.newInstance(rowConsumer), YamlCellPreProcessor.commentConsumerToCellConsumer(commentConsumer), this.superGetCellTransformer(textFormat, this.stringPostProcessing));
        }

        private CellPreProcessor superGetCellTransformer(TextFormat textFormat, AbstractDSL.StringPostProcessing stringPostProcessing) {
            return super.getCellTransformer(textFormat, stringPostProcessing);
        }

        @Override
        protected CellPreProcessor getCellTransformer(TextFormat textFormat, AbstractDSL.StringPostProcessing stringPostProcessing) {
            return new YamlCellPreProcessor(stringPostProcessing == AbstractDSL.StringPostProcessing.TRIM_AND_UNESCAPE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forEach(File file, CheckedConsumer<String[]> rowConsumer, CheckedConsumer<String> commentConsumer) throws IOException {
            try (CloseableCsvReader csvReader = this.rawReader(file);){
                csvReader.parseAll(this.newYamlCellConsumer(rowConsumer, commentConsumer));
            }
        }

        private final CloseableCsvReader rawReader(File file) throws IOException {
            return CsvParser.onReader(file, this, CREATE_CLOSEABLE_CSV_RAW_READER);
        }

        @Override
        protected DSLYamlComment newDSL(char separatorChar, char quoteChar, char escapeChar, int bufferSize, int skip, int limit, int maxBufferSize, AbstractDSL.StringPostProcessing stringPostProcessing, org.simpleflatmapper.util.Function<? super CellConsumer, ? extends CellConsumer> cellConsumerWrapper, boolean yamlComment, boolean parallelReader, boolean specialisedCharConsumer) {
            return new DSLYamlComment(separatorChar, quoteChar, escapeChar, bufferSize, skip, limit, maxBufferSize, stringPostProcessing, cellConsumerWrapper, yamlComment, parallelReader, specialisedCharConsumer);
        }
    }
}

