/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.parser;

import org.simpleflatmapper.csv.parser.CellConsumer;
import org.simpleflatmapper.csv.parser.CharBuffer;
import org.simpleflatmapper.csv.parser.UnescapeCharConsumer;

public class TrimAndUnescapeCharConsumer
extends UnescapeCharConsumer {
    public TrimAndUnescapeCharConsumer(CharBuffer csvBuffer, char separatorChar, char escapeChar) {
        super(csvBuffer, separatorChar, escapeChar);
    }

    @Override
    protected void newCell(int end, CellConsumer cellConsumer) {
        char[] chars = this.csvBuffer.getCharBuffer();
        int strStart = this.csvBuffer.getMark();
        int strEnd = end;
        if ((strStart = this.strStart(strStart, strEnd = this.strEnd(strStart, strEnd, chars), chars)) < strEnd && chars[strStart] == this.escapeChar) {
            strEnd = this.unescape(chars, ++strStart, strEnd);
        }
        cellConsumer.newCell(chars, strStart, strEnd - strStart);
        this.csvBuffer.mark(end + 1);
    }

    private int strEnd(int start, int end, char[] chars) {
        while (start < end && chars[end - 1] == ' ') {
            --end;
        }
        return end;
    }

    private int strStart(int start, int end, char[] chars) {
        while (start < end && chars[start] == ' ') {
            ++start;
        }
        return start;
    }
}

