/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.impl;

import java.lang.reflect.Type;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.simpleflatmapper.converter.Converter;
import org.simpleflatmapper.converter.ConverterService;
import org.simpleflatmapper.csv.CellValueReader;
import org.simpleflatmapper.csv.CellValueReaderFactory;
import org.simpleflatmapper.csv.CsvColumnDefinition;
import org.simpleflatmapper.csv.ParsingContextFactoryBuilder;
import org.simpleflatmapper.csv.impl.cellreader.BooleanCellValueReaderImpl;
import org.simpleflatmapper.csv.impl.cellreader.ByteCellValueReaderImpl;
import org.simpleflatmapper.csv.impl.cellreader.CalendarCellValueReader;
import org.simpleflatmapper.csv.impl.cellreader.CharCellValueReaderImpl;
import org.simpleflatmapper.csv.impl.cellreader.CharSequenceConverterCellValueReader;
import org.simpleflatmapper.csv.impl.cellreader.DateCellValueReader;
import org.simpleflatmapper.csv.impl.cellreader.DateMultiFormatCellValueReader;
import org.simpleflatmapper.csv.impl.cellreader.DoubleCellValueReaderImpl;
import org.simpleflatmapper.csv.impl.cellreader.EnumCellValueReader;
import org.simpleflatmapper.csv.impl.cellreader.FloatCellValueReaderImpl;
import org.simpleflatmapper.csv.impl.cellreader.IntegerCellValueReaderImpl;
import org.simpleflatmapper.csv.impl.cellreader.LongCellValueReaderImpl;
import org.simpleflatmapper.csv.impl.cellreader.ShortCellValueReaderImpl;
import org.simpleflatmapper.csv.impl.cellreader.StringCellValueReader;
import org.simpleflatmapper.csv.impl.cellreader.UUIDCellValueReader;
import org.simpleflatmapper.util.TypeHelper;

public final class CellValueReaderFactoryImpl
implements CellValueReaderFactory {
    private static final Map<Class<?>, CellValueReader<?>> READERS = new HashMap();
    private ConverterService converterService = ConverterService.getInstance();

    @Override
    public <P> CellValueReader<P> getReader(Type propertyType, int index, CsvColumnDefinition columnDefinition, ParsingContextFactoryBuilder parsingContextFactoryBuilder) {
        Converter converter;
        Class propertyClass = TypeHelper.toClass((Type)propertyType);
        CellValueReader<Object> reader = null;
        if (propertyClass.equals(Date.class)) {
            String[] patterns = columnDefinition.dateFormats();
            if (patterns.length == 1) {
                DateCellValueReader dateCellValueReader = new DateCellValueReader(index, patterns[0], columnDefinition.getTimeZone());
                reader = dateCellValueReader;
                parsingContextFactoryBuilder.addParsingContextProvider(index, dateCellValueReader);
            } else {
                DateMultiFormatCellValueReader dateCellValueReader = new DateMultiFormatCellValueReader(index, patterns, columnDefinition.getTimeZone());
                reader = dateCellValueReader;
                parsingContextFactoryBuilder.addParsingContextProvider(index, dateCellValueReader);
            }
        } else if (Calendar.class.equals((Object)propertyClass)) {
            reader = new CalendarCellValueReader(this.getReader((Type)((Object)Date.class), index, columnDefinition, parsingContextFactoryBuilder));
        } else if (Enum.class.isAssignableFrom(propertyClass)) {
            reader = new EnumCellValueReader(propertyClass);
        } else if (UUID.class.equals((Object)propertyClass)) {
            reader = new UUIDCellValueReader();
        }
        if (reader == null) {
            reader = this.getCellValueTransformer(propertyClass);
        }
        if (reader == null && (converter = this.converterService.findConverter(CharSequence.class, propertyType, columnDefinition != null ? columnDefinition.properties() : new Object[]{})) != null) {
            return new CharSequenceConverterCellValueReader(converter);
        }
        return reader;
    }

    private <P> CellValueReader<P> getCellValueTransformer(Class<? extends P> propertyType) {
        return READERS.get(propertyType);
    }

    static {
        READERS.put(Boolean.TYPE, new BooleanCellValueReaderImpl());
        READERS.put(Byte.TYPE, new ByteCellValueReaderImpl());
        READERS.put(Character.TYPE, new CharCellValueReaderImpl());
        READERS.put(Short.TYPE, new ShortCellValueReaderImpl());
        READERS.put(Integer.TYPE, new IntegerCellValueReaderImpl());
        READERS.put(Long.TYPE, new LongCellValueReaderImpl());
        READERS.put(Float.TYPE, new FloatCellValueReaderImpl());
        READERS.put(Double.TYPE, new DoubleCellValueReaderImpl());
        READERS.put(Boolean.class, new BooleanCellValueReaderImpl());
        READERS.put(Byte.class, new ByteCellValueReaderImpl());
        READERS.put(Character.class, new CharCellValueReaderImpl());
        READERS.put(Short.class, new ShortCellValueReaderImpl());
        READERS.put(Integer.class, new IntegerCellValueReaderImpl());
        READERS.put(Long.class, new LongCellValueReaderImpl());
        READERS.put(Float.class, new FloatCellValueReaderImpl());
        READERS.put(Double.class, new DoubleCellValueReaderImpl());
        READERS.put(String.class, new StringCellValueReader());
        READERS.put(CharSequence.class, new StringCellValueReader());
        READERS.put(Object.class, new StringCellValueReader());
    }
}

