/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.impl.cellreader;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.TimeZone;
import org.simpleflatmapper.csv.CellValueReader;
import org.simpleflatmapper.csv.ParsingContext;
import org.simpleflatmapper.csv.impl.ParsingException;
import org.simpleflatmapper.map.ParsingContextProvider;
import org.simpleflatmapper.util.Asserts;

public class DateMultiFormatCellValueReader
implements CellValueReader<Date>,
ParsingContextProvider {
    private final int index;
    private final DateFormat[] sdf;

    public DateMultiFormatCellValueReader(int index, String[] pattern, TimeZone timeZone) {
        this.index = index;
        this.sdf = new SimpleDateFormat[pattern.length];
        for (int i = 0; i < this.sdf.length; ++i) {
            this.sdf[i] = new SimpleDateFormat(pattern[i]);
            this.sdf[i].setTimeZone((TimeZone)Asserts.requireNonNull((String)"timeZone", (Object)timeZone));
        }
    }

    @Override
    public Date read(char[] chars, int offset, int length, ParsingContext parsingContext) {
        if (length == 0) {
            return null;
        }
        String str = new String(chars, offset, length);
        DateFormat[] dfs = (DateFormat[])parsingContext.getContext(this.index);
        for (int i = dfs.length - 1; i >= 0; --i) {
            try {
                return dfs[i].parse(str);
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        throw new ParsingException("Unable to parse date '" + str + "'");
    }

    public Object newContext() {
        DateFormat[] formats = new DateFormat[this.sdf.length];
        for (int i = 0; i < this.sdf.length; ++i) {
            formats[i] = (DateFormat)this.sdf[i].clone();
        }
        return formats;
    }

    public String toString() {
        return "DateMultiFormatCellValueReader{index=" + this.index + ", sdf=" + Arrays.toString(this.sdf) + '}';
    }
}

