/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.parser;

import org.simpleflatmapper.csv.parser.CellConsumer;
import org.simpleflatmapper.csv.parser.CellPreProcessor;
import org.simpleflatmapper.csv.parser.CharBuffer;
import org.simpleflatmapper.csv.parser.CharConsumer;
import org.simpleflatmapper.csv.parser.TextFormat;

public final class ConfigurableCharConsumer
extends CharConsumer {
    private final char escapeChar;
    private final char separatorChar;
    private final CellPreProcessor cellPreProcessor;
    private final boolean notIgnoringLeadingSpace;

    public ConfigurableCharConsumer(CharBuffer csvBuffer, TextFormat textFormat, CellPreProcessor cellPreProcessor) {
        super(csvBuffer);
        this.cellPreProcessor = cellPreProcessor;
        this.escapeChar = textFormat.getEscapeChar();
        this.separatorChar = textFormat.getSeparatorChar();
        this.notIgnoringLeadingSpace = !cellPreProcessor.ignoreLeadingSpace();
    }

    @Override
    protected final boolean isSeparator(char character) {
        return character == this.separatorChar;
    }

    @Override
    protected final boolean isNotEscapeCharacter(char character) {
        return character != this.escapeChar;
    }

    @Override
    protected void pushCell(char[] chars, int start, int end, CellConsumer cellConsumer) {
        this.cellPreProcessor.newCell(chars, start, end, cellConsumer);
    }

    @Override
    protected boolean isNotIgnoringLeadingSpace() {
        return this.notIgnoringLeadingSpace;
    }
}

