/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.parser;

import java.io.IOException;
import org.simpleflatmapper.csv.parser.CellConsumer;
import org.simpleflatmapper.csv.parser.CellPreProcessor;
import org.simpleflatmapper.csv.parser.CharBuffer;
import org.simpleflatmapper.csv.parser.TextFormat;

public final class CharConsumer {
    private static final int DATA = 16;
    private static final int ESCAPED = 8;
    private static final int LAST_CHAR_WAS_SEPARATOR = 4;
    private static final int LAST_CHAR_WAS_CR = 2;
    private static final int ESCAPED_AREA = 1;
    private static final int NONE = 0;
    private static final int TURN_OFF_LAST_CHAR_MASK = -7;
    private static final int TURN_OFF_ESCAPED_AREA = -2;
    private static final char LF = '\n';
    private static final char CR = '\r';
    private static final char SPACE = ' ';
    private final CharBuffer csvBuffer;
    private final TextFormat textFormat;
    private final CellPreProcessor cellPreProcessor;
    private int _currentIndex = 0;
    private int _currentState = 0;

    public CharConsumer(CharBuffer csvBuffer, TextFormat textFormat, CellPreProcessor cellPreProcessor) {
        this.csvBuffer = csvBuffer;
        this.cellPreProcessor = cellPreProcessor;
        this.textFormat = textFormat;
    }

    public final void consumeAllBuffer(CellConsumer cellConsumer) {
        boolean notIgnoreLeadingSpace = !this.cellPreProcessor.ignoreLeadingSpace();
        char escapeChar = this.textFormat.escapeChar;
        char separatorChar = this.textFormat.separatorChar;
        int currentState = this._currentState;
        int currentIndex = this._currentIndex;
        char[] chars = this.csvBuffer.buffer;
        int bufferSize = this.csvBuffer.bufferSize;
        block0: while (currentIndex < bufferSize) {
            if ((currentState & 1) == 0) {
                while (currentIndex < bufferSize) {
                    char character = chars[currentIndex];
                    int cellEnd = currentIndex++;
                    if (character == separatorChar) {
                        this.cellPreProcessor.newCell(chars, this.csvBuffer.mark, cellEnd, cellConsumer);
                        this.csvBuffer.mark = currentIndex;
                        currentState = 4;
                        continue;
                    }
                    if (character == '\n') {
                        if ((currentState & 2) == 0) {
                            this.cellPreProcessor.newCell(chars, this.csvBuffer.mark, cellEnd, cellConsumer);
                            cellConsumer.endOfRow();
                        }
                        this.csvBuffer.mark = currentIndex;
                        currentState = 0;
                        continue;
                    }
                    if (character == '\r') {
                        this.cellPreProcessor.newCell(chars, this.csvBuffer.mark, cellEnd, cellConsumer);
                        this.csvBuffer.mark = currentIndex;
                        currentState = 2;
                        cellConsumer.endOfRow();
                        continue;
                    }
                    if (character == escapeChar && ((currentState ^ 0x10) & 0x18) != 0) {
                        currentState = 9;
                        continue block0;
                    }
                    currentState &= 0xFFFFFFF9;
                    if (!notIgnoreLeadingSpace && character == ' ') continue;
                    currentState |= 0x10;
                }
                continue;
            }
            int nextEscapeChar = this.findNextEscapeChar(chars, currentIndex, bufferSize, escapeChar);
            if (nextEscapeChar >= 0) {
                currentIndex = nextEscapeChar + 1;
                currentState &= 0xFFFFFFFE;
                continue;
            }
            currentIndex = bufferSize;
        }
        this._currentState = currentState;
        this._currentIndex = currentIndex;
    }

    public final boolean consumeToNextRow(CellConsumer cellConsumer) {
        boolean notIgnoreLeadingSpace = !this.cellPreProcessor.ignoreLeadingSpace();
        char escapeChar = this.textFormat.escapeChar;
        char separatorChar = this.textFormat.separatorChar;
        int currentState = this._currentState;
        int currentIndex = this._currentIndex;
        char[] chars = this.csvBuffer.buffer;
        int bufferSize = this.csvBuffer.bufferSize;
        block0: while (currentIndex < bufferSize) {
            if ((currentState & 1) == 0) {
                while (currentIndex < bufferSize) {
                    char character = chars[currentIndex];
                    int cellEnd = currentIndex++;
                    if (character == separatorChar) {
                        this.cellPreProcessor.newCell(chars, this.csvBuffer.mark, cellEnd, cellConsumer);
                        this.csvBuffer.mark = currentIndex;
                        currentState = 4;
                        continue;
                    }
                    if (character == '\n') {
                        if ((currentState & 2) == 0) {
                            this.cellPreProcessor.newCell(chars, this.csvBuffer.mark, cellEnd, cellConsumer);
                            if (cellConsumer.endOfRow()) {
                                this.csvBuffer.mark = currentIndex;
                                this._currentState = 0;
                                this._currentIndex = currentIndex;
                                return true;
                            }
                        }
                        this.csvBuffer.mark = currentIndex;
                        currentState = 0;
                        continue;
                    }
                    if (character == '\r') {
                        this.cellPreProcessor.newCell(chars, this.csvBuffer.mark, cellEnd, cellConsumer);
                        this.csvBuffer.mark = currentIndex;
                        currentState = 2;
                        if (!cellConsumer.endOfRow()) continue;
                        this._currentState = currentState;
                        this._currentIndex = currentIndex;
                        return true;
                    }
                    if (character == escapeChar && ((currentState ^ 0x10) & 0x18) != 0) {
                        currentState = 9;
                        continue block0;
                    }
                    currentState &= 0xFFFFFFF9;
                    if (!notIgnoreLeadingSpace && character == ' ') continue;
                    currentState |= 0x10;
                }
                continue;
            }
            int nextEscapeChar = this.findNextEscapeChar(chars, currentIndex, bufferSize, escapeChar);
            if (nextEscapeChar >= 0) {
                currentIndex = nextEscapeChar + 1;
                currentState &= 0xFFFFFFFE;
                continue;
            }
            currentIndex = bufferSize;
        }
        this._currentState = currentState;
        this._currentIndex = currentIndex;
        return false;
    }

    private int findNextEscapeChar(char[] chars, int currentIndex, int bufferSize, char escapeChar) {
        for (int i = currentIndex; i < bufferSize; ++i) {
            if (chars[i] != escapeChar) continue;
            return i;
        }
        return -1;
    }

    public final void finish(CellConsumer cellConsumer) {
        if (this.hasUnconsumedData() || (this._currentState & 4) != 0) {
            this.cellPreProcessor.newCell(this.csvBuffer.buffer, this.csvBuffer.mark, this._currentIndex, cellConsumer);
            this.csvBuffer.mark = this._currentIndex + 1;
            this._currentState = 0;
        }
        cellConsumer.end();
    }

    private boolean hasUnconsumedData() {
        return this._currentIndex > this.csvBuffer.mark;
    }

    public boolean next() throws IOException {
        int mark = this.csvBuffer.mark;
        boolean b = this.csvBuffer.next();
        this._currentIndex -= mark - this.csvBuffer.mark;
        return b;
    }
}

