/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.parser;

import org.simpleflatmapper.csv.parser.CellConsumer;
import org.simpleflatmapper.csv.parser.CellPreProcessor;
import org.simpleflatmapper.csv.parser.TextFormat;

public class UnescapeCellPreProcessor
extends CellPreProcessor {
    private final TextFormat textFormat;

    public UnescapeCellPreProcessor(TextFormat textFormat) {
        this.textFormat = textFormat;
    }

    @Override
    public final void newCell(char[] chars, int start, int end, CellConsumer cellConsumer) {
        int strStart = start;
        int strEnd = end;
        char escapeChar = this.textFormat.escapeChar;
        if (strStart < strEnd && chars[strStart] == escapeChar) {
            strEnd = this.unescape(chars, ++strStart, strEnd, escapeChar);
        }
        cellConsumer.newCell(chars, strStart, strEnd - strStart);
    }

    private int unescape(char[] chars, int start, int end, int escapeChar) {
        for (int i = start; i < end - 1; ++i) {
            if (chars[i] != escapeChar) continue;
            return this.removeEscapeChars(chars, end, i, escapeChar);
        }
        if (start < end && chars[end - 1] == escapeChar) {
            return end - 1;
        }
        return end;
    }

    private int removeEscapeChars(char[] chars, int end, int firstEscapeChar, int escapeChar) {
        int destIndex = firstEscapeChar;
        boolean escaped = true;
        for (int sourceIndex = firstEscapeChar + 1; sourceIndex < end; ++sourceIndex) {
            char c = chars[sourceIndex];
            if (c != escapeChar || escaped) {
                chars[destIndex++] = c;
                escaped = false;
                continue;
            }
            escaped = true;
        }
        return destIndex;
    }

    @Override
    public final boolean ignoreLeadingSpace() {
        return false;
    }
}

