/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.impl.getter;

import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.simpleflatmapper.converter.Context;
import org.simpleflatmapper.map.getter.ContextualGetter;
import org.simpleflatmapper.reflect.Getter;

public class ArrayResultSetGetter<T>
implements Getter<ResultSet, T[]>,
ContextualGetter<ResultSet, T[]> {
    public static final int VALUE_INDEX = 2;
    private final int index;
    private final Getter<ResultSet, T> getter;
    private final T[] emptyArray;

    public ArrayResultSetGetter(Class<T> componentType, Getter<ResultSet, T> getter, int index) {
        this.getter = getter;
        this.index = index;
        this.emptyArray = (Object[])Array.newInstance(componentType, 0);
    }

    public T[] get(ResultSet resultSet, Context context) throws Exception {
        return this.get(resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T[] get(ResultSet target) throws Exception {
        java.sql.Array sqlArray = target.getArray(this.index);
        if (sqlArray != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            ResultSet rs = sqlArray.getResultSet();
            try {
                while (rs.next()) {
                    list.add(this.getter.get((Object)rs));
                }
            }
            finally {
                rs.close();
            }
            return list.toArray(this.emptyArray);
        }
        return null;
    }
}

