/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.simpleflatmapper.reflect.meta.AliasProvider;
import org.simpleflatmapper.reflect.meta.Table;
import org.simpleflatmapper.util.ErrorHelper;

public class JakartaAliasProvider
implements AliasProvider {
    private final Class<? extends Annotation> columnClass;
    private final Method columnName;
    private final Class<? extends Annotation> tableClass;
    private final Method tableName;
    private final Method tableSchema;
    private final Method tableCatalog;

    public JakartaAliasProvider() {
        Class<?> columnClass = null;
        Method columnName = null;
        Class<?> tableClass = null;
        Method tableName = null;
        Method tableSchema = null;
        Method tableCatalog = null;
        try {
            columnClass = Class.forName("jakarta.persistence.Column");
            columnName = columnClass.getDeclaredMethod("name", new Class[0]);
            tableClass = Class.forName("jakarta.persistence.Table");
            tableName = tableClass.getDeclaredMethod("name", new Class[0]);
            tableSchema = tableClass.getDeclaredMethod("schema", new Class[0]);
            tableCatalog = tableClass.getDeclaredMethod("catalog", new Class[0]);
        }
        catch (Exception e) {
            ErrorHelper.rethrow((Throwable)e);
        }
        this.columnClass = columnClass;
        this.columnName = columnName;
        this.tableClass = tableClass;
        this.tableName = tableName;
        this.tableSchema = tableSchema;
        this.tableCatalog = tableCatalog;
    }

    public String getAliasForMethod(Method method) {
        String alias = null;
        Annotation col = method.getAnnotation(this.columnClass);
        if (col != null) {
            alias = this.getColumnName(col);
        }
        return alias;
    }

    private String getColumnName(Object col) {
        return this.getString(col, this.columnName);
    }

    private String getTableName(Object col) {
        return this.getString(col, this.tableName);
    }

    private String getTableSchema(Object col) {
        return this.getString(col, this.tableSchema);
    }

    private String getTableCatalog(Object col) {
        return this.getString(col, this.tableCatalog);
    }

    private String getString(Object col, Method method) {
        try {
            return (String)method.invoke(col, new Object[0]);
        }
        catch (Exception e) {
            return (String)ErrorHelper.rethrow((Throwable)e);
        }
    }

    public String getAliasForField(Field field) {
        String alias = null;
        Annotation col = field.getAnnotation(this.columnClass);
        if (col != null) {
            alias = this.getColumnName(col);
        }
        return alias;
    }

    public Table getTable(Class<?> target) {
        Table table = Table.NULL;
        Annotation annotation = target.getAnnotation(this.tableClass);
        if (annotation != null) {
            table = new Table(this.getTableCatalog(annotation), this.getTableSchema(annotation), this.getTableName(annotation));
        }
        return table;
    }
}

