/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jooq;

import java.lang.reflect.Type;
import java.sql.Array;
import java.util.List;
import org.jooq.Field;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.reflect.TypeAffinity;
import org.simpleflatmapper.util.TypeHelper;

public class JooqFieldKey
extends FieldKey<JooqFieldKey>
implements TypeAffinity {
    private final Field<?> field;
    private final Type targetType;

    public JooqFieldKey(Field<?> field, int index) {
        super(field.getName(), index);
        this.field = field;
        this.targetType = null;
    }

    public JooqFieldKey(Field<?> field, int index, Type targetType) {
        super(field.getName(), index);
        this.field = field;
        this.targetType = targetType;
    }

    public JooqFieldKey(String alias, Field<?> field, int index, JooqFieldKey parent) {
        super(alias, index, (FieldKey)parent);
        this.field = field;
        this.targetType = parent.targetType;
    }

    public JooqFieldKey alias(String alias) {
        return new JooqFieldKey(alias, this.field, this.index, this);
    }

    public Field<?> getField() {
        return this.field;
    }

    public String toString() {
        return "JooqFieldKey{field=" + this.field + ", index=" + this.index + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        JooqFieldKey that = (JooqFieldKey)((Object)o);
        if (this.index != that.index) {
            return false;
        }
        if (!this.field.equals(that.field)) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public Type getType(Type targetType) {
        if (this.targetType != null) {
            return this.targetType;
        }
        Class type = this.field.getType();
        if (Object.class.equals((Object)type)) {
            if (TypeHelper.isArray((Type)targetType)) {
                return Array.class;
            }
            if (TypeHelper.isAssignable(List.class, (Type)targetType)) {
                return Array.class;
            }
            if (TypeHelper.isAssignable(Array.class, (Type)targetType)) {
                return Array.class;
            }
        }
        return type;
    }

    public int hashCode() {
        int result = this.field.hashCode();
        result = 31 * result + this.index;
        return result;
    }

    public Class<?>[] getAffinities() {
        return new Class[]{this.field.getType()};
    }
}

