/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.poi.impl;

import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.simpleflatmapper.map.ConsumerErrorHandler;
import org.simpleflatmapper.map.ContextualSourceFieldMapper;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.MappingException;
import org.simpleflatmapper.map.SourceFieldMapper;
import org.simpleflatmapper.map.context.MappingContextFactory;
import org.simpleflatmapper.poi.RowMapper;
import org.simpleflatmapper.poi.impl.SheetEnumerable;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.Enumerable;
import org.simpleflatmapper.util.EnumerableIterator;
import org.simpleflatmapper.util.EnumerableSpliterator;

public class StaticSheetMapper<T>
implements RowMapper<T>,
SourceFieldMapper<Row, T> {
    private final ContextualSourceFieldMapper<Row, T> mapper;
    private final int startRow = 0;
    private final ConsumerErrorHandler consumerErrorHandler;
    private final MappingContextFactory<? super Row> mappingContextFactory;

    public StaticSheetMapper(ContextualSourceFieldMapper<Row, T> mapper, ConsumerErrorHandler consumerErrorHandler, MappingContextFactory<? super Row> mappingContextFactory) {
        this.mapper = mapper;
        this.consumerErrorHandler = consumerErrorHandler;
        this.mappingContextFactory = mappingContextFactory;
    }

    @Override
    public Iterator<T> iterator(Sheet sheet) {
        return this.iterator(0, sheet);
    }

    @Override
    public Iterator<T> iterator(int startRow, Sheet sheet) {
        return new EnumerableIterator(new SheetEnumerable(this, startRow, sheet, (MappingContext<? super Row>)this.newMappingContext()));
    }

    @Override
    public Enumerable<T> enumerate(Sheet sheet) {
        return this.enumerate(0, sheet);
    }

    @Override
    public Enumerable<T> enumerate(int startRow, Sheet sheet) {
        return new SheetEnumerable(this, startRow, sheet, (MappingContext<? super Row>)this.newMappingContext());
    }

    @Override
    public <RH extends CheckedConsumer<? super T>> RH forEach(Sheet sheet, RH consumer) {
        return this.forEach(0, sheet, consumer);
    }

    @Override
    public <RH extends CheckedConsumer<? super T>> RH forEach(int startRow, Sheet sheet, RH consumer) {
        MappingContext<Row> mappingContext = this.newMappingContext();
        ContextualSourceFieldMapper<Row, T> lMapper = this.mapper;
        for (int rowNum = startRow; rowNum <= sheet.getLastRowNum(); ++rowNum) {
            Row row = sheet.getRow(rowNum);
            if (row == null) continue;
            Object object = lMapper.map((Object)row, mappingContext);
            try {
                consumer.accept(object);
                continue;
            }
            catch (Exception e) {
                this.consumerErrorHandler.handlerError((Throwable)e, object);
            }
        }
        return consumer;
    }

    @Override
    public Stream<T> stream(Sheet sheet) {
        return this.stream(0, sheet);
    }

    @Override
    public Stream<T> stream(int startRow, Sheet sheet) {
        return StreamSupport.stream(new EnumerableSpliterator(new SheetEnumerable(this, startRow, sheet, (MappingContext<? super Row>)this.newMappingContext())), false);
    }

    public T map(Row source) throws MappingException {
        return (T)this.mapper.map((Object)source);
    }

    public T map(Row source, MappingContext<? super Row> context) throws MappingException {
        return (T)this.mapper.map((Object)source, context);
    }

    public void mapTo(Row source, T target, MappingContext<? super Row> context) throws Exception {
        this.mapper.mapTo((Object)source, target, context);
    }

    private MappingContext<? super Row> newMappingContext() {
        return this.mappingContextFactory.newContext();
    }
}

