/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.poi.impl;

import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.MappingException;
import org.simpleflatmapper.map.TransformEnumerable;
import org.simpleflatmapper.poi.RowMapper;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.Enumerable;
import org.simpleflatmapper.util.Function;
import org.simpleflatmapper.util.TransformCheckedConsumer;
import org.simpleflatmapper.util.TransformIterator;

public class TransformRowMapper<I, O>
implements RowMapper<O> {
    private final Function<I, O> transform;
    private final RowMapper<I> delegate;

    public TransformRowMapper(RowMapper<I> delegate, Function<I, O> transform) {
        this.delegate = delegate;
        this.transform = transform;
    }

    public O map(Row source) throws MappingException {
        return (O)this.transform.apply(this.delegate.map(source));
    }

    public O map(Row source, MappingContext<? super Row> context) throws MappingException {
        return (O)this.transform.apply(this.delegate.map(source, context));
    }

    @Override
    public Iterator<O> iterator(Sheet sheet) {
        return new TransformIterator(this.delegate.iterator(sheet), this.transform);
    }

    @Override
    public Iterator<O> iterator(int startRow, Sheet sheet) {
        return new TransformIterator(this.delegate.iterator(startRow, sheet), this.transform);
    }

    @Override
    public Enumerable<O> enumerate(Sheet sheet) {
        return new TransformEnumerable(this.delegate.enumerate(sheet), this.transform);
    }

    @Override
    public Enumerable<O> enumerate(int startRow, Sheet sheet) {
        return new TransformEnumerable(this.delegate.enumerate(startRow, sheet), this.transform);
    }

    @Override
    public <RH extends CheckedConsumer<? super O>> RH forEach(Sheet sheet, RH consumer) {
        this.delegate.forEach(sheet, new TransformCheckedConsumer(consumer, this.transform));
        return consumer;
    }

    @Override
    public <RH extends CheckedConsumer<? super O>> RH forEach(int startRow, Sheet sheet, RH consumer) {
        this.delegate.forEach(startRow, sheet, new TransformCheckedConsumer(consumer, this.transform));
        return consumer;
    }

    @Override
    public Stream<O> stream(Sheet sheet) {
        return this.delegate.stream(sheet).map(arg_0 -> this.transform.apply(arg_0));
    }

    @Override
    public Stream<O> stream(int startRow, Sheet sheet) {
        return this.delegate.stream(startRow, sheet).map(arg_0 -> this.transform.apply(arg_0));
    }
}

