/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.simpleflatmapper.reflect.BuilderInstantiatorDefinition;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.InstantiatorFactory;
import org.simpleflatmapper.reflect.ObjectGetterFactory;
import org.simpleflatmapper.reflect.ObjectSetterFactory;
import org.simpleflatmapper.reflect.ReflectionInstantiatorDefinitionFactory;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.asm.AsmFactory;
import org.simpleflatmapper.reflect.asm.AsmInstantiatorDefinitionFactory;
import org.simpleflatmapper.reflect.impl.BuilderInstantiatorDefinitionFactory;
import org.simpleflatmapper.reflect.impl.ImmutableOrgHelper;
import org.simpleflatmapper.reflect.impl.JavaLangClassMetaFactoryProducer;
import org.simpleflatmapper.reflect.instantiator.ExecutableInstantiatorDefinition;
import org.simpleflatmapper.reflect.instantiator.InstantiatorDefinitions;
import org.simpleflatmapper.reflect.instantiator.KotlinDefaultConstructorInstantiatorDefinition;
import org.simpleflatmapper.reflect.meta.AliasProvider;
import org.simpleflatmapper.reflect.meta.AliasProviderService;
import org.simpleflatmapper.reflect.meta.ArrayClassMeta;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.FastTupleClassMeta;
import org.simpleflatmapper.reflect.meta.MapClassMeta;
import org.simpleflatmapper.reflect.meta.ObjectClassMeta;
import org.simpleflatmapper.reflect.meta.PassThroughClassMeta;
import org.simpleflatmapper.reflect.meta.TupleClassMeta;
import org.simpleflatmapper.util.Asserts;
import org.simpleflatmapper.util.BiConsumer;
import org.simpleflatmapper.util.Consumer;
import org.simpleflatmapper.util.ProducerServiceLoader;
import org.simpleflatmapper.util.TupleHelper;
import org.simpleflatmapper.util.TypeHelper;
import org.simpleflatmapper.util.UnaryFactory;

public class DefaultReflectionService
extends ReflectionService {
    private static final UnaryFactory<ReflectionService, ClassMeta<?>>[] predefined = DefaultReflectionService.getPredifinedClassMetaFactory();
    private static final Consumer<BiConsumer<String, UnaryFactory<Type, Member>>>[] predefinedBuilderProducers = DefaultReflectionService.getPredifinedBuilderProducers();
    private final AliasProvider aliasProvider;
    private final boolean builderIgnoresNullValues;
    private final ConcurrentMap<Type, ClassMeta<?>> metaCache = new ConcurrentHashMap();
    private final ConcurrentMap<String, UnaryFactory<Type, Member>> builderMethods = new ConcurrentHashMap<String, UnaryFactory<Type, Member>>();
    private final Map<ClassLoader, AsmFactory> asmFactoryPerClassLoader;
    private final boolean isAsmActivated;

    public DefaultReflectionService(AsmFactory asmFactory) {
        this(asmFactory != null, DefaultReflectionService.defaultAsmFactortyPerClassLoader(asmFactory), AliasProviderService.getAliasProvider(), true);
    }

    private static Map<ClassLoader, AsmFactory> defaultAsmFactortyPerClassLoader(AsmFactory asmFactory) {
        HashMap<ClassLoader, AsmFactory> map = new HashMap<ClassLoader, AsmFactory>();
        if (asmFactory != null) {
            map.put(asmFactory.targetClassLoader, asmFactory);
        }
        return map;
    }

    private DefaultReflectionService(boolean isAsmActivated, Map<ClassLoader, AsmFactory> asmFactoryPerClassLoader, AliasProvider aliasProvider, boolean builderIgnoresNullValues) {
        this.isAsmActivated = isAsmActivated;
        this.asmFactoryPerClassLoader = asmFactoryPerClassLoader;
        this.aliasProvider = aliasProvider;
        this.builderIgnoresNullValues = builderIgnoresNullValues;
        this.initPredefined();
    }

    private void initPredefined() {
        for (UnaryFactory<ReflectionService, ClassMeta<?>> unaryFactory : predefined) {
            ClassMeta classMeta = (ClassMeta)unaryFactory.newInstance((Object)this);
            this.metaCache.put(classMeta.getType(), classMeta);
        }
        for (UnaryFactory<ReflectionService, ClassMeta<?>> unaryFactory : predefinedBuilderProducers) {
            unaryFactory.accept((Object)new BiConsumer<String, UnaryFactory<Type, Member>>(){

                public void accept(String s, UnaryFactory<Type, Member> typeMemberUnaryFactory) {
                    DefaultReflectionService.this.builderMethods.put(s, typeMemberUnaryFactory);
                }
            });
        }
    }

    @Override
    public void registerClassMeta(Type type, ClassMeta<?> classMeta) {
        this.metaCache.put(type, classMeta);
    }

    @Override
    public ObjectSetterFactory getObjectSetterFactory() {
        return new ObjectSetterFactory(this);
    }

    @Override
    public InstantiatorFactory getInstantiatorFactory() {
        return new InstantiatorFactory(this);
    }

    @Override
    public boolean isAsmActivated() {
        return this.isAsmActivated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsmFactory getAsmFactory(ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        if (!this.isAsmActivated) {
            return null;
        }
        Map<ClassLoader, AsmFactory> map = this.asmFactoryPerClassLoader;
        synchronized (map) {
            AsmFactory asmFactory = this.asmFactoryPerClassLoader.get(classLoader);
            if (asmFactory == null) {
                asmFactory = new AsmFactory(classLoader);
                this.asmFactoryPerClassLoader.put(classLoader, asmFactory);
            }
            return asmFactory;
        }
    }

    @Override
    public <T> ClassMeta<T> getClassMeta(Type target) {
        Asserts.requireNonNull((String)"target", (Object)target);
        ClassMeta<T> meta = (ClassMeta<T>)this.metaCache.get(target);
        if (meta == null) {
            meta = this.newClassMeta(target);
            Asserts.requireNonNull((String)"meta", meta);
            this.metaCache.putIfAbsent(target, meta);
        }
        return meta;
    }

    private <T> ClassMeta<T> newClassMeta(Type target) {
        Type[] upperBounds;
        Class clazz = TypeHelper.toClass((Type)target);
        if (target instanceof WildcardType && (upperBounds = ((WildcardType)target).getUpperBounds()).length == 1) {
            target = upperBounds[0];
        }
        if (clazz.isArray()) {
            return this.newArrayMeta(clazz);
        }
        if (clazz.isAnnotationPresent(ReflectionService.PassThrough.class)) {
            return new PassThroughClassMeta(target, this);
        }
        if (TupleHelper.isTuple((Type)target)) {
            return new TupleClassMeta(target, this);
        }
        if (this.isFastTuple(clazz)) {
            return new FastTupleClassMeta(target, this);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return this.newMapMeta(target);
        }
        if (ArrayClassMeta.supports(target)) {
            return this.newCollectionMeta(target);
        }
        if (this.isAbstractOrInterface(target)) {
            target = this.findImplementation(target);
        }
        return new ObjectClassMeta(target, this.getBuilderInstantiator(target), this);
    }

    private boolean isAbstractOrInterface(Type target) {
        Class clazz = TypeHelper.toClass((Type)target);
        return clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers());
    }

    private Type findImplementation(Type target) {
        Class clazz = TypeHelper.toClass((Type)target);
        Type implementation = ImmutableOrgHelper.findImplementation(clazz);
        if (implementation != null) {
            return implementation;
        }
        return target;
    }

    private Member getBuilderInstantiator(Type target) {
        String typeName = TypeHelper.toClass((Type)target).getName();
        UnaryFactory builderSupplier = (UnaryFactory)this.builderMethods.get(typeName);
        if (builderSupplier != null) {
            return (Member)builderSupplier.newInstance((Object)target);
        }
        return null;
    }

    @Override
    public <T> ClassMeta<T> getClassMetaExtraInstantiator(Type target, Member builderInstantiator) {
        return new ObjectClassMeta(target, builderInstantiator, this);
    }

    private <K, V> ClassMeta<Map<K, V>> newMapMeta(Type type) {
        TypeHelper.MapEntryTypes types = TypeHelper.getKeyValueTypeOfMap((Type)type);
        return new MapClassMeta(type, types.getKeyType(), types.getValueType(), this);
    }

    private <T, E> ClassMeta<T> newArrayMeta(Class<T> clazz) {
        return ArrayClassMeta.of(clazz, clazz.getComponentType(), this);
    }

    private <T, E> ClassMeta<T> newCollectionMeta(Type type) {
        return ArrayClassMeta.of(type, TypeHelper.getComponentTypeOfListOrArray((Type)type), this);
    }

    private <T> boolean isFastTuple(Class<T> clazz) {
        Class<T> superClass = clazz.getSuperclass();
        return superClass != null && "com.boundary.tuple.FastTuple".equals(superClass.getName());
    }

    @Override
    public String getColumnName(Method method) {
        return this.aliasProvider.getAliasForMethod(method);
    }

    @Override
    public String getColumnName(Field field) {
        return this.aliasProvider.getAliasForField(field);
    }

    @Override
    public List<InstantiatorDefinition> extractInstantiator(Type target, Member extraInstantiator) throws IOException {
        List<InstantiatorDefinition> list;
        if (!ReflectionInstantiatorDefinitionFactory.areParameterNamePresent(target)) {
            try {
                list = AsmInstantiatorDefinitionFactory.extractDefinitions(target);
            }
            catch (IllegalArgumentException e) {
                list = ReflectionInstantiatorDefinitionFactory.extractDefinitions(target);
            }
            catch (IOException e) {
                list = ReflectionInstantiatorDefinitionFactory.extractDefinitions(target);
            }
        } else {
            list = ReflectionInstantiatorDefinitionFactory.extractDefinitions(target);
        }
        if (TypeHelper.isKotlinClass((Type)target)) {
            this.kotlinReducationForDefaultValue(list);
        }
        if (extraInstantiator == null) {
            list.addAll(BuilderInstantiatorDefinitionFactory.extractDefinitions(target));
            if (list.isEmpty()) {
                for (Class<?> enclosing = TypeHelper.toClass((Type)target).getEnclosingClass(); enclosing != null; enclosing = enclosing.getEnclosingClass()) {
                    for (Method m : enclosing.getDeclaredMethods()) {
                        if (!Modifier.isPublic(m.getModifiers()) || !Modifier.isStatic(m.getModifiers()) || !TypeHelper.toClass((Type)target).isAssignableFrom(m.getReturnType())) continue;
                        list.add(ReflectionInstantiatorDefinitionFactory.definition(m));
                    }
                }
            }
        } else if (extraInstantiator instanceof Method && TypeHelper.areEquals((Type)target, (Type)((Method)extraInstantiator).getGenericReturnType())) {
            list.add(ReflectionInstantiatorDefinitionFactory.definition((Method)extraInstantiator));
        } else {
            BuilderInstantiatorDefinition builder = BuilderInstantiatorDefinitionFactory.getDefinitionForBuilder(extraInstantiator, target);
            if (builder == null) {
                throw new IllegalArgumentException("Could not find any setters or build method on builder " + extraInstantiator);
            }
            list.add(builder);
        }
        Collections.sort(list, InstantiatorDefinitions.COMPARATOR);
        return list;
    }

    private void kotlinReducationForDefaultValue(List<InstantiatorDefinition> list) {
        List<ExecutableInstantiatorDefinition> potentialKotlinDefaultValue = this.kotlingDefaultValueConstructor(list);
        if (potentialKotlinDefaultValue.isEmpty()) {
            return;
        }
        list.removeAll(potentialKotlinDefaultValue);
        block0: for (int i = 0; i < potentialKotlinDefaultValue.size(); ++i) {
            ExecutableInstantiatorDefinition def = potentialKotlinDefaultValue.get(i);
            for (int j = 0; j < list.size(); ++j) {
                InstantiatorDefinition id = list.get(j);
                if (!this.isKotlinOriginalConstructor(def, id)) continue;
                list.set(j, new KotlinDefaultConstructorInstantiatorDefinition((ExecutableInstantiatorDefinition)id, def));
                continue block0;
            }
        }
    }

    private List<ExecutableInstantiatorDefinition> kotlingDefaultValueConstructor(List<InstantiatorDefinition> list) {
        ArrayList<ExecutableInstantiatorDefinition> potentialKotlinDefaultValue = new ArrayList<ExecutableInstantiatorDefinition>();
        for (int i = 0; i < list.size(); ++i) {
            Class<?>[] parameterTypes;
            Constructor c;
            InstantiatorDefinition id = list.get(i);
            if (!(id instanceof ExecutableInstantiatorDefinition) || !(((ExecutableInstantiatorDefinition)id).getExecutable() instanceof Constructor) || !(c = (Constructor)((ExecutableInstantiatorDefinition)id).getExecutable()).isSynthetic() || !(parameterTypes = c.getParameterTypes())[parameterTypes.length - 1].getName().equals("kotlin.jvm.internal.DefaultConstructorMarker")) continue;
            potentialKotlinDefaultValue.add((ExecutableInstantiatorDefinition)id);
        }
        return potentialKotlinDefaultValue;
    }

    private boolean isKotlinOriginalConstructor(ExecutableInstantiatorDefinition def, InstantiatorDefinition id) {
        ExecutableInstantiatorDefinition eid;
        if (id instanceof ExecutableInstantiatorDefinition && (eid = (ExecutableInstantiatorDefinition)id).getExecutable() instanceof Constructor) {
            int i;
            int syntheticParameters;
            int nbParams = eid.getParameters().length;
            if (nbParams + (syntheticParameters = nbParams / 32 + 1 + 1) != def.getParameters().length) {
                return false;
            }
            for (i = 0; i < nbParams; ++i) {
                if (def.getParameters()[i].getType().equals(id.getParameters()[i].getType())) continue;
                return false;
            }
            for (i = nbParams; i < nbParams + syntheticParameters - 1; ++i) {
                if (def.getParameters()[i].getType().equals(Integer.TYPE)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public ObjectGetterFactory getObjectGetterFactory() {
        return new ObjectGetterFactory(this);
    }

    @Override
    public DefaultReflectionService withAliasProvider(AliasProvider aliasProvider) {
        return new DefaultReflectionService(this.isAsmActivated, this.asmFactoryPerClassLoader, aliasProvider, this.builderIgnoresNullValues);
    }

    @Override
    public DefaultReflectionService withBuilderIgnoresNullValues(boolean builderIgnoresNullValues) {
        return new DefaultReflectionService(this.isAsmActivated, this.asmFactoryPerClassLoader, this.aliasProvider, builderIgnoresNullValues);
    }

    @Override
    @Deprecated
    public DefaultReflectionService withSelfScoreFullName(boolean selfScoreFullName) {
        return this;
    }

    @Override
    public boolean builderIgnoresNullValues() {
        return this.builderIgnoresNullValues;
    }

    @Override
    @Deprecated
    public boolean selfScoreFullName() {
        return false;
    }

    @Override
    public void registerBuilder(String name, ReflectionService.DefaultBuilderSupplier defaultBuilderSupplier) {
        this.builderMethods.put(name, defaultBuilderSupplier);
    }

    private static Consumer<BiConsumer<String, UnaryFactory<Type, Member>>>[] getPredifinedBuilderProducers() {
        final ArrayList list = new ArrayList();
        Consumer<Consumer<BiConsumer<String, UnaryFactory<Type, Member>>>> consumer = new Consumer<Consumer<BiConsumer<String, UnaryFactory<Type, Member>>>>(){

            public void accept(Consumer<BiConsumer<String, UnaryFactory<Type, Member>>> biConsumerConsumer) {
                list.add(biConsumerConsumer);
            }
        };
        ProducerServiceLoader.produceFromServiceLoader(ServiceLoader.load(ReflectionService.BuilderProducer.class), (Consumer)consumer);
        consumer.accept((Object)new Consumer<BiConsumer<String, UnaryFactory<Type, Member>>>(){

            public void accept(BiConsumer<String, UnaryFactory<Type, Member>> biConsumer) {
                biConsumer.accept((Object)"javax.money.MonetaryAmount", (Object)new ReflectionService.DefaultBuilderSupplier("javax.money.Monetary", "getDefaultAmountFactory"));
            }
        });
        return list.toArray(new Consumer[0]);
    }

    private static UnaryFactory<ReflectionService, ClassMeta<?>>[] getPredifinedClassMetaFactory() {
        final ArrayList list = new ArrayList();
        Consumer consumer = new Consumer<UnaryFactory<ReflectionService, ClassMeta<?>>>(){

            public void accept(UnaryFactory<ReflectionService, ClassMeta<?>> reflectionServiceClassMetaUnaryFactory) {
                list.add(reflectionServiceClassMetaUnaryFactory);
            }
        };
        new JavaLangClassMetaFactoryProducer().produce(consumer);
        ProducerServiceLoader.produceFromServiceLoader(ServiceLoader.load(ReflectionService.ClassMetaFactoryProducer.class), (Consumer)consumer);
        return list.toArray(new UnaryFactory[0]);
    }
}

