/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.asm;

import java.lang.reflect.Member;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.simpleflatmapper.reflect.BuilderInstantiatorDefinition;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.Parameter;
import org.simpleflatmapper.reflect.asm.InjectedParam;
import org.simpleflatmapper.reflect.instantiator.ExecutableInstantiatorDefinition;

public class InstantiatorKey<S> {
    private final Object constructor;
    private final InjectedParam[] injectedParams;
    private final Class<?> source;

    public InstantiatorKey(Object constructor, InjectedParam[] injectedParams, Class<S> source) {
        this.constructor = constructor;
        this.injectedParams = injectedParams;
        this.source = source;
    }

    public InstantiatorKey(Class<?> target, Class<S> source) throws NoSuchMethodException, SecurityException {
        this(target.getConstructor(new Class[0]), null, source);
    }

    public InstantiatorKey(InstantiatorDefinition instantiatorDefinition, Map<Parameter, Getter<? super S, ?>> injections, Class<S> source) {
        this(InstantiatorKey.getConstructor(instantiatorDefinition), InstantiatorKey.paramAndGetterClass(injections), source);
    }

    private static Object getConstructor(InstantiatorDefinition def) {
        if (def instanceof ExecutableInstantiatorDefinition) {
            return ((ExecutableInstantiatorDefinition)def).getExecutable();
        }
        return ((BuilderInstantiatorDefinition)def).getBuildMethod();
    }

    private static <S> InjectedParam[] paramAndGetterClass(Map<Parameter, Getter<? super S, ?>> injections) {
        InjectedParam[] names = new InjectedParam[injections.size()];
        int i = 0;
        for (Map.Entry<Parameter, Getter<S, ?>> e : injections.entrySet()) {
            names[i++] = new InjectedParam(e.getKey().getName(), e.getValue().getClass());
        }
        Arrays.sort(names, new Comparator<InjectedParam>(){

            @Override
            public int compare(InjectedParam o1, InjectedParam o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return names;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.constructor == null ? 0 : this.constructor.hashCode());
        result = 31 * result + Arrays.hashCode(this.injectedParams);
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InstantiatorKey other = (InstantiatorKey)obj;
        if (this.constructor == null ? other.constructor != null : !this.constructor.equals(other.constructor)) {
            return false;
        }
        if (!Arrays.equals(this.injectedParams, other.injectedParams)) {
            return false;
        }
        return !(this.source == null ? other.source != null : !this.source.equals(other.source));
    }

    public Object getConstructor() {
        return this.constructor;
    }

    public String[] getInjectedParams() {
        if (this.injectedParams == null) {
            return new String[0];
        }
        String[] params = new String[this.injectedParams.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = this.injectedParams[i].getName();
        }
        return params;
    }

    public Class<?> getSource() {
        return this.source;
    }

    public Class<?> getDeclaringClass() {
        Object constructor = this.constructor;
        return InstantiatorKey.getDeclaringClass(constructor);
    }

    public static Class<?> getDeclaringClass(Object constructor) {
        if (constructor instanceof Member) {
            return ((Member)constructor).getDeclaringClass();
        }
        if (constructor instanceof ExecutableInstantiatorDefinition) {
            return ((ExecutableInstantiatorDefinition)constructor).getExecutable().getDeclaringClass();
        }
        return ((BuilderInstantiatorDefinition)constructor).getBuildMethod().getDeclaringClass();
    }

    public static Class<?> getDeclaringClass(InstantiatorDefinition definition) {
        return InstantiatorKey.getDeclaringClass(InstantiatorKey.getConstructor(definition));
    }
}

