/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.Instantiator;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.InstantiatorFactory;
import org.simpleflatmapper.reflect.ObjectGetterFactory;
import org.simpleflatmapper.reflect.Parameter;
import org.simpleflatmapper.reflect.ReflectionInstantiatorDefinitionFactory;
import org.simpleflatmapper.reflect.getter.ConstantGetter;
import org.simpleflatmapper.reflect.getter.GetterHelper;
import org.simpleflatmapper.reflect.meta.ClassVisitor;
import org.simpleflatmapper.reflect.meta.FieldAndMethodCallBack;
import org.simpleflatmapper.util.TypeHelper;

public class ParamNameDeductor<T> {
    private static final Map<Class<?>, Object> primitivesMarkValue = new HashMap();
    private static final Map<Class<?>, Object> primitivesNeutralValue;
    private final Class<T> target;
    private List<Accessor<T>> accessors;
    private final InstantiatorFactory instantiatorFactory = new InstantiatorFactory(null);

    public ParamNameDeductor(Class<T> target) {
        this.target = target;
    }

    public String findParamName(InstantiatorDefinition instantiatorDefinition, Parameter param, boolean builderIgnoresNullValues) {
        if (this.accessors == null) {
            this.accessors = this.listAccessors();
        }
        try {
            Object value;
            Map<Parameter, Getter<Object, ?>> parameters = this.parametersWithExpectedValue(instantiatorDefinition, param, true, builderIgnoresNullValues);
            Instantiator instantiator = this.instantiatorFactory.getInstantiator(instantiatorDefinition, Object.class, parameters, false, builderIgnoresNullValues);
            try {
                value = instantiator.newInstance(null);
            }
            catch (NullPointerException e) {
                parameters = this.parametersWithExpectedValue(instantiatorDefinition, param, false, builderIgnoresNullValues);
                instantiator = this.instantiatorFactory.getInstantiator(instantiatorDefinition, Object.class, parameters, false, builderIgnoresNullValues);
                value = instantiator.newInstance(null);
            }
            if (value != null) {
                Object expectedPropertyValue = parameters.get(param).get(null);
                for (Accessor<T> accessor : this.accessors) {
                    try {
                        Object propertyValue = accessor.getter.get(value);
                        if (!expectedPropertyValue.equals(propertyValue)) continue;
                        return accessor.name;
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Map<Parameter, Getter<? super Object, ?>> parametersWithExpectedValue(InstantiatorDefinition instantiatorDefinition, Parameter param, boolean allowNull, boolean builderIgnoresNullValues) throws Exception {
        Map<Parameter, Getter<Object, ?>> parameterGetterMap = this.parameters(instantiatorDefinition, allowNull, builderIgnoresNullValues);
        parameterGetterMap.put(param, new ConstantGetter(this.markValue(param.getGenericType(), builderIgnoresNullValues)));
        return parameterGetterMap;
    }

    private Map<Parameter, Getter<? super Object, ?>> parameters(InstantiatorDefinition instantiatorDefinition, boolean allowNull, boolean builderIgnoresNullValues) throws Exception {
        HashMap parameterGetterMap = new HashMap();
        for (Parameter parameter : instantiatorDefinition.getParameters()) {
            Object value = this.neutralValue(parameter.getGenericType(), allowNull, builderIgnoresNullValues);
            parameterGetterMap.put(parameter, new ConstantGetter(value));
        }
        return parameterGetterMap;
    }

    private <V> V markValue(Type type, boolean builderIgnoresNullValues) throws Exception {
        if (TypeHelper.isPrimitive((Type)type)) {
            return (V)primitivesMarkValue.get(type);
        }
        if (TypeHelper.areEquals((Type)type, String.class)) {
            return (V)"1";
        }
        if (TypeHelper.isAssignable(Enum.class, (Type)type)) {
            Enum[] values = (Enum[])TypeHelper.toClass((Type)type).getEnumConstants();
            return (V)(values.length > 1 ? values[1] : values[0]);
        }
        return this.createValueFromInstantiator(type, builderIgnoresNullValues);
    }

    private <V> V neutralValue(Type type, boolean allowNull, boolean builderIgnoresNullValues) throws Exception {
        if (TypeHelper.isPrimitive((Type)type)) {
            return (V)primitivesNeutralValue.get(type);
        }
        if (allowNull) {
            return null;
        }
        if (TypeHelper.areEquals((Type)type, String.class)) {
            return (V)"0";
        }
        if (TypeHelper.isAssignable(Enum.class, (Type)type)) {
            Enum[] values = (Enum[])TypeHelper.toClass((Type)type).getEnumConstants();
            return (V)values[0];
        }
        return this.createValueFromInstantiator(type, builderIgnoresNullValues);
    }

    private <V> V createValueFromInstantiator(Type type, boolean builderIgnoresNullValues) throws Exception {
        InstantiatorDefinition instantiatorDefinition = InstantiatorFactory.getSmallerConstructor(ReflectionInstantiatorDefinitionFactory.extractDefinitions(type), Collections.emptySet());
        Instantiator instantiator = this.instantiatorFactory.getInstantiator(instantiatorDefinition, Object.class, this.parameters(instantiatorDefinition, true, builderIgnoresNullValues), false, builderIgnoresNullValues);
        try {
            return (V)instantiator.newInstance(null);
        }
        catch (NullPointerException e) {
            instantiator = this.instantiatorFactory.getInstantiator(instantiatorDefinition, Object.class, this.parameters(instantiatorDefinition, false, builderIgnoresNullValues), false, builderIgnoresNullValues);
            return (V)instantiator.newInstance(null);
        }
    }

    private List<Accessor<T>> listAccessors() {
        final ArrayList<Accessor<T>> list = new ArrayList<Accessor<T>>();
        ClassVisitor.visit(this.target, new FieldAndMethodCallBack(){
            ObjectGetterFactory objectGetterFactory = new ObjectGetterFactory(null);

            @Override
            public void method(Method method) {
                if (GetterHelper.isGetter(method)) {
                    Getter methodGetter = this.objectGetterFactory.getMethodGetter(method);
                    list.add(new Accessor(GetterHelper.getPropertyNameFromMethodName(method.getName()), methodGetter));
                }
            }

            @Override
            public void field(Field field) {
                Getter fieldGetter = this.objectGetterFactory.getFieldGetter(field);
                list.add(new Accessor(field.getName(), fieldGetter));
            }
        });
        return list;
    }

    static {
        primitivesMarkValue.put(Byte.TYPE, (byte)1);
        primitivesMarkValue.put(Character.TYPE, Character.valueOf('\u0001'));
        primitivesMarkValue.put(Short.TYPE, (short)1);
        primitivesMarkValue.put(Integer.TYPE, 1);
        primitivesMarkValue.put(Long.TYPE, 1L);
        primitivesMarkValue.put(Float.TYPE, Float.valueOf(1.0f));
        primitivesMarkValue.put(Double.TYPE, 1.0);
        primitivesNeutralValue = new HashMap();
        primitivesNeutralValue.put(Byte.TYPE, (byte)0);
        primitivesNeutralValue.put(Character.TYPE, Character.valueOf('\u0000'));
        primitivesNeutralValue.put(Short.TYPE, (short)0);
        primitivesNeutralValue.put(Integer.TYPE, 0);
        primitivesNeutralValue.put(Long.TYPE, 0L);
        primitivesNeutralValue.put(Float.TYPE, Float.valueOf(0.0f));
        primitivesNeutralValue.put(Double.TYPE, 0.0);
    }

    private static class Accessor<T> {
        private final Getter<T, ?> getter;
        private final String name;

        private Accessor(String name, Getter<T, ?> getter) {
            this.getter = getter;
            this.name = name;
        }

        public String toString() {
            return "Accessor{getter=" + String.valueOf(this.getter) + ", name='" + this.name + "'}";
        }
    }
}

