/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.simpleflatmapper.reflect.meta.AbstractIndexPropertyFinder;
import org.simpleflatmapper.reflect.meta.ArrayClassMeta;
import org.simpleflatmapper.reflect.meta.ArrayElementPropertyMeta;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.IndexedColumn;
import org.simpleflatmapper.reflect.meta.IndexedElement;
import org.simpleflatmapper.reflect.meta.ObjectPropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMatchingScore;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyNameMatcher;
import org.simpleflatmapper.reflect.meta.ShortCircuiter;
import org.simpleflatmapper.reflect.meta.SubPropertyMeta;
import org.simpleflatmapper.reflect.property.SpeculativeArrayIndexResolutionProperty;
import org.simpleflatmapper.util.Asserts;
import org.simpleflatmapper.util.BooleanSupplier;
import org.simpleflatmapper.util.Predicate;

public class ArrayPropertyFinder<T, E>
extends AbstractIndexPropertyFinder<T> {
    public ArrayPropertyFinder(ArrayClassMeta<T, E> arrayClassMeta, boolean selfScoreFullName) {
        super(arrayClassMeta, selfScoreFullName);
    }

    @Override
    protected IndexedElement<T, E> getIndexedElement(IndexedColumn indexedColumn) {
        int indexValue = indexedColumn.getIndexValue();
        return this.getIndexedElement(indexValue);
    }

    protected IndexedElement<T, E> getIndexedElement(int indexValue) {
        IndexedElement<T, E> indexedElement = (IndexedElement<T, E>)this.elements.get(indexValue);
        if (indexedElement == null) {
            indexedElement = new IndexedElement<T, E>(this.newElementPropertyMeta(indexValue, "element" + indexValue), ((ArrayClassMeta)this.classMeta).getElementClassMeta());
            this.elements.put(indexValue, indexedElement);
        }
        return indexedElement;
    }

    private PropertyMeta<T, E> newElementPropertyMeta(int index, String name) {
        ArrayClassMeta arrayClassMeta = (ArrayClassMeta)this.classMeta;
        BooleanSupplier appendSetter = new BooleanSupplier(){

            public boolean getAsBoolean() {
                for (Map.Entry e : ArrayPropertyFinder.this.elements.entrySet()) {
                    IndexedElement tIndexedElement;
                    if ((Integer)e.getKey() <= 0 || !(tIndexedElement = (IndexedElement)e.getValue()).hasAnyProperty()) continue;
                    return false;
                }
                return true;
            }
        };
        return new ArrayElementPropertyMeta(name, this.classMeta.getType(), arrayClassMeta.getReflectionService(), index, arrayClassMeta, arrayClassMeta.newSetterFactory(appendSetter), arrayClassMeta.newGetterFactory());
    }

    @Override
    protected void extrapolateIndex(PropertyNameMatcher propertyNameMatcher, Object[] properties, PropertyFinder.FoundProperty<T> foundProperty, PropertyMatchingScore score, PropertyFinder.PropertyFinderTransformer propertyFinderTransformer, PropertyFinder.TypeAffinityScorer typeAffinityScorer, PropertyFinder.PropertyFilter propertyFilter, ShortCircuiter shortCircuiter) {
        ClassMeta elementClassMeta = ((ArrayClassMeta)this.classMeta).getElementClassMeta();
        PropertyMeta property = elementClassMeta.newPropertyFinder().findProperty(propertyNameMatcher, properties, typeAffinityScorer, propertyFilter, shortCircuiter);
        if (property != null) {
            if (ObjectPropertyFinder.containsProperty(properties, SpeculativeArrayIndexResolutionProperty.class)) {
                List<Integer> keys = this.getKeys();
                this.appendEmptySlot(keys);
                for (Integer k : keys) {
                    IndexedElement<T, E> element = this.getIndexedElement(k);
                    ExtrapolateFoundProperty matchingProperties = new ExtrapolateFoundProperty(element, foundProperty);
                    this.lookForAgainstColumn(new IndexedColumn(k, propertyNameMatcher, 0), properties, matchingProperties, score.speculative().arrayIndex(new IndexedColumn(k, propertyNameMatcher, 0), false), propertyFinderTransformer, typeAffinityScorer, matchingProperties.propertyFilter(propertyFilter), shortCircuiter);
                }
            } else {
                PropertyFinder.FoundProperty<T> fp = foundProperty;
                PropertyFinder.PropertyFilter pf = propertyFilter;
                if (!this.elements.isEmpty()) {
                    IndexedElement<T, E> element = this.getIndexedElement(0);
                    fp = new ExtrapolateFoundProperty(element, foundProperty);
                    pf = ((ExtrapolateFoundProperty)fp).propertyFilter(propertyFilter);
                }
                this.lookForAgainstColumn(new IndexedColumn(0, propertyNameMatcher, 0), properties, fp, score, propertyFinderTransformer, typeAffinityScorer, pf, shortCircuiter);
            }
        }
    }

    private void appendEmptySlot(List<Integer> keys) {
        if (keys.isEmpty()) {
            keys.add(0);
            return;
        }
        int i = 0;
        while (i + 1 < keys.size()) {
            int k1 = keys.get(i);
            int k2 = keys.get(i + 1);
            if (k2 - k1 > 1) {
                keys.add(i + 1, k1 + 1);
                return;
            }
            ++i;
        }
        keys.add(keys.get(keys.size() - 1) + 1);
    }

    private List<Integer> getKeys() {
        ArrayList<Integer> keys = new ArrayList<Integer>(this.elements.keySet());
        Collections.sort(keys);
        return keys;
    }

    @Override
    protected boolean indexMatches(PropertyMeta<T, ?> propertyMeta, PropertyMeta<?, ?> owner) {
        if (owner == propertyMeta) {
            return true;
        }
        if (propertyMeta instanceof ArrayElementPropertyMeta && owner instanceof ArrayElementPropertyMeta) {
            return ((ArrayElementPropertyMeta)propertyMeta).getIndex() == ((ArrayElementPropertyMeta)owner).getIndex();
        }
        return false;
    }

    @Override
    protected PropertyFinder<?> registerProperty(SubPropertyMeta<?, ?, ?> subPropertyMeta) {
        PropertyMeta<?, ?> ownerProperty = subPropertyMeta.getOwnerProperty();
        if (ownerProperty instanceof ArrayElementPropertyMeta) {
            ArrayElementPropertyMeta arrayElementPropertyMeta = (ArrayElementPropertyMeta)ownerProperty;
            IndexedElement<T, E> indexedElement = this.getIndexedElement(new IndexedColumn(arrayElementPropertyMeta.getIndex(), null, 0));
            return indexedElement.getPropertyFinder();
        }
        throw new IllegalArgumentException("Illegal owner expected ArrayElementPropertyMeta got " + String.valueOf(subPropertyMeta));
    }

    @Override
    protected boolean isValidIndex(IndexedColumn indexedColumn) {
        return indexedColumn.getIndexValue() >= 0;
    }

    private static class ExtrapolateFoundProperty<T>
    implements PropertyFinder.FoundProperty<T> {
        private final IndexedElement element;
        private final PropertyFinder.FoundProperty foundProperty;
        private boolean found;

        public ExtrapolateFoundProperty(IndexedElement element, PropertyFinder.FoundProperty foundProperty) {
            this.element = (IndexedElement)Asserts.requireNonNull((String)"element", (Object)element);
            this.foundProperty = (PropertyFinder.FoundProperty)Asserts.requireNonNull((String)"foundProperty", (Object)foundProperty);
        }

        @Override
        public <P extends PropertyMeta<T, ?>> void found(P propertyMeta, Runnable selectionCallback, PropertyMatchingScore score, PropertyFinder.TypeAffinityScorer typeAffinityScorer) {
            boolean isNotPresent = this.isNotPresent(propertyMeta);
            if (isNotPresent) {
                this.foundProperty.found(propertyMeta, selectionCallback, score, typeAffinityScorer);
                this.found = true;
            }
        }

        boolean isNotPresent(PropertyMeta<?, ?> propertyMeta) {
            String pathCheck;
            if (propertyMeta instanceof ArrayElementPropertyMeta) {
                pathCheck = "{this}";
            } else if (propertyMeta.isSubProperty()) {
                pathCheck = ((SubPropertyMeta)propertyMeta).getSubProperty().getPath();
            } else {
                throw new IllegalArgumentException("Excepted match " + String.valueOf(propertyMeta));
            }
            return !this.element.hasProperty(pathCheck);
        }

        boolean isNotPresentFilter(PropertyMeta<?, ?> propertyMeta) {
            String pathCheck = propertyMeta.getPath();
            return !this.element.hasProperty(pathCheck);
        }

        public boolean hasFound() {
            return this.found;
        }

        public PropertyFinder.PropertyFilter propertyFilter(final PropertyFinder.PropertyFilter propertyFilter) {
            return new PropertyFinder.PropertyFilter(new Predicate<PropertyMeta<?, ?>>(){

                public boolean test(PropertyMeta<?, ?> propertyMeta) {
                    return propertyFilter.testProperty(propertyMeta) && this.isNotPresentFilter(propertyMeta);
                }
            }, new Predicate<PropertyMeta<?, ?>>(){

                public boolean test(PropertyMeta<?, ?> propertyMeta) {
                    return propertyFilter.testPath(propertyMeta);
                }
            });
        }
    }
}

