/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.util.Arrays;
import org.simpleflatmapper.reflect.meta.DefaultPropertyNameMatcher;
import org.simpleflatmapper.reflect.meta.IndexedColumn;
import org.simpleflatmapper.reflect.meta.NonMappedPropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyNameMatch;
import org.simpleflatmapper.reflect.meta.PropertyNameMatcher;

public class PropertyMatchingScore
implements Comparable<PropertyMatchingScore> {
    private NodeScore[] scores;
    private static final int NON_MAPPED = 1;
    private static final int SPECULATIVE = 2;
    private static final int PARTIAL = 4;
    private static final int SELF = 8;
    private static final int TUPLE = 16;
    private static final int ARRAY = 32;

    public PropertyMatchingScore() {
        this.scores = new NodeScore[0];
    }

    public PropertyMatchingScore(NodeScore[] scores) {
        this.scores = scores;
    }

    @Override
    public int compareTo(PropertyMatchingScore o) {
        int i;
        int oEffectiveMatch;
        int effectiveMatch;
        int oTotalMatch;
        int totalMatch = this.totalMatch();
        if (totalMatch > (oTotalMatch = o.totalMatch())) {
            return -1;
        }
        if (oTotalMatch > totalMatch) {
            return 1;
        }
        if (this.isPartialMatch()) {
            if (!o.isPartialMatch()) {
                return 1;
            }
        } else if (o.isPartialMatch()) {
            return -1;
        }
        if ((effectiveMatch = this.effectiveTotalMatch()) > (oEffectiveMatch = o.effectiveTotalMatch())) {
            return -1;
        }
        if (oEffectiveMatch > effectiveMatch) {
            return 1;
        }
        int maxDepth = Math.min(o.depth(), this.depth());
        for (i = 0; i < maxDepth; ++i) {
            boolean speculative = this.scores[i].isSpeculative();
            boolean ospeculative = o.scores[i].isSpeculative();
            if (speculative) {
                if (ospeculative) continue;
                return 1;
            }
            if (!ospeculative) continue;
            return -1;
        }
        for (i = 0; i < maxDepth; ++i) {
            int c = this.scores[i].compareTo(o.scores[i]);
            if (c == 0) continue;
            return c;
        }
        return this.depth() - o.depth();
    }

    private int firstSpeculativeNode() {
        for (int i = 0; i < this.scores.length; ++i) {
            if (!this.scores[i].isSpeculative()) continue;
            return i;
        }
        return Integer.MAX_VALUE;
    }

    private boolean isPartialMatch() {
        for (NodeScore n : this.scores) {
            if (!n.isPartialMatch()) continue;
            return true;
        }
        return false;
    }

    private int depth() {
        return this.scores.length;
    }

    private int totalMatch() {
        int tm = 0;
        for (NodeScore ns : this.scores) {
            tm += ns.nbMatch;
        }
        return tm;
    }

    private int effectiveTotalMatch() {
        int tm = 0;
        for (NodeScore ns : this.scores) {
            tm += ns.effectiveMatch();
        }
        return tm;
    }

    public PropertyMatchingScore arrayIndex(IndexedColumn ic, boolean scoreFullName) {
        if (scoreFullName) {
            return this.with(NodeScore.tupleIndex(null, null, ic));
        }
        return this.with(NodeScore.arrayIndex(ic, true, this.isSpeculative()));
    }

    public PropertyMatchingScore speculative() {
        return this.with(NodeScore.speculative(null, null));
    }

    public PropertyMatchingScore speculative(PropertyMeta<?, ?> propertyMeta, PropertyNameMatcher propertyNameMatcher) {
        return this.with(NodeScore.speculative(propertyMeta, propertyNameMatcher));
    }

    public PropertyMatchingScore tupleIndex(PropertyMeta<?, ?> propertyMeta, PropertyNameMatcher propertyNameMatcher, IndexedColumn ic) {
        return this.with(NodeScore.tupleIndex(propertyMeta, propertyNameMatcher, ic));
    }

    public PropertyMatchingScore matches(PropertyMeta<?, ?> propertyMeta, PropertyNameMatcher propertyNameMatcher, PropertyNameMatch propertyNameMatch) {
        return this.with(NodeScore.matches(propertyMeta, propertyNameMatcher, propertyNameMatch));
    }

    public PropertyMatchingScore self(PropertyMeta<?, ?> propertyMeta, PropertyNameMatcher propertyNameMatcher, String propName) {
        int score = DefaultPropertyNameMatcher.toScore(propName);
        boolean scoreFullName = this.scoreFullName();
        return this.with(NodeScore.self(propertyMeta, propertyNameMatcher, propName, scoreFullName));
    }

    private boolean scoreFullName(boolean scoreFullName) {
        if (scoreFullName) {
            if (this.scores.length == 0) {
                return true;
            }
            for (NodeScore ns : this.scores) {
                if (ns.nbMatch <= 0) continue;
                return true;
            }
        }
        return false;
    }

    private boolean scoreFullName() {
        if (this.scores.length > 0) {
            NodeScore lastScore = this.scores[this.scores.length - 1];
            if (lastScore.propertyMeta != null) {
                return (lastScore.state & 0x10) != 0;
            }
        }
        return false;
    }

    private boolean isSpeculative() {
        if (this.scores.length > 0) {
            NodeScore lastScore = this.scores[this.scores.length - 1];
            if (lastScore.propertyMeta != null) {
                return (lastScore.state & 2) != 0;
            }
        }
        return false;
    }

    public PropertyMatchingScore nonMappedProperty(NonMappedPropertyMeta<?, ?> nonMappedPropertyMeta, PropertyNameMatcher propertyNameMatcher) {
        return this.with(NodeScore.nonMapped(nonMappedPropertyMeta, propertyNameMatcher));
    }

    private PropertyMatchingScore with(NodeScore score) {
        NodeScore[] ns = Arrays.copyOf(this.scores, this.scores.length + 1);
        ns[ns.length - 1] = score;
        return new PropertyMatchingScore(ns);
    }

    public String toString() {
        return "PropertyMatchingScore{totalScore=" + this.totalMatch() + ", effectiveMatch=" + this.effectiveTotalMatch() + ", firstSpeculativeNode=" + this.firstSpeculativeNode() + ", scores=" + Arrays.toString(this.scores) + "}";
    }

    @Deprecated
    public static PropertyMatchingScore newInstance(boolean selfScoreFullName) {
        return PropertyMatchingScore.newInstance();
    }

    public static PropertyMatchingScore newInstance() {
        return new PropertyMatchingScore();
    }

    private static class NodeScore
    implements Comparable<NodeScore> {
        private final PropertyMeta<?, ?> propertyMeta;
        private final PropertyNameMatcher propertyNameMatcher;
        private final int state;
        private final int selfNumberOfProperties;
        private final int nbMatch;
        private final int nbPartialMatch;
        private final int index;

        private NodeScore(PropertyMeta<?, ?> propertyMeta, PropertyNameMatcher propertyNameMatcher, int state, int selfNumberOfProperties, int nbMatch, int nbPartialMatch, int index) {
            this.propertyMeta = propertyMeta;
            this.propertyNameMatcher = propertyNameMatcher;
            this.state = state;
            this.selfNumberOfProperties = selfNumberOfProperties;
            this.nbMatch = nbMatch;
            this.nbPartialMatch = nbPartialMatch;
            this.index = index;
        }

        public static NodeScore nonMapped(NonMappedPropertyMeta<?, ?> nonMappedPropertyMeta, PropertyNameMatcher propertyNameMatcher) {
            return new NodeScore(nonMappedPropertyMeta, propertyNameMatcher, 1, 0, 0, 0, 0);
        }

        public static NodeScore self(PropertyMeta<?, ?> propertyMeta, PropertyNameMatcher propertyNameMatcher, String propName, boolean scoreFullName) {
            int numberOfProperties = propertyMeta.getPropertyClassMeta().getNumberOfProperties();
            int score = numberOfProperties == 0 && scoreFullName ? DefaultPropertyNameMatcher.toScore(propName) : 0;
            return new NodeScore(propertyMeta, propertyNameMatcher, 8, numberOfProperties, score, 0, 0);
        }

        public static NodeScore matches(PropertyMeta<?, ?> propertyMeta, PropertyNameMatcher propertyNameMatcher, PropertyNameMatch propertyNameMatch) {
            return new NodeScore(propertyMeta, propertyNameMatcher, propertyNameMatch.skippedLetters != 0 ? 4 : 0, 0, propertyNameMatch.score, propertyNameMatch.skippedLetters, 0);
        }

        public static NodeScore arrayIndex(IndexedColumn ic, boolean scoreFullName, boolean speculative) {
            int score = speculative ? 0 : (scoreFullName ? ic.getScore() : 1);
            return new NodeScore(null, null, 32, 0, score, 0, ic.getIndexValue());
        }

        public static NodeScore tupleIndex(PropertyMeta<?, ?> propertyMeta, PropertyNameMatcher propertyNameMatcher, IndexedColumn ic) {
            return new NodeScore(propertyMeta, propertyNameMatcher, 16, 0, ic.getScore(), 0, ic.getIndexValue());
        }

        public static NodeScore speculative(PropertyMeta<?, ?> propertyMeta, PropertyNameMatcher propertyNameMatcher) {
            return new NodeScore(propertyMeta, propertyNameMatcher, 2, 0, 0, 0, 0);
        }

        public String toString() {
            return "NodeScore{ state=" + this.state + ", selfNumberOfProperties=" + this.selfNumberOfProperties + ", nbMatch=" + this.nbMatch + ", nbPartialMatch=" + this.nbPartialMatch + ", index=" + this.index + ", propertyMeta=" + String.valueOf(this.propertyMeta) + ", propertyNameMatcher=" + String.valueOf(this.propertyNameMatcher) + "}";
        }

        @Override
        public int compareTo(NodeScore o) {
            if (this.isSpeculative()) {
                if (!o.isSpeculative()) {
                    return 1;
                }
            } else if (o.isSpeculative()) {
                return -1;
            }
            if (this.index < o.index) {
                return -1;
            }
            if (this.index > o.index) {
                return 1;
            }
            return 0;
        }

        private boolean isSpeculative() {
            return (this.state & 2) != 0;
        }

        public boolean isPartialMatch() {
            return (this.state & 4) != 0;
        }

        public int effectiveMatch() {
            if ((this.state & 0x28) != 0) {
                return 0;
            }
            return this.nbMatch;
        }
    }
}

