/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.util;

import java.util.Arrays;
import org.simpleflatmapper.util.Predicate;

public final class OrManyPredicate<T>
implements Predicate<T> {
    public final Predicate<? super T>[] predicates;

    public OrManyPredicate(Predicate<? super T> ... predicates) {
        this.predicates = predicates;
    }

    @Override
    public boolean test(T t) {
        for (Predicate<T> predicate : this.predicates) {
            if (!predicate.test(t)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrManyPredicate that = (OrManyPredicate)o;
        return Arrays.equals(this.predicates, that.predicates);
    }

    public int hashCode() {
        return Arrays.hashCode(this.predicates);
    }

    public String toString() {
        return "OrManyPredicate{predicates=" + Arrays.toString(this.predicates) + "}";
    }
}

