/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http;

import java.net.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Scheme {
    HTTP("http", false),
    HTTPS("https", true),
    WS("ws", false),
    WSS("wss", true);

    public final String scheme;
    public final boolean secure;

    private Scheme(String scheme, boolean secure) {
        this.scheme = scheme;
        this.secure = secure;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getScheme() {
        return this.scheme;
    }

    public static Scheme resolveScheme(String token) {
        if (token != null) {
            for (Scheme scheme : Scheme.values()) {
                if (!token.equalsIgnoreCase(scheme.scheme)) continue;
                return scheme;
            }
        }
        return HTTP;
    }

    public static Scheme resolveScheme(URI target) {
        if (target != null) {
            String scheme = target.getScheme();
            for (Scheme option : Scheme.values()) {
                if (!option.scheme.equalsIgnoreCase(scheme)) continue;
                return option;
            }
        }
        return null;
    }
}

