/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import org.simpleframework.http.core.BodyEncoder;
import org.simpleframework.http.core.BodyObserver;
import org.simpleframework.http.core.ChunkedEncoder;
import org.simpleframework.http.core.CloseEncoder;
import org.simpleframework.http.core.Conversation;
import org.simpleframework.http.core.EmptyEncoder;
import org.simpleframework.http.core.FixedLengthEncoder;
import org.simpleframework.transport.ByteWriter;
import org.simpleframework.transport.Channel;

class BodyEncoderFactory {
    private final Conversation support;
    private final BodyObserver observer;
    private final ByteWriter writer;

    public BodyEncoderFactory(BodyObserver observer, Conversation support, Channel channel) {
        this.writer = channel.getWriter();
        this.observer = observer;
        this.support = support;
    }

    public BodyEncoder getInstance() {
        boolean keepAlive = this.support.isKeepAlive();
        boolean chunkable = this.support.isChunkedEncoded();
        boolean tunnel = this.support.isTunnel();
        if (!keepAlive || tunnel) {
            return new CloseEncoder(this.observer, this.writer);
        }
        return this.getInstance(chunkable);
    }

    private BodyEncoder getInstance(boolean chunkable) {
        long length = this.support.getContentLength();
        if (!this.support.isHead()) {
            if (length > 0L) {
                return new FixedLengthEncoder(this.observer, this.writer, length);
            }
            if (chunkable) {
                return new ChunkedEncoder(this.observer, this.writer);
            }
        }
        return new EmptyEncoder(this.observer, this.writer);
    }
}

