/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.simpleframework.http.core.BodyEncoder;
import org.simpleframework.http.core.BodyEncoderException;
import org.simpleframework.http.core.BodyObserver;
import org.simpleframework.transport.ByteWriter;

class CloseEncoder
implements BodyEncoder {
    private final BodyObserver observer;
    private final ByteWriter writer;

    public CloseEncoder(BodyObserver observer, ByteWriter writer) {
        this.observer = observer;
        this.writer = writer;
    }

    public void encode(byte[] array) throws IOException {
        this.encode(array, 0, array.length);
    }

    public void encode(byte[] array, int off, int len) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(array, off, len);
        if (len > 0) {
            this.encode(buffer);
        }
    }

    public void encode(ByteBuffer buffer) throws IOException {
        int size;
        int mark = buffer.position();
        if (mark > (size = buffer.limit())) {
            throw new BodyEncoderException("Buffer position greater than limit");
        }
        this.encode(buffer, 0, size - mark);
    }

    public void encode(ByteBuffer buffer, int off, int len) throws IOException {
        if (this.observer.isClosed()) {
            throw new BodyEncoderException("Stream has been closed");
        }
        try {
            this.writer.write(buffer, off, len);
        }
        catch (Exception cause) {
            if (this.writer != null) {
                this.observer.error(this.writer);
            }
            throw new BodyEncoderException("Error sending response", cause);
        }
    }

    public void flush() throws IOException {
        try {
            if (!this.observer.isClosed()) {
                this.writer.flush();
            }
        }
        catch (Exception cause) {
            if (this.writer != null) {
                this.observer.error(this.writer);
            }
            throw new BodyEncoderException("Error sending response", cause);
        }
    }

    public void close() throws IOException {
        try {
            if (!this.observer.isClosed()) {
                this.observer.close(this.writer);
                this.writer.close();
            }
        }
        catch (Exception cause) {
            if (this.writer != null) {
                this.observer.error(this.writer);
            }
            throw new BodyEncoderException("Error sending response", cause);
        }
    }
}

