/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.simpleframework.http.core.BodyEncoder;
import org.simpleframework.http.core.BodyEncoderException;
import org.simpleframework.http.core.BodyObserver;
import org.simpleframework.transport.ByteWriter;

class FixedLengthEncoder
implements BodyEncoder {
    private BodyObserver observer;
    private ByteWriter writer;
    private long count;
    private long limit;

    public FixedLengthEncoder(BodyObserver observer, ByteWriter writer, long limit) {
        this.observer = observer;
        this.writer = writer;
        this.limit = limit;
    }

    public void encode(byte[] array) throws IOException {
        this.encode(array, 0, array.length);
    }

    public void encode(byte[] array, int off, int len) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(array, off, len);
        if (len > 0) {
            this.encode(buffer);
        }
    }

    public void encode(ByteBuffer buffer) throws IOException {
        int size;
        int mark = buffer.position();
        if (mark > (size = buffer.limit())) {
            throw new BodyEncoderException("Buffer position greater than limit");
        }
        this.encode(buffer, 0, size - mark);
    }

    public void encode(ByteBuffer buffer, int off, int len) throws IOException {
        long size = Math.min((long)len, this.limit - this.count);
        try {
            if (this.observer.isClosed()) {
                throw new BodyEncoderException("Response content complete");
            }
            this.writer.write(buffer, off, (int)size);
            if (this.count + size == this.limit) {
                this.observer.ready(this.writer);
            }
        }
        catch (Exception cause) {
            if (this.writer != null) {
                this.observer.error(this.writer);
            }
            throw new BodyEncoderException("Error sending response", cause);
        }
        this.count += size;
    }

    public void flush() throws IOException {
        try {
            if (!this.observer.isClosed()) {
                this.writer.flush();
            }
        }
        catch (Exception cause) {
            if (this.writer != null) {
                this.observer.error(this.writer);
            }
            throw new BodyEncoderException("Error flushing", cause);
        }
    }

    public void close() throws IOException {
        if (!this.observer.isClosed()) {
            if (this.count < this.limit) {
                this.observer.error(this.writer);
            } else {
                this.observer.ready(this.writer);
            }
        }
    }
}

