/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.message;

import java.io.IOException;
import org.simpleframework.common.buffer.Allocator;
import org.simpleframework.common.buffer.Buffer;
import org.simpleframework.http.message.ArrayConsumer;

class BoundaryConsumer
extends ArrayConsumer {
    private static final byte[] LAST = new byte[]{45, 45, 13, 10};
    private static final byte[] LINE = new byte[]{13, 10};
    private static final byte[] TOKEN = new byte[]{45, 45};
    private Allocator allocator;
    private Buffer buffer;
    private byte[] boundary;
    private int seek;

    public BoundaryConsumer(Allocator allocator, byte[] boundary) {
        this.chunk = boundary.length + LAST.length + TOKEN.length;
        this.allocator = allocator;
        this.boundary = boundary;
    }

    protected void process() throws IOException {
        if (this.count < this.boundary.length + 4) {
            throw new IOException("Invalid boundary processed");
        }
    }

    protected int scan() throws IOException {
        int size = this.boundary.length;
        if (this.count >= 2 && this.seek < 2 && this.scan(TOKEN)) {
            this.append(TOKEN);
        }
        if (this.count >= 2 + size && this.seek < 2 + size && this.scan(this.boundary)) {
            this.append(this.boundary);
        }
        if (this.count >= 4 + size && this.seek < 4 + size) {
            if (this.array[size + 2] == TOKEN[0]) {
                if (this.scan(TOKEN)) {
                    this.append(TOKEN);
                }
            } else if (this.array[size + 2] == LINE[0]) {
                if (this.scan(LINE)) {
                    this.append(LINE);
                }
                this.done = true;
                return this.count - this.seek;
            }
        }
        if (this.count >= 6 + size && this.seek < 6 + size) {
            if (this.scan(LINE)) {
                this.append(LINE);
            }
            this.done = true;
            return this.count - this.seek;
        }
        return 0;
    }

    private void append(byte[] token) throws IOException {
        if (this.buffer == null) {
            this.buffer = this.allocator.allocate((long)this.chunk);
        }
        this.buffer.append(token);
    }

    private boolean scan(byte[] data) throws IOException {
        int size = data.length;
        int pos = 0;
        while (this.seek < this.count) {
            if (this.array[this.seek++] != data[pos++]) {
                throw new IOException("Invalid boundary");
            }
            if (pos != data.length) continue;
            return true;
        }
        return pos == size;
    }

    public boolean isEnd() {
        return this.seek == this.chunk;
    }

    public void clear() {
        this.done = false;
        this.seek = 0;
        this.count = 0;
    }
}

