/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.message;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.simpleframework.common.buffer.Allocator;
import org.simpleframework.http.message.Body;
import org.simpleframework.http.message.BodyConsumer;
import org.simpleframework.http.message.PartSeriesConsumer;
import org.simpleframework.transport.ByteCursor;

public class FileUploadConsumer
implements BodyConsumer {
    private final BodyConsumer consumer;
    private final AtomicLong count;

    public FileUploadConsumer(Allocator allocator, byte[] boundary, long length) {
        this.consumer = new PartSeriesConsumer(allocator, boundary, length);
        this.count = new AtomicLong(length);
    }

    public Body getBody() {
        return this.consumer.getBody();
    }

    public void consume(ByteCursor cursor) throws IOException {
        ByteCounter counter = new ByteCounter(cursor);
        while (counter.isReady() && !this.consumer.isFinished()) {
            this.consumer.consume(counter);
        }
    }

    public boolean isFinished() {
        long remaining = this.count.get();
        if (this.consumer.isFinished()) {
            return true;
        }
        return remaining <= 0L;
    }

    private class ByteCounter
    implements ByteCursor {
        private final ByteCursor cursor;

        public ByteCounter(ByteCursor cursor) {
            this.cursor = cursor;
        }

        public boolean isOpen() throws IOException {
            return this.cursor.isOpen();
        }

        public boolean isReady() throws IOException {
            long limit = FileUploadConsumer.this.count.get();
            if (limit > 0L) {
                return this.cursor.isReady();
            }
            return false;
        }

        public int ready() throws IOException {
            int limit = (int)FileUploadConsumer.this.count.get();
            int ready = this.cursor.ready();
            if (ready > limit) {
                return limit;
            }
            return ready;
        }

        public int read(byte[] data) throws IOException {
            return this.read(data, 0, data.length);
        }

        public int read(byte[] data, int off, int len) throws IOException {
            int limit = (int)FileUploadConsumer.this.count.get();
            int size = Math.min(limit, len);
            int chunk = this.cursor.read(data, off, size);
            if (chunk > 0) {
                FileUploadConsumer.this.count.addAndGet(-chunk);
            }
            return chunk;
        }

        public void push(byte[] data) throws IOException {
            this.push(data, 0, data.length);
        }

        public void push(byte[] data, int off, int len) throws IOException {
            if (len > 0) {
                FileUploadConsumer.this.count.addAndGet(len);
            }
            this.cursor.push(data, off, len);
        }

        public int reset(int len) throws IOException {
            int reset = this.cursor.reset(len);
            if (reset > 0) {
                FileUploadConsumer.this.count.addAndGet(reset);
            }
            return reset;
        }
    }
}

