/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.message;

import java.util.LinkedList;
import java.util.List;
import org.simpleframework.common.KeyMap;
import org.simpleframework.http.Cookie;
import org.simpleframework.http.message.Message;
import org.simpleframework.http.parse.DateParser;
import org.simpleframework.http.parse.ValueParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageHeader
implements Message {
    private final KeyMap<Cookie> cookies = new KeyMap();
    private final KeyMap<Series> values = new KeyMap();
    private final KeyMap<String> names = new KeyMap();
    private final DateParser parser = new DateParser();

    @Override
    public List<String> getNames() {
        return this.names.getValues();
    }

    @Override
    public void setValue(String name, String value) {
        List<String> list = this.getAll(name);
        if (value == null) {
            String token = name.toLowerCase();
            this.values.remove((Object)token);
            this.names.remove((Object)token);
        } else {
            list.clear();
            list.add(value);
        }
    }

    @Override
    public void setInteger(String name, int value) {
        this.setValue(name, String.valueOf(value));
    }

    public void setLong(String name, long value) {
        this.setValue(name, String.valueOf(value));
    }

    @Override
    public void setDate(String name, long date) {
        this.setValue(name, this.parser.convert(date));
    }

    @Override
    public void addValue(String name, String value) {
        List<String> list = this.getAll(name);
        if (value != null) {
            list.add(value);
        }
    }

    @Override
    public void addInteger(String name, int value) {
        this.addValue(name, String.valueOf(value));
    }

    @Override
    public void addDate(String name, long date) {
        this.addValue(name, this.parser.convert(date));
    }

    @Override
    public String getValue(String name) {
        return this.getValue(name, 0);
    }

    @Override
    public String getValue(String name, int index) {
        List<String> list = this.getAll(name);
        if (list.size() > index) {
            return list.get(index);
        }
        return null;
    }

    @Override
    public int getInteger(String name) {
        String value = this.getValue(name);
        if (value == null) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    public long getLong(String name) {
        String value = this.getValue(name);
        if (value == null) {
            return -1L;
        }
        return Long.parseLong(value);
    }

    @Override
    public long getDate(String name) {
        String value = this.getValue(name);
        if (value == null) {
            return -1L;
        }
        return this.parser.convert(value);
    }

    @Override
    public Cookie getCookie(String name) {
        return (Cookie)this.cookies.get((Object)name);
    }

    @Override
    public List<Cookie> getCookies() {
        return this.cookies.getValues();
    }

    @Override
    public Cookie setCookie(String name, String value) {
        return this.setCookie(new Cookie(name, value, true));
    }

    @Override
    public Cookie setCookie(Cookie cookie) {
        String name = cookie.getName();
        if (name != null) {
            this.cookies.put((Object)name, (Object)cookie);
        }
        return cookie;
    }

    @Override
    public List<String> getValues(String name) {
        return this.getValues(this.getAll(name));
    }

    @Override
    public List<String> getValues(List<String> list) {
        return new ValueParser(list).list();
    }

    @Override
    public List<String> getAll(String name) {
        String token = name.toLowerCase();
        Series series = (Series)this.values.get((Object)token);
        if (series == null) {
            return this.getAll(name, token);
        }
        return series.getValues();
    }

    private List<String> getAll(String name, String token) {
        Series series = new Series();
        String value = (String)this.names.get((Object)token);
        if (value == null) {
            this.names.put((Object)token, (Object)name);
        }
        this.values.put((Object)token, (Object)series);
        return series.getValues();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Series {
        private List<String> value = new LinkedList<String>();

        public List<String> getValues() {
            return this.value;
        }
    }
}

