/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.socket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FrameType {
    CONTINUATION(0),
    TEXT(1),
    BINARY(2),
    CLOSE(8),
    PING(9),
    PONG(10);

    public final int code;

    private FrameType(int code) {
        this.code = code;
    }

    public boolean isText() {
        return this == TEXT;
    }

    public boolean isClose() {
        return this == CLOSE;
    }

    public boolean isPong() {
        return this == PONG;
    }

    public boolean isPing() {
        return this == PING;
    }

    public static FrameType resolveType(int octet) {
        int value = octet & 0xFF;
        for (FrameType code : FrameType.values()) {
            if (code.code != value) continue;
            return code;
        }
        return null;
    }
}

