/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.socket.service;

import java.io.IOException;
import org.simpleframework.http.socket.Frame;
import org.simpleframework.http.socket.FrameType;
import org.simpleframework.http.socket.service.FrameBuilder;
import org.simpleframework.http.socket.service.FrameHeaderConsumer;
import org.simpleframework.transport.ByteCursor;

class FrameConsumer {
    private FrameHeaderConsumer header = new FrameHeaderConsumer();
    private FrameBuilder builder = new FrameBuilder(this.header);
    private byte[] buffer = new byte[2048];
    private int count;

    public FrameType getType() {
        return this.header.getType();
    }

    public Frame getFrame() {
        return this.builder.create(this.buffer, this.count);
    }

    public void consume(ByteCursor cursor) throws IOException {
        while (cursor.isReady()) {
            int length;
            if (!this.header.isFinished()) {
                this.header.consume(cursor);
            }
            if (!this.header.isFinished() || this.count > (length = this.header.getLength())) continue;
            if (this.buffer.length < length) {
                this.buffer = new byte[length];
            }
            if (this.count < length) {
                int size = cursor.read(this.buffer, this.count, length - this.count);
                if (size == -1) {
                    throw new IOException("Could only read " + this.count + " of length " + length);
                }
                this.count += size;
            }
            if (this.count != length) continue;
            if (!this.header.isMasked()) break;
            byte[] mask = this.header.getMask();
            for (int i = 0; i < this.count; ++i) {
                int n = i;
                this.buffer[n] = (byte)(this.buffer[n] ^ mask[i % 4]);
            }
        }
    }

    public boolean isFinished() {
        int length;
        return this.header.isFinished() && this.count == (length = this.header.getLength());
    }

    public void clear() {
        this.header.clear();
        this.count = 0;
    }
}

