/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.message;

import java.io.IOException;
import org.simpleframework.http.message.Body;
import org.simpleframework.http.message.BufferBody;
import org.simpleframework.http.message.UpdateConsumer;
import org.simpleframework.util.buffer.Allocator;
import org.simpleframework.util.buffer.Buffer;

public class ChunkedConsumer
extends UpdateConsumer {
    private Allocator allocator;
    private Buffer buffer;
    private boolean terminal;
    private boolean last;
    private byte[] line;
    private int count;
    private int chunk;

    public ChunkedConsumer(Allocator allocator) {
        this(allocator, 1024);
    }

    private ChunkedConsumer(Allocator allocator, int chunk) {
        this.line = new byte[chunk];
        this.allocator = allocator;
    }

    public Body getBody() {
        return new BufferBody(this.buffer);
    }

    private void append(byte[] array, int off, int len) throws IOException {
        if (this.buffer == null) {
            this.buffer = this.allocator.allocate();
        }
        this.buffer.append(array, off, len);
    }

    protected int update(byte[] array, int off, int size) throws IOException {
        int mark = off + size;
        block0: while (off < mark) {
            if (this.terminal || this.last) {
                while (off < mark) {
                    if (array[off++] != 10) continue;
                    if (this.last) {
                        this.finished = true;
                        return mark - off;
                    }
                    this.terminal = false;
                    continue block0;
                }
                continue;
            }
            if (this.chunk == 0) {
                while (this.chunk == 0 && off < mark) {
                    if (array[off++] == 10) {
                        this.parse();
                        if (this.chunk != 0) continue;
                        this.last = true;
                        continue block0;
                    }
                    this.line[this.count++] = array[off - 1];
                }
                continue;
            }
            int write = Math.min(mark - off, this.chunk);
            this.append(array, off, write);
            this.chunk -= write;
            off += write;
            if (this.chunk != 0) continue;
            this.terminal = true;
        }
        return 0;
    }

    private void parse() throws IOException {
        for (int off = 0; off < this.count; ++off) {
            int octet = this.toDecimal(this.line[off]);
            if (octet < 0) {
                if (off >= 1) break;
                throw new IOException("Invalid chunk size line");
            }
            this.chunk <<= 4;
            this.chunk ^= octet;
        }
        this.count = 0;
    }

    private int toDecimal(byte octet) {
        if (octet >= 65 && octet <= 90) {
            return octet - 65 + 10;
        }
        if (octet >= 48 && octet <= 57) {
            return octet - 48;
        }
        if (octet >= 97 && octet <= 102) {
            return octet - 97 + 10;
        }
        return -1;
    }
}

