/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.authenticatedsockssupport.socks5client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.internal.authenticatedsockssupport.common.SocksException;
import org.simplejavamail.internal.authenticatedsockssupport.socks5client.Socks5;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocksSocket
extends Socket {
    private static final Logger LOGGER = LoggerFactory.getLogger(SocksSocket.class);
    private final Socks5 proxy;
    private String remoteServerHost;
    private int remoteServerPort;
    private Socket proxySocket;

    private SocksSocket(Socks5 proxy, String remoteServerHost, int remoteServerPort) throws IOException {
        this.proxy = Objects.requireNonNull(proxy, "Argument [proxy] may not be null").copy();
        this.proxy.setProxySocket(this.proxySocket);
        this.remoteServerHost = Objects.requireNonNull(remoteServerHost, "Argument [remoteServerHost] may not be null");
        this.remoteServerPort = remoteServerPort;
        this.proxy.buildConnection();
        this.proxySocket = this.proxy.getProxySocket();
        this.initProxyChain();
        this.proxy.requestConnect(remoteServerHost, remoteServerPort);
    }

    private SocksSocket(Socks5 proxy, InetAddress address, int port) throws IOException {
        this(proxy, new InetSocketAddress(address, port));
    }

    public SocksSocket(Socks5 proxy, InetSocketAddress socketAddress) throws IOException {
        Objects.requireNonNull(proxy, "Argument [proxy] may not be null");
        Objects.requireNonNull(socketAddress, "Argument [socketAddress] may not be null");
        this.proxy = proxy.copy();
        this.remoteServerHost = socketAddress.getHostString();
        this.remoteServerPort = socketAddress.getPort();
        this.proxy.buildConnection();
        this.proxySocket = this.proxy.getProxySocket();
        this.initProxyChain();
        this.proxy.requestConnect(socketAddress.getAddress(), socketAddress.getPort());
    }

    public SocksSocket(Socks5 proxy) throws IOException {
        this(proxy, proxy.createProxySocket());
    }

    public SocksSocket(Socks5 proxy, Socket proxySocket, InetSocketAddress socketAddress) throws IOException {
        this(proxy, proxySocket);
        this.connect(socketAddress);
    }

    public SocksSocket(Socks5 proxy, Socket proxySocket) {
        Objects.requireNonNull(proxy, "Argument [proxy] may not be null");
        Objects.requireNonNull(proxySocket, "Argument [proxySocket] may not be null");
        if (proxySocket.isConnected()) {
            throw new IllegalArgumentException("Proxy socket should be unconnected");
        }
        this.proxySocket = proxySocket;
        this.proxy = proxy.copy();
        this.proxy.setProxySocket(proxySocket);
    }

    private void initProxyChain() throws IOException {
        ArrayList<Socks5> proxyChain = new ArrayList<Socks5>();
        Socks5 temp = this.proxy;
        while (temp.getChainProxy() != null) {
            temp.getChainProxy().setProxySocket(this.proxySocket);
            proxyChain.add(temp.getChainProxy());
            temp = temp.getChainProxy();
        }
        LOGGER.debug("Proxy chain has:{} proxy", (Object)proxyChain.size());
        if (proxyChain.size() > 0) {
            Socks5 pre = this.proxy;
            for (Socks5 chain : proxyChain) {
                pre.requestConnect(chain.getInetAddress(), chain.getPort());
                Objects.requireNonNull(this.proxy.getChainProxy(), "chainProxy").buildConnection();
                pre = chain;
            }
        }
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        this.connect(endpoint, 0);
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        if (!(endpoint instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        this.remoteServerHost = ((InetSocketAddress)endpoint).getHostName();
        this.remoteServerPort = ((InetSocketAddress)endpoint).getPort();
        this.getProxySocket().setSoTimeout(timeout);
        this.proxy.buildConnection();
        this.initProxyChain();
        this.proxy.requestConnect(endpoint);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.getProxySocket().getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.getProxySocket().getOutputStream();
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        this.getProxySocket().bind(bindpoint);
    }

    @Override
    public InetAddress getInetAddress() {
        try {
            return InetAddress.getByName(this.remoteServerHost);
        }
        catch (UnknownHostException e) {
            throw new SocksException(e.getMessage(), e);
        }
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.getProxySocket().getLocalAddress();
    }

    @Override
    public int getPort() {
        return this.remoteServerPort;
    }

    @Override
    public int getLocalPort() {
        return this.getProxySocket().getLocalPort();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.getProxySocket().getRemoteSocketAddress();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.getProxySocket().getLocalSocketAddress();
    }

    @Override
    public SocketChannel getChannel() {
        return this.getProxySocket().getChannel();
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.getProxySocket().getTcpNoDelay();
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        this.getProxySocket().setTcpNoDelay(on);
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.getProxySocket().setSoLinger(on, linger);
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.getProxySocket().getSoLinger();
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        this.getProxySocket().sendUrgentData(data);
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        return this.getProxySocket().getOOBInline();
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
        this.getProxySocket().setOOBInline(on);
    }

    @Override
    public synchronized int getSoTimeout() throws SocketException {
        return this.getProxySocket().getSoTimeout();
    }

    @Override
    public synchronized void setSoTimeout(int timeout) throws SocketException {
        this.getProxySocket().setSoTimeout(timeout);
    }

    @Override
    public synchronized int getSendBufferSize() throws SocketException {
        return this.getProxySocket().getSendBufferSize();
    }

    @Override
    public synchronized void setSendBufferSize(int size) throws SocketException {
        this.getProxySocket().setSendBufferSize(size);
    }

    @Override
    public synchronized int getReceiveBufferSize() throws SocketException {
        return this.getProxySocket().getReceiveBufferSize();
    }

    @Override
    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        this.getProxySocket().setReceiveBufferSize(size);
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this.getProxySocket().getKeepAlive();
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        this.getProxySocket().setKeepAlive(on);
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this.getProxySocket().getTrafficClass();
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        this.getProxySocket().setTrafficClass(tc);
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.getProxySocket().getReuseAddress();
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.getProxySocket().setReuseAddress(on);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.proxy.getProxySocket() != null) {
            this.proxy.getProxySocket().close();
            this.proxy.setProxySocket(null);
        }
    }

    @Override
    public void shutdownInput() throws IOException {
        this.getProxySocket().shutdownInput();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.getProxySocket().shutdownOutput();
    }

    @Override
    public boolean isConnected() {
        return this.getProxySocket().isConnected();
    }

    @Override
    public boolean isBound() {
        return this.getProxySocket().isBound();
    }

    @Override
    public boolean isClosed() {
        return this.getProxySocket().isClosed();
    }

    @Override
    public boolean isInputShutdown() {
        return this.getProxySocket().isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.getProxySocket().isOutputShutdown();
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.getProxySocket().setPerformancePreferences(connectionTime, latency, bandwidth);
    }

    @NotNull
    private Socket getProxySocket() {
        return Objects.requireNonNull(this.proxy.getProxySocket(), "proxySocket");
    }
}

