/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.authenticatedsockssupport.socks5server.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.simplejavamail.internal.authenticatedsockssupport.socks5server.io.SocketPipe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StreamPipe
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamPipe.class);
    private static final int DEFAULT_BUFFER_SIZE = 0x500000;
    private final List<SocketPipe.PipeListener> pipeListeners;
    private final InputStream source;
    private final OutputStream destination;
    private Thread runningThread;
    private boolean running = false;
    private final String name;

    public StreamPipe(InputStream source, OutputStream destination, String name) {
        this.source = source;
        this.destination = destination;
        this.pipeListeners = new ArrayList<SocketPipe.PipeListener>();
        this.name = name;
    }

    public boolean start() {
        if (!this.running) {
            this.running = true;
            this.runningThread = new Thread(this);
            this.runningThread.setDaemon(false);
            this.runningThread.start();
            return true;
        }
        return false;
    }

    public void stop() {
        if (this.running) {
            this.running = false;
            if (this.runningThread != null) {
                this.runningThread.interrupt();
            }
            for (SocketPipe.PipeListener listener : new ArrayList<SocketPipe.PipeListener>(this.pipeListeners)) {
                listener.onStop(this);
            }
        }
    }

    @Override
    public void run() {
        byte[] buffer = new byte[0x500000];
        while (this.running) {
            int size = this.doTransfer(buffer);
            if (size != -1) continue;
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doTransfer(byte[] buffer) {
        int length = -1;
        try {
            length = this.source.read(buffer);
            if (length > 0) {
                this.destination.write(buffer, 0, length);
                this.destination.flush();
            }
        }
        catch (IOException e) {
            StreamPipe streamPipe = this;
            synchronized (streamPipe) {
                for (SocketPipe.PipeListener pipeListener : new ArrayList<SocketPipe.PipeListener>(this.pipeListeners)) {
                    LOGGER.debug("{} {}", (Object)pipeListener.getName(), (Object)e.getMessage());
                }
            }
            this.stop();
        }
        return length;
    }

    public boolean isStopped() {
        return !this.running;
    }

    public synchronized void addPipeListener(SocketPipe.PipeListener pipeListener) {
        this.pipeListeners.add(pipeListener);
    }

    public synchronized void removePipeListener(SocketPipe.PipeListener pipeListener) {
        this.pipeListeners.remove(pipeListener);
    }

    public String getName() {
        return this.name;
    }
}

