/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.batchsupport.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

class NamedThreadFactory
implements ThreadFactory {
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final ThreadGroup group;
    private final String threadName;

    NamedThreadFactory(@NotNull String threadName) {
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.threadName = threadName;
    }

    @Override
    @NotNull
    public Thread newThread(@NotNull Runnable r) {
        Thread t = new Thread(this.group, r, String.format("%s %d", this.threadName, this.threadNumber.getAndIncrement()));
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }
}

