/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.outlooksupport.converter;

import jakarta.activation.DataSource;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeUtility;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.email.EmailPopulatingBuilder;
import org.simplejavamail.api.email.EmailStartingBuilder;
import org.simplejavamail.api.internal.general.EmailPopulatingBuilderFactory;
import org.simplejavamail.api.internal.outlooksupport.model.EmailFromOutlookMessage;
import org.simplejavamail.api.internal.outlooksupport.model.OutlookMessage;
import org.simplejavamail.internal.modules.OutlookModule;
import org.simplejavamail.internal.outlooksupport.converter.HeadersToIgnore;
import org.simplejavamail.internal.outlooksupport.converter.OutlookMessageException;
import org.simplejavamail.internal.outlooksupport.internal.model.OutlookMessageProxy;
import org.simplejavamail.internal.util.InternalEmailConverter;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.Preconditions;
import org.simplejavamail.outlookmessageparser.OutlookMessageParser;
import org.simplejavamail.outlookmessageparser.model.OutlookAttachment;
import org.simplejavamail.outlookmessageparser.model.OutlookFileAttachment;
import org.simplejavamail.outlookmessageparser.model.OutlookMsgAttachment;
import org.simplejavamail.outlookmessageparser.model.OutlookRecipient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutlookEmailConverter
implements OutlookModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(OutlookEmailConverter.class);

    public EmailFromOutlookMessage outlookMsgToEmailBuilder(@NotNull File msgFile, @NotNull EmailStartingBuilder emailStartingBuilder, @NotNull EmailPopulatingBuilderFactory builderFactory, @NotNull InternalEmailConverter internalEmailConverter) {
        return OutlookEmailConverter.buildEmailFromOutlookMessage(emailStartingBuilder.ignoringDefaults().startingBlank(), OutlookEmailConverter.parseOutlookMsg((File)Preconditions.checkNonEmptyArgument((Object)msgFile, (String)"msgFile")), builderFactory, internalEmailConverter);
    }

    public EmailFromOutlookMessage outlookMsgToEmailBuilder(@NotNull String msgFile, @NotNull EmailStartingBuilder emailStartingBuilder, @NotNull EmailPopulatingBuilderFactory builderFactory, @NotNull InternalEmailConverter internalEmailConverter) {
        return OutlookEmailConverter.buildEmailFromOutlookMessage(emailStartingBuilder.ignoringDefaults().startingBlank(), OutlookEmailConverter.parseOutlookMsg((String)Preconditions.checkNonEmptyArgument((Object)msgFile, (String)"msgFile")), builderFactory, internalEmailConverter);
    }

    public EmailFromOutlookMessage outlookMsgToEmailBuilder(@NotNull InputStream msgInputStream, @NotNull EmailStartingBuilder emailStartingBuilder, @NotNull EmailPopulatingBuilderFactory builderFactory, @NotNull InternalEmailConverter internalEmailConverter) {
        return OutlookEmailConverter.buildEmailFromOutlookMessage(emailStartingBuilder.startingBlank(), OutlookEmailConverter.parseOutlookMsg((InputStream)Preconditions.checkNonEmptyArgument((Object)msgInputStream, (String)"msgInputStream")), builderFactory, internalEmailConverter);
    }

    private static EmailFromOutlookMessage buildEmailFromOutlookMessage(@NotNull EmailPopulatingBuilder builder, @NotNull org.simplejavamail.outlookmessageparser.model.OutlookMessage outlookMessage, @NotNull EmailPopulatingBuilderFactory builderFactory, @NotNull InternalEmailConverter internalEmailConverter) {
        Preconditions.checkNonEmptyArgument((Object)builder, (String)"emailBuilder");
        Preconditions.checkNonEmptyArgument((Object)outlookMessage, (String)"outlookMessage");
        outlookMessage.getHeadersMap().entrySet().stream().filter(e -> !MiscUtil.valueNullOrEmpty(e.getKey())).forEach(entry -> ((Collection)entry.getValue()).forEach(headerValue -> OutlookEmailConverter.parseHeader((String)entry.getKey(), MimeUtility.unfold((String)headerValue), builder)));
        String fromEmail = Optional.ofNullable(outlookMessage.getFromEmail()).orElse("donotreply@unknown-from-address.net");
        builder.from(outlookMessage.getFromName(), fromEmail);
        builder.fixingMessageId(outlookMessage.getMessageId());
        builder.fixingSentDate(Optional.ofNullable(outlookMessage.getClientSubmitTime()).orElse(outlookMessage.getDate()));
        if (!MiscUtil.valueNullOrEmpty((Object)outlookMessage.getReplyToEmail())) {
            builder.withReplyTo(outlookMessage.getReplyToName(), outlookMessage.getReplyToEmail());
        }
        OutlookEmailConverter.copyReceiversFromOutlookMessage(builder, outlookMessage);
        builder.withSubject(outlookMessage.getSubject());
        builder.withPlainText(outlookMessage.getBodyText());
        builder.withHTMLText(outlookMessage.getBodyHTML() != null ? outlookMessage.getBodyHTML() : outlookMessage.getConvertedBodyHTML());
        for (Map.Entry cid : outlookMessage.fetchCIDMap().entrySet()) {
            String cidName = (String)Preconditions.checkNonEmptyArgument(cid.getKey(), (String)"cid.key");
            builder.withEmbeddedImage((String)Preconditions.verifyNonnullOrEmpty((Object)MiscUtil.extractCID((String)cidName)), ((OutlookFileAttachment)cid.getValue()).getData(), ((OutlookFileAttachment)cid.getValue()).getMimeTag());
        }
        for (OutlookFileAttachment attachment : outlookMessage.fetchTrueAttachments()) {
            String attachmentName = Optional.ofNullable(attachment.getLongFilename()).orElse(attachment.getFilename());
            builder.withAttachment(attachmentName, attachment.getData(), attachment.getMimeTag());
        }
        for (int i = 0; i < outlookMessage.getOutlookAttachments().size(); ++i) {
            OutlookFileAttachment attachment;
            attachment = (OutlookAttachment)outlookMessage.getOutlookAttachments().get(i);
            if (!(attachment instanceof OutlookMsgAttachment)) continue;
            org.simplejavamail.outlookmessageparser.model.OutlookMessage nestedMsg = ((OutlookMsgAttachment)attachment).getOutlookMessage();
            Email email = OutlookEmailConverter.buildEmailFromOutlookMessage(builderFactory.create(), nestedMsg, builderFactory, internalEmailConverter).getEmailBuilder().buildEmail();
            MimeMessage message = internalEmailConverter.emailToMimeMessage(email);
            try {
                byte[] mimedata = internalEmailConverter.mimeMessageToEMLByteArray(message);
                builder.withAttachment(nestedMsg.getSubject() + ".eml", (DataSource)new ByteArrayDataSource(mimedata, "message/rfc822"));
                continue;
            }
            catch (IllegalStateException e2) {
                boolean reasonIsEmptyMessage;
                boolean bl = reasonIsEmptyMessage = e2.getCause() instanceof MessagingException && e2.getCause().getMessage().equals("No MimeMessage content");
                if (reasonIsEmptyMessage) continue;
                throw e2;
            }
        }
        return new EmailFromOutlookMessage(builder, (OutlookMessage)new OutlookMessageProxy(outlookMessage));
    }

    private static void parseHeader(String headerName, String headerValue, EmailPopulatingBuilder builder) {
        if (OutlookEmailConverter.isEmailHeader(headerName, headerValue, "Disposition-Notification-To")) {
            builder.withDispositionNotificationTo(headerValue);
        } else if (OutlookEmailConverter.isEmailHeader(headerName, headerValue, "Return-Receipt-To")) {
            builder.withReturnReceiptTo(headerValue);
        } else if (OutlookEmailConverter.isEmailHeader(headerName, headerValue, "Return-Path")) {
            builder.withBounceTo(headerValue);
        } else if (!HeadersToIgnore.HEADERS_TO_IGNORE.contains(headerName)) {
            builder.withHeader(headerName, (Object)headerValue);
        }
    }

    private static boolean isEmailHeader(String name, String value, String emailHeaderName) {
        return name.equals(emailHeaderName) && !MiscUtil.valueNullOrEmpty((Object)value) && !MiscUtil.valueNullOrEmpty((Object)value.trim()) && !value.equals("<>");
    }

    private static void copyReceiversFromOutlookMessage(@NotNull EmailPopulatingBuilder builder, @NotNull org.simplejavamail.outlookmessageparser.model.OutlookMessage outlookMessage) {
        for (OutlookRecipient to : outlookMessage.getToRecipients()) {
            builder.to(to.getName(), to.getAddress());
        }
        for (OutlookRecipient cc : outlookMessage.getCcRecipients()) {
            builder.cc(cc.getName(), cc.getAddress());
        }
        for (OutlookRecipient bcc : outlookMessage.getBccRecipients()) {
            builder.bcc(bcc.getName(), bcc.getAddress());
        }
    }

    @NotNull
    private static org.simplejavamail.outlookmessageparser.model.OutlookMessage parseOutlookMsg(@NotNull File msgFile) {
        try {
            return new OutlookMessageParser().parseMsg(msgFile);
        }
        catch (IOException e) {
            throw new OutlookMessageException("Unable to parse Outlook message", e);
        }
    }

    @NotNull
    private static org.simplejavamail.outlookmessageparser.model.OutlookMessage parseOutlookMsg(@NotNull InputStream msgInputStream) {
        try {
            return new OutlookMessageParser().parseMsg(msgInputStream);
        }
        catch (IOException e) {
            throw new OutlookMessageException("Unable to parse Outlook message", e);
        }
    }

    @NotNull
    private static org.simplejavamail.outlookmessageparser.model.OutlookMessage parseOutlookMsg(@NotNull String msgFile) {
        try {
            return new OutlookMessageParser().parseMsg(msgFile);
        }
        catch (IOException e) {
            throw new OutlookMessageException("Unable to parse Outlook message", e);
        }
    }
}

