/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.config;

import org.simplejavamail.internal.util.ConfigLoader;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.mailer.internal.socks.SocksProxyConfig;

public class ProxyConfig
extends SocksProxyConfig {
    public static final int DEFAULT_PROXY_BRIDGE_PORT = 1081;

    public ProxyConfig() {
        this(null, null, null, null);
    }

    public ProxyConfig(String remoteProxyHost, Integer remoteProxyPort) {
        this(remoteProxyHost, remoteProxyPort, null, null);
    }

    public ProxyConfig(String remoteProxyHost, Integer remoteProxyPort, String username, String password) {
        super(ConfigLoader.valueOrProperty(remoteProxyHost, ConfigLoader.Property.PROXY_HOST), ConfigLoader.valueOrProperty(remoteProxyPort, ConfigLoader.Property.PROXY_PORT), ConfigLoader.valueOrProperty(username, ConfigLoader.Property.PROXY_USERNAME), ConfigLoader.valueOrProperty(password, ConfigLoader.Property.PROXY_PASSWORD), ConfigLoader.valueOrProperty(null, ConfigLoader.Property.PROXY_SOCKS5BRIDGE_PORT, 1081));
        if (!MiscUtil.valueNullOrEmpty(this.remoteProxyHost)) {
            MiscUtil.checkArgumentNotEmpty(this.remoteProxyPort, "remoteProxyPort not given and not configured in config file");
            if (!MiscUtil.valueNullOrEmpty(this.username) && MiscUtil.valueNullOrEmpty(this.password)) {
                throw new IllegalArgumentException("Proxy username provided but no password given as argument or in config file");
            }
            if (MiscUtil.valueNullOrEmpty(this.username) && !MiscUtil.valueNullOrEmpty(this.password)) {
                throw new IllegalArgumentException("Proxy password provided but no username given as argument or in config file");
            }
        }
    }

    public boolean requiresProxy() {
        return this.remoteProxyHost != null;
    }

    public boolean requiresAuthentication() {
        return this.username != null;
    }

    public String toString() {
        String str = "";
        if (this.remoteProxyHost == null) {
            return "no-proxy";
        }
        str = str + String.format("%s:%s", this.remoteProxyHost, this.remoteProxyPort);
        if (this.username != null) {
            str = str + String.format(", username: %s", this.username);
        }
        if (this.proxyBridgePort != 1081) {
            str = str + String.format(", proxy bridge @ localhost:%s", this.proxyBridgePort);
        }
        return str;
    }

    public int getProxyBridgePort() {
        return this.proxyBridgePort;
    }

    public void setProxyBridgePort(int proxyBridgePort) {
        this.proxyBridgePort = proxyBridgePort;
    }

    public String getRemoteProxyHost() {
        return this.remoteProxyHost;
    }

    public Integer getRemoteProxyPort() {
        return this.remoteProxyPort;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

