/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.email;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import javax.mail.Message;
import javax.mail.util.ByteArrayDataSource;
import org.simplejavamail.email.AttachmentResource;
import org.simplejavamail.email.Email;
import org.simplejavamail.email.Recipient;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.util.ConfigLoader;

public class EmailBuilder {
    private Recipient fromRecipient;
    private Recipient replyToRecipient;
    private String text;
    private String textHTML;
    private String subject;
    private final List<Recipient> recipients = new ArrayList<Recipient>();
    private final List<AttachmentResource> embeddedImages = new ArrayList<AttachmentResource>();
    private final List<AttachmentResource> attachments = new ArrayList<AttachmentResource>();
    private final Map<String, String> headers = new HashMap<String, String>();
    private File dkimPrivateKeyFile;
    private InputStream dkimPrivateKeyInputStream;
    private String signingDomain;
    private String selector;

    public EmailBuilder() {
        if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_FROM_ADDRESS)) {
            this.from((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_FROM_NAME), (String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_FROM_ADDRESS));
        }
        if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_REPLYTO_ADDRESS)) {
            this.replyTo((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_REPLYTO_NAME), (String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_REPLYTO_ADDRESS));
        }
        if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_TO_ADDRESS)) {
            this.to((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_TO_NAME), (String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_TO_ADDRESS));
        }
        if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_CC_ADDRESS)) {
            this.cc((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_CC_NAME), (String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_CC_ADDRESS));
        }
        if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_BCC_ADDRESS)) {
            this.bcc((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_BCC_NAME), (String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_BCC_ADDRESS));
        }
        if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_SUBJECT)) {
            this.subject((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_SUBJECT));
        }
    }

    public Email build() {
        return new Email(this);
    }

    public EmailBuilder from(String name, String fromAddress) {
        this.fromRecipient = new Recipient(name, fromAddress, null);
        return this;
    }

    public EmailBuilder replyTo(String name, String replyToAddress) {
        this.replyToRecipient = new Recipient(name, replyToAddress, null);
        return this;
    }

    public EmailBuilder subject(String subject) {
        this.subject = subject;
        return this;
    }

    public EmailBuilder text(String text) {
        this.text = text;
        return this;
    }

    public EmailBuilder textHTML(String textHTML) {
        this.textHTML = textHTML;
        return this;
    }

    public EmailBuilder to(String name, String address) {
        this.recipients.add(new Recipient(name, address, Message.RecipientType.TO));
        return this;
    }

    public EmailBuilder to(Recipient recipient) {
        this.recipients.add(new Recipient(recipient.getName(), recipient.getAddress(), Message.RecipientType.TO));
        return this;
    }

    public EmailBuilder cc(String name, String address) {
        this.recipients.add(new Recipient(name, address, Message.RecipientType.CC));
        return this;
    }

    public EmailBuilder cc(Recipient recipient) {
        this.recipients.add(new Recipient(recipient.getName(), recipient.getAddress(), Message.RecipientType.CC));
        return this;
    }

    public EmailBuilder bcc(String name, String address) {
        this.recipients.add(new Recipient(name, address, Message.RecipientType.BCC));
        return this;
    }

    public EmailBuilder bcc(Recipient recipient) {
        this.recipients.add(new Recipient(recipient.getName(), recipient.getAddress(), Message.RecipientType.BCC));
        return this;
    }

    public EmailBuilder embedImage(String name, byte[] data, String mimetype) {
        ByteArrayDataSource dataSource = new ByteArrayDataSource(data, mimetype);
        dataSource.setName(name);
        return this.embedImage(name, (DataSource)dataSource);
    }

    public EmailBuilder embedImage(String name, DataSource imagedata) {
        this.embeddedImages.add(new AttachmentResource(name, imagedata));
        return this;
    }

    public EmailBuilder addHeader(String name, Object value) {
        this.headers.put(name, String.valueOf(value));
        return this;
    }

    public EmailBuilder addAttachment(String name, byte[] data, String mimetype) {
        ByteArrayDataSource dataSource = new ByteArrayDataSource(data, mimetype);
        dataSource.setName(MiscUtil.encodeText(name));
        this.addAttachment(MiscUtil.encodeText(name), (DataSource)dataSource);
        return this;
    }

    public EmailBuilder addAttachment(String name, DataSource filedata) {
        this.attachments.add(new AttachmentResource(MiscUtil.encodeText(name), filedata));
        return this;
    }

    public EmailBuilder signWithDomainKey(byte[] dkimPrivateKey, String signingDomain, String selector) {
        this.dkimPrivateKeyInputStream = new ByteArrayInputStream(dkimPrivateKey);
        this.signingDomain = signingDomain;
        this.selector = selector;
        return this;
    }

    public EmailBuilder signWithDomainKey(String dkimPrivateKey, String signingDomain, String selector) {
        this.dkimPrivateKeyInputStream = new ByteArrayInputStream(dkimPrivateKey.getBytes(StandardCharsets.UTF_8));
        this.signingDomain = signingDomain;
        this.selector = selector;
        return this;
    }

    public EmailBuilder signWithDomainKey(File dkimPrivateKeyFile, String signingDomain, String selector) {
        this.dkimPrivateKeyFile = dkimPrivateKeyFile;
        this.signingDomain = signingDomain;
        this.selector = selector;
        return this;
    }

    public EmailBuilder signWithDomainKey(InputStream dkimPrivateKeyInputStream, String signingDomain, String selector) {
        this.dkimPrivateKeyInputStream = dkimPrivateKeyInputStream;
        this.signingDomain = signingDomain;
        this.selector = selector;
        return this;
    }

    public Recipient getFromRecipient() {
        return this.fromRecipient;
    }

    public Recipient getReplyToRecipient() {
        return this.replyToRecipient;
    }

    public String getText() {
        return this.text;
    }

    public String getTextHTML() {
        return this.textHTML;
    }

    public String getSubject() {
        return this.subject;
    }

    public List<Recipient> getRecipients() {
        return this.recipients;
    }

    public List<AttachmentResource> getEmbeddedImages() {
        return this.embeddedImages;
    }

    public List<AttachmentResource> getAttachments() {
        return this.attachments;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public File getDkimPrivateKeyFile() {
        return this.dkimPrivateKeyFile;
    }

    public InputStream getDkimPrivateKeyInputStream() {
        return this.dkimPrivateKeyInputStream;
    }

    public String getSigningDomain() {
        return this.signingDomain;
    }

    public String getSelector() {
        return this.selector;
    }
}

