/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.util;

import java.io.UnsupportedEncodingException;
import javax.mail.internet.MimeUtility;

public final class MiscUtil {
    public static <T> T checkNotNull(T value, String msg) {
        if (value == null) {
            throw new NullPointerException(msg);
        }
        return value;
    }

    public static <T> T checkArgumentNotEmpty(T value, String msg) {
        if (MiscUtil.valueNullOrEmpty(value)) {
            throw new IllegalArgumentException(msg);
        }
        return value;
    }

    public static <T> boolean valueNullOrEmpty(T value) {
        return value == null || value instanceof String && ((String)value).isEmpty();
    }

    public static String buildLogString(byte[] bytes, boolean isReceived) {
        StringBuilder debugMsg = new StringBuilder();
        debugMsg.append(isReceived ? "Received: " : "Sent: ");
        for (byte aByte : bytes) {
            debugMsg.append(Integer.toHexString(MiscUtil.toInt(aByte))).append(" ");
        }
        return debugMsg.toString();
    }

    public static int toInt(byte b) {
        return b & 0xFF;
    }

    public static String encodeText(String name) {
        try {
            return MimeUtility.encodeText((String)name);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }
}

