/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer;

import java.util.EnumSet;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.hazlewood.connor.bottema.emailaddress.EmailAddressCriteria;
import org.hazlewood.connor.bottema.emailaddress.EmailAddressValidator;
import org.simplejavamail.MailException;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageHelper;
import org.simplejavamail.email.Email;
import org.simplejavamail.email.Recipient;
import org.simplejavamail.mailer.MailerException;
import org.simplejavamail.mailer.config.ProxyConfig;
import org.simplejavamail.mailer.config.ServerConfig;
import org.simplejavamail.mailer.config.TransportStrategy;
import org.simplejavamail.mailer.internal.mailsender.MailSender;
import org.simplejavamail.util.ConfigLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mailer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Mailer.class);
    private final MailSender mailSender;
    private EnumSet<EmailAddressCriteria> emailAddressCriteria = EmailAddressCriteria.RFC_COMPLIANT;

    public Mailer(Session session) {
        this(session, new ProxyConfig());
    }

    public Mailer(Session session, ProxyConfig proxyConfig) {
        if (ConfigLoader.hasProperty(ConfigLoader.Property.JAVAXMAIL_DEBUG)) {
            this.setDebug((Boolean)ConfigLoader.getProperty(ConfigLoader.Property.JAVAXMAIL_DEBUG));
        }
        this.mailSender = new MailSender(session, proxyConfig, TransportStrategy.findStrategyForSession(session));
    }

    public Mailer() {
        this(new ServerConfig(null, null, null, null), null, null);
    }

    public Mailer(String host, Integer port, String username, String password) {
        this(new ServerConfig(host, port, username, password), null, null);
    }

    public Mailer(ServerConfig serverConfig) {
        this(serverConfig, null, null);
    }

    public Mailer(String host, Integer port, String username, String password, TransportStrategy transportStrategy) {
        this(new ServerConfig(host, port, username, password), transportStrategy, null);
    }

    public Mailer(ServerConfig serverConfig, TransportStrategy transportStrategy) {
        this(serverConfig, transportStrategy, null);
    }

    public Mailer(ServerConfig serverConfig, ProxyConfig proxyConfig) {
        this(serverConfig, null, proxyConfig);
    }

    public Mailer(ServerConfig serverConfig, TransportStrategy transportStrategy, ProxyConfig proxyConfig) {
        TransportStrategy effectiveTransportStrategy = ConfigLoader.valueOrProperty(transportStrategy, ConfigLoader.Property.TRANSPORT_STRATEGY, TransportStrategy.SMTP_PLAIN);
        Session session = Mailer.createMailSession(serverConfig, effectiveTransportStrategy);
        this.mailSender = new MailSender(session, proxyConfig, effectiveTransportStrategy);
        this.emailAddressCriteria = null;
        if (ConfigLoader.hasProperty(ConfigLoader.Property.JAVAXMAIL_DEBUG)) {
            this.setDebug((Boolean)ConfigLoader.getProperty(ConfigLoader.Property.JAVAXMAIL_DEBUG));
        }
    }

    public static Session createMailSession(ServerConfig serverConfig, TransportStrategy transportStrategy) {
        Properties props = transportStrategy.generateProperties();
        props.put(transportStrategy.propertyNameHost(), serverConfig.getHost());
        props.put(transportStrategy.propertyNamePort(), String.valueOf(serverConfig.getPort()));
        if (serverConfig.getUsername() != null) {
            props.put(transportStrategy.propertyNameUsername(), serverConfig.getUsername());
        }
        if (serverConfig.getPassword() != null) {
            props.put(transportStrategy.propertyNameAuthenticate(), "true");
            return Session.getInstance((Properties)props, (Authenticator)new SmtpAuthenticator(serverConfig));
        }
        return Session.getInstance((Properties)props);
    }

    public Session getSession() {
        LOGGER.warn("Providing access to Session instance for emergency fall-back scenario. Please let us know why you need it.");
        LOGGER.warn("\t>https://github.com/bbottema/simple-java-mail/issues");
        return this.mailSender.getSession();
    }

    public void setDebug(boolean debug) {
        this.mailSender.setDebug(debug);
    }

    public synchronized void setTransportModeLoggingOnly(boolean transportModeLoggingOnly) {
        this.mailSender.setTransportModeLoggingOnly(transportModeLoggingOnly);
    }

    public boolean isTransportModeLoggingOnly() {
        return this.mailSender.isTransportModeLoggingOnly();
    }

    public void trustAllSSLHosts(boolean trustAllHosts) {
        this.mailSender.trustAllHosts(trustAllHosts);
    }

    public void trustSSLHosts(String ... hosts) {
        this.mailSender.trustHosts(hosts);
    }

    public void applyProperties(Properties properties) {
        this.mailSender.applyProperties(properties);
    }

    public void setThreadPoolSize(int poolSize) {
        this.mailSender.setThreadPoolSize(poolSize);
    }

    public final void sendMail(Email email) {
        this.sendMail(email, false);
    }

    public final synchronized void sendMail(Email email, boolean async) {
        if (this.validate(email)) {
            this.mailSender.send(email, async);
        }
    }

    public boolean validate(Email email) throws MailException {
        if (email.getText() == null && email.getTextHTML() == null) {
            throw new MailerException("Email is not valid: missing content body");
        }
        if (email.getSubject() == null || email.getSubject().equals("")) {
            throw new MailerException("Email is not valid: missing subject");
        }
        if (email.getRecipients().size() == 0) {
            throw new MailerException("Email is not valid: missing recipients");
        }
        if (email.getFromRecipient() == null) {
            throw new MailerException("Email is not valid: missing sender");
        }
        if (this.emailAddressCriteria != null) {
            if (!EmailAddressValidator.isValid(email.getFromRecipient().getAddress(), this.emailAddressCriteria)) {
                throw new MailerException(String.format("Invalid FROM address: %s", email));
            }
            for (Recipient recipient : email.getRecipients()) {
                if (EmailAddressValidator.isValid(recipient.getAddress(), this.emailAddressCriteria)) continue;
                throw new MailerException(String.format("Invalid TO address: %s", email));
            }
            if (email.getReplyToRecipient() != null && !EmailAddressValidator.isValid(email.getReplyToRecipient().getAddress(), this.emailAddressCriteria)) {
                throw new MailerException(String.format("Invalid REPLY TO address: %s", email));
            }
        }
        return true;
    }

    public static MimeMessage signMessageWithDKIM(MimeMessage message, Email email) {
        return MimeMessageHelper.signMessageWithDKIM(message, email);
    }

    public void setEmailAddressCriteria(EnumSet<EmailAddressCriteria> emailAddressCriteria) {
        this.emailAddressCriteria = emailAddressCriteria;
    }

    private static class SmtpAuthenticator
    extends Authenticator {
        private final ServerConfig serverConfig;

        public SmtpAuthenticator(ServerConfig serverConfig) {
            this.serverConfig = serverConfig;
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.serverConfig.getUsername(), this.serverConfig.getPassword());
        }
    }
}

