/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.converter.internal.mimemessage;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;
import javax.mail.util.ByteArrayDataSource;
import org.simplejavamail.internal.util.MiscUtil;

public class MimeMessageParser {
    private static final List<String> DEFAULT_HEADERS = new ArrayList<String>();
    private final Map<String, DataSource> attachmentList = new HashMap<String, DataSource>();
    private final Map<String, DataSource> cidMap = new HashMap<String, DataSource>();
    private final Map<String, Object> headers = new HashMap<String, Object>();
    private final MimeMessage mimeMessage;
    private String plainContent;
    private String htmlContent;

    public MimeMessageParser(MimeMessage message) {
        this.mimeMessage = message;
    }

    public MimeMessageParser parse() throws MessagingException, IOException {
        this.parse((MimePart)this.mimeMessage);
        return this;
    }

    public List<InternetAddress> getTo() throws MessagingException {
        return MimeMessageParser.getInternetAddresses(this.mimeMessage.getRecipients(Message.RecipientType.TO));
    }

    public List<InternetAddress> getCc() throws MessagingException {
        return MimeMessageParser.getInternetAddresses(this.mimeMessage.getRecipients(Message.RecipientType.CC));
    }

    public List<InternetAddress> getBcc() throws MessagingException {
        return MimeMessageParser.getInternetAddresses(this.mimeMessage.getRecipients(Message.RecipientType.BCC));
    }

    private static List<InternetAddress> getInternetAddresses(Address[] recipients) {
        ArrayList addresses = recipients != null ? Arrays.asList(recipients) : new ArrayList();
        ArrayList<InternetAddress> mailAddresses = new ArrayList<InternetAddress>();
        for (Address address : addresses) {
            if (!(address instanceof InternetAddress)) continue;
            mailAddresses.add((InternetAddress)address);
        }
        return mailAddresses;
    }

    public InternetAddress getFrom() throws MessagingException {
        Address[] addresses = this.mimeMessage.getFrom();
        if (addresses == null || addresses.length == 0) {
            return null;
        }
        return (InternetAddress)addresses[0];
    }

    public InternetAddress getReplyTo() throws MessagingException {
        Address[] addresses = this.mimeMessage.getReplyTo();
        if (addresses == null || addresses.length == 0) {
            return null;
        }
        return (InternetAddress)addresses[0];
    }

    public String getSubject() throws MessagingException {
        return this.mimeMessage.getSubject();
    }

    private void parse(MimePart part) throws MessagingException, IOException {
        this.extractCustomUserHeaders(part);
        if (MimeMessageParser.isMimeType(part, "text/plain") && this.plainContent == null && !"attachment".equalsIgnoreCase(part.getDisposition())) {
            this.plainContent = (String)part.getContent();
        } else if (MimeMessageParser.isMimeType(part, "text/html") && this.htmlContent == null && !"attachment".equalsIgnoreCase(part.getDisposition())) {
            this.htmlContent = (String)part.getContent();
        } else if (MimeMessageParser.isMimeType(part, "multipart/*")) {
            Multipart mp = (Multipart)part.getContent();
            int count = mp.getCount();
            for (int i = 0; i < count; ++i) {
                this.parse((MimePart)((MimeBodyPart)mp.getBodyPart(i)));
            }
        } else {
            DataSource ds = MimeMessageParser.createDataSource(part);
            if (part.getDisposition() == null || "attachment".equalsIgnoreCase(part.getDisposition())) {
                this.attachmentList.put(MimeMessageParser.parseResourceName(part.getContentID(), part.getFileName()), ds);
            } else if ("inline".equalsIgnoreCase(part.getDisposition())) {
                this.cidMap.put(part.getContentID(), ds);
            } else {
                throw new IllegalStateException("invalid attachment type");
            }
        }
    }

    private static String parseResourceName(String contentID, String fileName) {
        String extension = "";
        if (!MiscUtil.valueNullOrEmpty(fileName) && fileName.contains(".")) {
            extension = fileName.substring(fileName.lastIndexOf("."), fileName.length());
        }
        if (!MiscUtil.valueNullOrEmpty(contentID)) {
            return contentID.endsWith(extension) ? contentID : contentID + extension;
        }
        return fileName;
    }

    private void extractCustomUserHeaders(MimePart part) throws MessagingException {
        Enumeration e = part.getAllHeaders();
        while (e.hasMoreElements()) {
            Header header;
            Object headerObj = e.nextElement();
            if (!(headerObj instanceof Header) || !MimeMessageParser.isCustomUserHeader(header = (Header)headerObj)) continue;
            this.headers.put(header.getName(), header.getValue());
        }
    }

    private static boolean isCustomUserHeader(Header header) {
        return !DEFAULT_HEADERS.contains(header.getName());
    }

    private static boolean isMimeType(MimePart part, String mimeType) throws MessagingException {
        try {
            ContentType ct = new ContentType(part.getDataHandler().getContentType());
            return ct.match(mimeType);
        }
        catch (ParseException ex) {
            return part.getContentType().equalsIgnoreCase(mimeType);
        }
    }

    private static DataSource createDataSource(MimePart part) throws MessagingException, IOException {
        DataHandler dataHandler = part.getDataHandler();
        DataSource dataSource = dataHandler.getDataSource();
        String contentType = MimeMessageParser.getBaseMimeType(dataSource.getContentType());
        byte[] content = MimeMessageParser.getContent(dataSource.getInputStream());
        ByteArrayDataSource result = new ByteArrayDataSource(content, contentType);
        String dataSourceName = MimeMessageParser.getDataSourceName((Part)part, dataSource);
        result.setName(dataSourceName);
        return result;
    }

    private static String getDataSourceName(Part part, DataSource dataSource) throws MessagingException, UnsupportedEncodingException {
        String result = dataSource.getName();
        if (result == null || result.length() == 0) {
            result = part.getFileName();
        }
        result = result != null && result.length() > 0 ? MimeUtility.decodeText((String)result) : null;
        return result;
    }

    private static byte[] getContent(InputStream is) throws IOException {
        int ch;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        BufferedInputStream isReader = new BufferedInputStream(is);
        BufferedOutputStream osWriter = new BufferedOutputStream(os);
        while ((ch = isReader.read()) != -1) {
            osWriter.write(ch);
        }
        osWriter.flush();
        byte[] result = os.toByteArray();
        osWriter.close();
        return result;
    }

    private static String getBaseMimeType(String fullMimeType) {
        int pos = fullMimeType.indexOf(59);
        if (pos >= 0) {
            return fullMimeType.substring(0, pos);
        }
        return fullMimeType;
    }

    public Map<String, DataSource> getCidMap() {
        return this.cidMap;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public String getPlainContent() {
        return this.plainContent;
    }

    public Map<String, DataSource> getAttachmentList() {
        return this.attachmentList;
    }

    public String getHtmlContent() {
        return this.htmlContent;
    }

    static {
        DEFAULT_HEADERS.add("Return-Path");
        DEFAULT_HEADERS.add("Received");
        DEFAULT_HEADERS.add("Resent-Date");
        DEFAULT_HEADERS.add("Resent-From");
        DEFAULT_HEADERS.add("Resent-Sender");
        DEFAULT_HEADERS.add("Resent-To");
        DEFAULT_HEADERS.add("Resent-Cc");
        DEFAULT_HEADERS.add("Resent-Bcc");
        DEFAULT_HEADERS.add("Resent-Message-Id");
        DEFAULT_HEADERS.add("Date");
        DEFAULT_HEADERS.add("From");
        DEFAULT_HEADERS.add("Sender");
        DEFAULT_HEADERS.add("Reply-To");
        DEFAULT_HEADERS.add("To");
        DEFAULT_HEADERS.add("Cc");
        DEFAULT_HEADERS.add("Bcc");
        DEFAULT_HEADERS.add("Message-Id");
        DEFAULT_HEADERS.add("In-Reply-To");
        DEFAULT_HEADERS.add("References");
        DEFAULT_HEADERS.add("Subject");
        DEFAULT_HEADERS.add("Comments");
        DEFAULT_HEADERS.add("Keywords");
        DEFAULT_HEADERS.add("Errors-To");
        DEFAULT_HEADERS.add("MIME-Version");
        DEFAULT_HEADERS.add("Content-Type");
        DEFAULT_HEADERS.add("Content-Transfer-Encoding");
        DEFAULT_HEADERS.add("Content-MD5");
        DEFAULT_HEADERS.add(":");
        DEFAULT_HEADERS.add("Content-Length");
        DEFAULT_HEADERS.add("Status");
        DEFAULT_HEADERS.add("Content-Disposition");
        DEFAULT_HEADERS.add("size");
        DEFAULT_HEADERS.add("filename");
        DEFAULT_HEADERS.add("Content-ID");
        DEFAULT_HEADERS.add("name");
        DEFAULT_HEADERS.add("From");
    }
}

