/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.outlookmessageparser.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.poi.hmef.CompressedRTF;
import org.simplejavamail.outlookmessageparser.model.OutlookAttachment;
import org.simplejavamail.outlookmessageparser.model.OutlookFileAttachment;
import org.simplejavamail.outlookmessageparser.model.OutlookMessageProperty;
import org.simplejavamail.outlookmessageparser.model.OutlookRecipient;
import org.simplejavamail.outlookmessageparser.rtf.RTF2HTMLConverter;
import org.simplejavamail.outlookmessageparser.rtf.SimpleRTF2HTMLConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutlookMessage {
    private static final Logger LOGGER = LoggerFactory.getLogger(OutlookMessage.class);
    private static final String WINDOWS_CHARSET = "CP1252";
    private String messageClass = "IPM.Note";
    private String messageId;
    private String fromEmail;
    private String fromName;
    private String toEmail;
    private String toName;
    private String replyToEmail;
    private String replyToName;
    private String subject;
    private String bodyText;
    private String displayTo;
    private String displayCc;
    private String displayBcc;
    private String bodyRTF;
    private String bodyHTML;
    private String convertedBodyHTML;
    private String headers;
    private Date date;
    private Date clientSubmitTime;
    private Date creationDate;
    private Date lastModificationDate;
    private final List<OutlookAttachment> outlookAttachments = new ArrayList<OutlookAttachment>();
    private final Map<Integer, Object> properties = new TreeMap<Integer, Object>();
    private final List<OutlookRecipient> recipients = new ArrayList<OutlookRecipient>();
    private final RTF2HTMLConverter rtf2htmlConverter;

    public OutlookMessage() {
        this.rtf2htmlConverter = new SimpleRTF2HTMLConverter();
    }

    public OutlookMessage(RTF2HTMLConverter rtf2htmlConverter) {
        this.rtf2htmlConverter = rtf2htmlConverter != null ? rtf2htmlConverter : new SimpleRTF2HTMLConverter();
    }

    public void addAttachment(OutlookAttachment outlookAttachment) {
        this.outlookAttachments.add(outlookAttachment);
    }

    public void addRecipient(OutlookRecipient recipient) {
        this.recipients.add(recipient);
        if (this.toEmail == null) {
            this.setToEmail(recipient.getAddress());
        }
        if (this.toName == null) {
            this.setToName(recipient.getName());
        }
    }

    public void setProperty(OutlookMessageProperty msgProp) {
        String name = msgProp.getClazz();
        Object value = msgProp.getData();
        if (name == null || value == null) {
            return;
        }
        String stringValue = this.convertValueToString(value);
        int mapiClass = -1;
        try {
            mapiClass = Integer.parseInt(name, 16);
        }
        catch (NumberFormatException e) {
            LOGGER.trace("Unexpected type: {}", (Object)name, (Object)e);
        }
        switch (mapiClass) {
            case 26: {
                this.setMessageClass(stringValue);
                break;
            }
            case 4149: {
                this.setMessageId(stringValue);
                break;
            }
            case 55: 
            case 3613: {
                this.setSubject(stringValue);
                break;
            }
            case 101: 
            case 3103: 
            case 16378: 
            case 32776: 
            case 32781: {
                this.setFromEmail(stringValue);
                break;
            }
            case 66: {
                this.setFromName(stringValue);
                break;
            }
            case 118: {
                this.setToEmail(stringValue, true);
                break;
            }
            case 32768: {
                this.setToEmail(stringValue);
                break;
            }
            case 12289: {
                this.setToName(stringValue);
                break;
            }
            case 3588: {
                this.setDisplayTo(stringValue);
                break;
            }
            case 3587: {
                this.setDisplayCc(stringValue);
                break;
            }
            case 3586: {
                this.setDisplayBcc(stringValue);
                break;
            }
            case 4115: {
                this.setBodyHTML(stringValue);
                break;
            }
            case 4096: {
                this.setBodyText(stringValue);
                break;
            }
            case 4105: {
                this.setBodyRTF(value);
                break;
            }
            case 125: {
                this.setHeaders(stringValue);
                break;
            }
            case 12295: {
                this.setCreationDate(stringValue);
                break;
            }
            case 12296: {
                this.setLastModificationDate(stringValue);
                break;
            }
            case 57: {
                this.setClientSubmitTime(stringValue);
            }
        }
        this.properties.put(mapiClass, value);
        this.checkToRecipient();
    }

    private String convertValueToString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof byte[]) {
            try {
                return new String((byte[])value, WINDOWS_CHARSET);
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("Unsupported encoding!", (Throwable)e);
                return null;
            }
        }
        LOGGER.trace("Unexpected body class: {} (expected String or byte[])", (Object)value.getClass().getName());
        return value.toString();
    }

    private void checkToRecipient() {
        OutlookRecipient toRecipient = this.getToRecipient();
        if (toRecipient != null) {
            this.setToEmail(toRecipient.getAddress(), true);
            this.setToName(toRecipient.getName());
            this.recipients.remove(toRecipient);
            this.recipients.add(0, toRecipient);
        }
    }

    public Map<String, OutlookFileAttachment> fetchCIDMap() {
        HashMap<String, OutlookFileAttachment> cidMap = new HashMap<String, OutlookFileAttachment>();
        String html = this.getConvertedBodyHTML();
        if (html != null && html.length() != 0) {
            for (OutlookAttachment attachment : this.getOutlookAttachments()) {
                OutlookFileAttachment fileAttachment;
                String cid;
                if (!(attachment instanceof OutlookFileAttachment) || (cid = (fileAttachment = (OutlookFileAttachment)attachment).getFilename()) == null || cid.length() == 0 || !this.htmlContainsCID(html, cid)) continue;
                cidMap.put(cid, fileAttachment);
            }
        }
        return cidMap;
    }

    public List<OutlookFileAttachment> fetchTrueAttachments() {
        HashSet<OutlookAttachment> allAttachments = new HashSet<OutlookAttachment>(this.getOutlookAttachments());
        allAttachments.removeAll(this.fetchCIDMap().values());
        ArrayList<OutlookFileAttachment> fileAttachments = new ArrayList<OutlookFileAttachment>();
        for (OutlookAttachment attachment : allAttachments) {
            if (attachment instanceof OutlookFileAttachment) {
                fileAttachments.add((OutlookFileAttachment)attachment);
                continue;
            }
            LOGGER.warn("Skipping nested Outlook message as file attachment, writing Outlook messages back as data is not supported!");
            LOGGER.warn("To access the nested Outlook message as parsed Java object, refer to .getAttachments() instead.");
        }
        return fileAttachments;
    }

    private boolean htmlContainsCID(String html, String cidName) {
        return Pattern.compile("cid:['\"]?" + cidName + "['\"]?").matcher(html).find();
    }

    private static Date parseDateString(String date) {
        ArrayList<SimpleDateFormat> sdfList = new ArrayList<SimpleDateFormat>(2);
        sdfList.add(new SimpleDateFormat("EEE MMM d HH:mm:ss z yyyy", Locale.US));
        sdfList.add(new SimpleDateFormat("EEE MMM d HH:mm:ss z yyyy"));
        Date d = null;
        for (SimpleDateFormat sdf : sdfList) {
            try {
                d = sdf.parse(date);
                if (d == null) continue;
                break;
            }
            catch (ParseException e) {
                LOGGER.trace("Unexpected date format for date {}", (Object)date, (Object)e);
            }
        }
        return d;
    }

    private byte[] decompressRtfBytes(byte[] value) {
        byte[] decompressed = null;
        if (value != null) {
            try {
                CompressedRTF crtf = new CompressedRTF();
                decompressed = crtf.decompress((InputStream)new ByteArrayInputStream(value));
            }
            catch (IOException e) {
                LOGGER.error("Could not decompress RTF data", (Throwable)e);
            }
        }
        return decompressed;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("From: ").append(this.createMailString(this.fromEmail, this.fromName)).append("\n");
        sb.append("To: ").append(this.createMailString(this.toEmail, this.toName)).append("\n");
        if (this.date != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.ENGLISH);
            sb.append("Date: ").append(formatter.format(this.date)).append("\n");
        }
        if (this.subject != null) {
            sb.append("Subject: ").append(this.subject).append("\n");
        }
        sb.append("").append(this.outlookAttachments.size()).append(" outlookAttachments.");
        return sb.toString();
    }

    public String toLongString() {
        StringBuilder sb = new StringBuilder();
        sb.append("From: ").append(this.createMailString(this.fromEmail, this.fromName)).append("\n");
        sb.append("To: ").append(this.createMailString(this.toEmail, this.toName)).append("\n");
        if (this.date != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.ENGLISH);
            sb.append("Date: ").append(formatter.format(this.date)).append("\n");
        }
        if (this.subject != null) {
            sb.append("Subject: ").append(this.subject).append("\n");
        }
        sb.append("\n");
        if (this.bodyText != null) {
            sb.append(this.bodyText);
        }
        if (!this.outlookAttachments.isEmpty()) {
            sb.append("\n");
            sb.append("").append(this.outlookAttachments.size()).append(" outlookAttachments.\n");
            for (OutlookAttachment att : this.outlookAttachments) {
                sb.append(att).append("\n");
            }
        }
        return sb.toString();
    }

    private String createMailString(String mail, String name) {
        if (mail == null && name == null) {
            return null;
        }
        if (name == null) {
            return mail;
        }
        if (mail == null) {
            return name;
        }
        if (mail.equalsIgnoreCase(name)) {
            return mail;
        }
        return "\"" + name + "\" <" + mail + ">";
    }

    public List<OutlookAttachment> getOutlookAttachments() {
        return this.outlookAttachments;
    }

    public List<OutlookRecipient> getRecipients() {
        return this.recipients;
    }

    public String getFromEmail() {
        return this.fromEmail;
    }

    private void setFromEmail(String fromEmail) {
        if (fromEmail != null && fromEmail.contains("@")) {
            this.setFromEmail(fromEmail, true);
        } else {
            this.setFromEmail(fromEmail, false);
        }
    }

    private void setFromEmail(String fromEmail, boolean force) {
        if ((force || this.fromEmail == null) && fromEmail != null && fromEmail.contains("@")) {
            this.fromEmail = fromEmail;
        }
    }

    public String getFromName() {
        return this.fromName;
    }

    private void setFromName(String fromName) {
        if (fromName != null) {
            this.fromName = fromName;
        }
    }

    public String getDisplayTo() {
        return this.displayTo;
    }

    private void setDisplayTo(String displayTo) {
        if (displayTo != null) {
            this.displayTo = displayTo;
        }
    }

    public String getDisplayCc() {
        return this.displayCc;
    }

    private void setDisplayCc(String displayCc) {
        if (displayCc != null) {
            this.displayCc = displayCc;
        }
    }

    public String getDisplayBcc() {
        return this.displayBcc;
    }

    private void setDisplayBcc(String displayBcc) {
        if (displayBcc != null) {
            this.displayBcc = displayBcc;
        }
    }

    public String getMessageClass() {
        return this.messageClass;
    }

    private void setMessageClass(String messageClass) {
        if (messageClass != null) {
            this.messageClass = messageClass;
        }
    }

    public String getMessageId() {
        return this.messageId;
    }

    private void setMessageId(String messageId) {
        if (messageId != null) {
            this.messageId = messageId;
        }
    }

    public String getSubject() {
        return this.subject;
    }

    private void setSubject(String subject) {
        if (subject != null) {
            this.subject = subject;
        }
    }

    public String getToEmail() {
        return this.toEmail;
    }

    private void setToEmail(String toEmail) {
        this.setToEmail(toEmail, false);
    }

    private void setToEmail(String toEmail, boolean force) {
        if ((force || this.toEmail == null) && toEmail != null && toEmail.contains("@")) {
            this.toEmail = toEmail;
        }
    }

    public String getToName() {
        return this.toName;
    }

    private void setToName(String toName) {
        if (toName != null) {
            this.toName = toName.trim();
        }
    }

    public OutlookRecipient getToRecipient() {
        if (this.getDisplayTo() != null) {
            String recipientKey = this.getDisplayTo().trim();
            for (OutlookRecipient entry : this.recipients) {
                String name = entry.getName().trim();
                if (!recipientKey.contains(name)) continue;
                return entry;
            }
        }
        return null;
    }

    public List<OutlookRecipient> getCcRecipients() {
        ArrayList<OutlookRecipient> recipients = new ArrayList<OutlookRecipient>();
        String recipientKey = this.getDisplayCc().trim();
        for (OutlookRecipient entry : recipients) {
            String name = entry.getName().trim();
            if (!recipientKey.contains(name)) continue;
            recipients.add(entry);
        }
        return recipients;
    }

    public List<OutlookRecipient> getBccRecipients() {
        ArrayList<OutlookRecipient> recipients = new ArrayList<OutlookRecipient>();
        String recipientKey = this.getDisplayBcc().trim();
        for (OutlookRecipient entry : recipients) {
            String name = entry.getName().trim();
            if (!recipientKey.contains(name)) continue;
            recipients.add(entry);
        }
        return recipients;
    }

    public String getBodyText() {
        return this.bodyText;
    }

    private void setBodyText(String bodyText) {
        if (this.bodyText == null && bodyText != null) {
            this.bodyText = bodyText;
        }
    }

    public String getBodyRTF() {
        return this.bodyRTF;
    }

    private void setBodyRTF(Object bodyRTF) {
        if (this.bodyRTF == null && bodyRTF != null) {
            if (bodyRTF instanceof byte[]) {
                byte[] decompressedBytes = this.decompressRtfBytes((byte[])bodyRTF);
                if (decompressedBytes != null) {
                    try {
                        this.bodyRTF = new String(decompressedBytes, WINDOWS_CHARSET);
                        this.setConvertedBodyHTML(this.rtf2htmlConverter.rtf2html(this.bodyRTF));
                    }
                    catch (UnsupportedEncodingException e) {
                        LOGGER.error("Could not convert RTF body to HTML.", (Throwable)e);
                    }
                }
            } else {
                LOGGER.warn("Unexpected data type {}", bodyRTF.getClass());
            }
        }
    }

    public String getBodyHTML() {
        return this.bodyHTML;
    }

    public String getConvertedBodyHTML() {
        return this.convertedBodyHTML;
    }

    private void setConvertedBodyHTML(String convertedBodyHTML) {
        this.convertedBodyHTML = convertedBodyHTML;
    }

    private void setBodyHTML(String bodyToSet) {
        if (bodyToSet != null && (this.bodyHTML == null || this.bodyHTML.length() <= bodyToSet.length())) {
            this.bodyHTML = bodyToSet;
        }
    }

    public String getHeaders() {
        return this.headers;
    }

    private void setHeaders(String headers) {
        if (headers != null) {
            String s;
            this.headers = headers;
            Date d = OutlookMessage.getDateFromHeaders(headers);
            if (d != null) {
                this.setDate(d);
            }
            if ((s = OutlookMessage.getFromEmailFromHeaders(headers)) != null) {
                this.setFromEmail(s);
            }
        }
    }

    private static String getFromEmailFromHeaders(String headers) {
        if (headers != null) {
            String[] headerLines;
            for (String headerLine : headerLines = headers.split("\n")) {
                String[] tokens;
                if (!headerLine.toUpperCase().startsWith("FROM: ")) continue;
                for (String potentialFromEmailToken : tokens = headerLine.split(" ")) {
                    if (!potentialFromEmailToken.contains("@")) continue;
                    return potentialFromEmailToken.replaceAll("[<>]", "").trim();
                }
            }
        }
        return null;
    }

    private static Date getDateFromHeaders(String headers) {
        if (headers != null) {
            String[] headerLines;
            for (String headerLine : headerLines = headers.split("\n")) {
                if (!headerLine.toLowerCase().startsWith("date:")) continue;
                String dateValue = headerLine.substring("Date:".length()).trim();
                SimpleDateFormat formatter = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.ENGLISH);
                try {
                    Date date = formatter.parse(dateValue);
                    if (date != null) {
                        return date;
                    }
                }
                catch (ParseException e) {
                    LOGGER.debug("Could not parse date {}, moving on to the next date candidate", (Object)dateValue, (Object)e);
                }
            }
        }
        return null;
    }

    public Date getDate() {
        return this.date;
    }

    private void setDate(Date date) {
        this.date = date;
    }

    public Date getClientSubmitTime() {
        return this.clientSubmitTime;
    }

    private void setClientSubmitTime(String value) {
        Date d;
        if (value != null && (d = OutlookMessage.parseDateString(value)) != null) {
            this.clientSubmitTime = d;
        }
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    private void setCreationDate(String value) {
        Date d;
        if (value != null && (d = OutlookMessage.parseDateString(value)) != null) {
            this.creationDate = d;
            this.setDate(d);
        }
    }

    public Date getLastModificationDate() {
        return this.lastModificationDate;
    }

    private void setLastModificationDate(String value) {
        Date d;
        if (value != null && (d = OutlookMessage.parseDateString(value)) != null) {
            this.lastModificationDate = d;
        }
    }

    public Set<String> getPropertiesAsHex() {
        Set<Integer> keySet = this.properties.keySet();
        HashSet<String> result = new HashSet<String>();
        for (Integer k : keySet) {
            String s = this.convertToHex(k);
            result.add(s);
        }
        return result;
    }

    public Set<Integer> getPropertyCodes() {
        return this.properties.keySet();
    }

    private Object getPropertyValue(Integer code) {
        return this.properties.get(code);
    }

    public String getPropertyListing() {
        StringBuilder sb = new StringBuilder();
        for (Integer propCode : this.getPropertyCodes()) {
            Object value = this.getPropertyValue(propCode);
            String hexCode = "0x" + this.convertToHex(propCode);
            sb.append(hexCode).append(" / ").append(propCode);
            sb.append(": ").append(value);
            sb.append("\n");
        }
        return sb.toString();
    }

    private String convertToHex(Integer propCode) {
        return String.format("%04x", propCode);
    }

    public String getReplyToEmail() {
        return this.replyToEmail;
    }

    public void setReplyToEmail(String replyToEmail) {
        this.replyToEmail = replyToEmail;
    }

    public String getReplyToName() {
        return this.replyToName;
    }

    public void setReplyToName(String replyToName) {
        this.replyToName = replyToName;
    }
}

