/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.converter.internal.mimemessage;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import net.markenwerk.utils.mail.dkim.Canonicalization;
import net.markenwerk.utils.mail.dkim.DkimMessage;
import net.markenwerk.utils.mail.dkim.DkimSigner;
import net.markenwerk.utils.mail.dkim.SigningAlgorithm;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageException;
import org.simplejavamail.converter.internal.mimemessage.NamedDataSource;
import org.simplejavamail.email.AttachmentResource;
import org.simplejavamail.email.Email;
import org.simplejavamail.email.Recipient;
import org.simplejavamail.internal.util.MiscUtil;

public final class MimeMessageHelper {
    private static final String CHARACTER_ENCODING = StandardCharsets.UTF_8.name();

    private MimeMessageHelper() {
    }

    public static MimeMessage produceMimeMessage(final Email email, Session session) throws MessagingException, UnsupportedEncodingException {
        if (email == null) {
            throw new IllegalStateException("email is missing");
        }
        if (session == null) {
            throw new IllegalStateException("session is needed, it cannot be attached later");
        }
        MimeEmailMessageWrapper messageRoot = new MimeEmailMessageWrapper();
        MimeMessage message = new MimeMessage(session){

            protected void updateMessageID() throws MessagingException {
                if (MiscUtil.valueNullOrEmpty(email.getId())) {
                    super.updateMessageID();
                } else {
                    this.setHeader("Message-ID", email.getId());
                }
            }
        };
        message.setSubject(email.getSubject(), CHARACTER_ENCODING);
        message.setFrom((Address)new InternetAddress(email.getFromRecipient().getAddress(), email.getFromRecipient().getName(), CHARACTER_ENCODING));
        MimeMessageHelper.setReplyTo(email, (Message)message);
        MimeMessageHelper.setRecipients(email, (Message)message);
        MimeMessageHelper.setTexts(email, messageRoot.multipartAlternativeMessages);
        MimeMessageHelper.setEmbeddedImages(email, messageRoot.multipartRelated);
        MimeMessageHelper.setAttachments(email, messageRoot.multipartRoot);
        message.setContent((Multipart)messageRoot.multipartRoot);
        MimeMessageHelper.setHeaders(email, (Message)message);
        message.setSentDate(new Date());
        if (email.isApplyDKIMSignature()) {
            return MimeMessageHelper.signMessageWithDKIM(message, email);
        }
        return message;
    }

    private static void setRecipients(Email email, Message message) throws UnsupportedEncodingException, MessagingException {
        for (Recipient recipient : email.getRecipients()) {
            InternetAddress address = new InternetAddress(recipient.getAddress(), recipient.getName(), CHARACTER_ENCODING);
            message.addRecipient(recipient.getType(), (Address)address);
        }
    }

    private static void setReplyTo(Email email, Message message) throws UnsupportedEncodingException, MessagingException {
        Recipient replyToRecipient = email.getReplyToRecipient();
        if (replyToRecipient != null) {
            InternetAddress replyToAddress = new InternetAddress(replyToRecipient.getAddress(), replyToRecipient.getName(), CHARACTER_ENCODING);
            message.setReplyTo(new Address[]{replyToAddress});
        }
    }

    private static void setTexts(Email email, MimeMultipart multipartAlternativeMessages) throws MessagingException {
        if (email.getText() != null) {
            MimeBodyPart messagePart = new MimeBodyPart();
            messagePart.setText(email.getText(), CHARACTER_ENCODING);
            multipartAlternativeMessages.addBodyPart((BodyPart)messagePart);
        }
        if (email.getTextHTML() != null) {
            MimeBodyPart messagePartHTML = new MimeBodyPart();
            messagePartHTML.setContent((Object)email.getTextHTML(), "text/html; charset=\"" + CHARACTER_ENCODING + "\"");
            multipartAlternativeMessages.addBodyPart((BodyPart)messagePartHTML);
        }
    }

    private static void setEmbeddedImages(Email email, MimeMultipart multipartRelated) throws MessagingException {
        for (AttachmentResource embeddedImage : email.getEmbeddedImages()) {
            multipartRelated.addBodyPart(MimeMessageHelper.getBodyPartFromDatasource(embeddedImage, "inline"));
        }
    }

    private static void setAttachments(Email email, MimeMultipart multipartRoot) throws MessagingException {
        for (AttachmentResource resource : email.getAttachments()) {
            multipartRoot.addBodyPart(MimeMessageHelper.getBodyPartFromDatasource(resource, "attachment"));
        }
    }

    private static void setHeaders(Email email, Message message) throws UnsupportedEncodingException, MessagingException {
        for (Map.Entry<String, String> header : email.getHeaders().entrySet()) {
            String headerName = header.getKey();
            String headerValue = MimeUtility.encodeText((String)header.getValue(), (String)CHARACTER_ENCODING, null);
            String foldedHeaderValue = MimeUtility.fold((int)(headerName.length() + 2), (String)headerValue);
            message.addHeader(header.getKey(), foldedHeaderValue);
        }
    }

    private static BodyPart getBodyPartFromDatasource(AttachmentResource attachmentResource, String dispositionType) throws MessagingException {
        MimeBodyPart attachmentPart = new MimeBodyPart();
        String resourceName = MimeMessageHelper.determineResourceName(attachmentResource, false);
        String fileName = MimeMessageHelper.determineResourceName(attachmentResource, true);
        attachmentPart.setDataHandler(new DataHandler((DataSource)new NamedDataSource(fileName, attachmentResource.getDataSource())));
        attachmentPart.setFileName(fileName);
        String contentType = attachmentResource.getDataSource().getContentType();
        attachmentPart.setHeader("Content-Type", contentType + "; filename=" + fileName + "; name=" + resourceName);
        attachmentPart.setHeader("Content-ID", String.format("<%s>", resourceName));
        attachmentPart.setDisposition(dispositionType + "; size=0");
        return attachmentPart;
    }

    static String determineResourceName(AttachmentResource attachmentResource, boolean includeExtension) {
        String datasourceName = attachmentResource.getDataSource().getName();
        String resourceName = !MiscUtil.valueNullOrEmpty(attachmentResource.getName()) ? attachmentResource.getName() : (!MiscUtil.valueNullOrEmpty(datasourceName) ? datasourceName : "resource" + UUID.randomUUID());
        if (includeExtension && !MiscUtil.valueNullOrEmpty(datasourceName)) {
            String extension;
            String possibleFilename = datasourceName;
            if (possibleFilename.contains(".") && !resourceName.endsWith(extension = possibleFilename.substring(possibleFilename.lastIndexOf("."), possibleFilename.length()))) {
                resourceName = resourceName + extension;
            }
        } else if (!includeExtension && resourceName.contains(".") && resourceName.equals(datasourceName)) {
            String extension = resourceName.substring(resourceName.lastIndexOf("."), resourceName.length());
            resourceName = resourceName.replace(extension, "");
        }
        return resourceName;
    }

    public static MimeMessage signMessageWithDKIM(MimeMessage message, Email email) {
        try {
            DkimSigner dkimSigner = email.getDkimPrivateKeyFile() != null ? new DkimSigner(email.getSigningDomain(), email.getSelector(), email.getDkimPrivateKeyFile()) : new DkimSigner(email.getSigningDomain(), email.getSelector(), email.getDkimPrivateKeyInputStream());
            dkimSigner.setIdentity(email.getFromRecipient().getAddress());
            dkimSigner.setHeaderCanonicalization(Canonicalization.SIMPLE);
            dkimSigner.setBodyCanonicalization(Canonicalization.RELAXED);
            dkimSigner.setSigningAlgorithm(SigningAlgorithm.SHA256_WITH_RSA);
            dkimSigner.setLengthParam(true);
            dkimSigner.setZParam(false);
            return new DkimMessage(message, dkimSigner);
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException | MessagingException e) {
            throw new MimeMessageException("Error signing MimeMessage with DKIM", (Exception)e);
        }
    }

    private static class MimeEmailMessageWrapper {
        private final MimeMultipart multipartRoot = new MimeMultipart("mixed");
        private final MimeMultipart multipartRelated;
        private final MimeMultipart multipartAlternativeMessages;

        MimeEmailMessageWrapper() {
            MimeBodyPart contentRelated = new MimeBodyPart();
            this.multipartRelated = new MimeMultipart("related");
            MimeBodyPart contentAlternativeMessages = new MimeBodyPart();
            this.multipartAlternativeMessages = new MimeMultipart("alternative");
            try {
                this.multipartRoot.addBodyPart((BodyPart)contentRelated);
                contentRelated.setContent((Multipart)this.multipartRelated);
                this.multipartRelated.addBodyPart((BodyPart)contentAlternativeMessages);
                contentAlternativeMessages.setContent((Multipart)this.multipartAlternativeMessages);
            }
            catch (MessagingException e) {
                throw new MimeMessageException(e.getMessage(), (Exception)((Object)e));
            }
        }
    }
}

