/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.email;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.Message;
import javax.mail.util.ByteArrayDataSource;
import org.simplejavamail.email.AttachmentResource;
import org.simplejavamail.email.Email;
import org.simplejavamail.email.EmailException;
import org.simplejavamail.email.Recipient;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.Preconditions;
import org.simplejavamail.util.ConfigLoader;

public class EmailBuilder {
    private String id;
    private Recipient fromRecipient;
    private Recipient replyToRecipient;
    private String text;
    private String textHTML;
    private String subject;
    private final List<Recipient> recipients = new ArrayList<Recipient>();
    private final List<AttachmentResource> embeddedImages = new ArrayList<AttachmentResource>();
    private final List<AttachmentResource> attachments = new ArrayList<AttachmentResource>();
    private final Map<String, String> headers = new HashMap<String, String>();
    private File dkimPrivateKeyFile;
    private InputStream dkimPrivateKeyInputStream;
    private String signingDomain;
    private String selector;

    public EmailBuilder() {
        if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_FROM_ADDRESS)) {
            this.from((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_FROM_NAME), (String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_FROM_ADDRESS));
        }
        if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_REPLYTO_ADDRESS)) {
            this.replyTo((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_REPLYTO_NAME), (String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_REPLYTO_ADDRESS));
        }
        if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_TO_ADDRESS)) {
            if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_TO_NAME)) {
                this.to((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_TO_NAME), (String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_TO_ADDRESS));
            } else {
                this.to((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_TO_ADDRESS));
            }
        }
        if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_CC_ADDRESS)) {
            if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_CC_NAME)) {
                this.cc((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_CC_NAME), (String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_CC_ADDRESS));
            } else {
                this.cc((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_CC_ADDRESS));
            }
        }
        if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_BCC_ADDRESS)) {
            if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_BCC_NAME)) {
                this.bcc((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_BCC_NAME), (String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_BCC_ADDRESS));
            } else {
                this.bcc((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_BCC_ADDRESS));
            }
        }
        if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_SUBJECT)) {
            this.subject((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_SUBJECT));
        }
    }

    public Email build() {
        return new Email(this);
    }

    public EmailBuilder id(@Nullable String id) {
        this.id = id;
        return this;
    }

    public EmailBuilder from(@Nullable String name, @Nonnull String fromAddress) {
        Preconditions.checkNonEmptyArgument(fromAddress, "fromAddress");
        this.fromRecipient = new Recipient(name, fromAddress, null);
        return this;
    }

    public EmailBuilder from(@Nonnull Recipient recipient) {
        Preconditions.checkNonEmptyArgument(recipient, "recipient");
        this.fromRecipient = new Recipient(recipient.getName(), recipient.getAddress(), null);
        return this;
    }

    public EmailBuilder replyTo(@Nullable String name, @Nonnull String replyToAddress) {
        Preconditions.checkNonEmptyArgument(replyToAddress, "replyToAddress");
        this.replyToRecipient = new Recipient(name, replyToAddress, null);
        return this;
    }

    public EmailBuilder replyTo(@Nonnull Recipient recipient) {
        Preconditions.checkNonEmptyArgument(recipient, "recipient");
        this.replyToRecipient = new Recipient(recipient.getName(), recipient.getAddress(), null);
        return this;
    }

    public EmailBuilder subject(@Nonnull String subject) {
        this.subject = Preconditions.checkNonEmptyArgument(subject, "subject");
        return this;
    }

    public EmailBuilder text(@Nullable String text) {
        this.text = text;
        return this;
    }

    public EmailBuilder textHTML(@Nullable String textHTML) {
        this.textHTML = textHTML;
        return this;
    }

    public EmailBuilder to(@Nullable String name, @Nonnull String address) {
        Preconditions.checkNonEmptyArgument(address, "address");
        this.recipients.add(new Recipient(name, address, Message.RecipientType.TO));
        return this;
    }

    public EmailBuilder to(Recipient ... recipientsToAdd) {
        for (Recipient recipient : Preconditions.checkNonEmptyArgument(recipientsToAdd, "recipientsToAdd")) {
            this.recipients.add(new Recipient(recipient.getName(), recipient.getAddress(), Message.RecipientType.TO));
        }
        return this;
    }

    public EmailBuilder to(@Nonnull String emailAddressList) {
        Preconditions.checkNonEmptyArgument(emailAddressList, "emailAddressList");
        return this.addCommaOrSemicolonSeparatedEmailAddresses(emailAddressList, Message.RecipientType.TO);
    }

    @Nonnull
    private EmailBuilder addCommaOrSemicolonSeparatedEmailAddresses(@Nonnull String emailAddressList, @Nonnull Message.RecipientType type) {
        Preconditions.checkNonEmptyArgument(type, "type");
        for (String emailAddress : MiscUtil.extractEmailAddresses(Preconditions.checkNonEmptyArgument(emailAddressList, "emailAddressList"))) {
            this.recipients.add(new Recipient(null, emailAddress, type));
        }
        return this;
    }

    public EmailBuilder to(String ... emailAddresses) {
        for (String emailAddress : Preconditions.checkNonEmptyArgument(emailAddresses, "emailAddresses")) {
            this.recipients.add(new Recipient(null, emailAddress, Message.RecipientType.TO));
        }
        return this;
    }

    public EmailBuilder cc(@Nullable String name, @Nonnull String address) {
        Preconditions.checkNonEmptyArgument(address, "address");
        this.recipients.add(new Recipient(name, address, Message.RecipientType.CC));
        return this;
    }

    public EmailBuilder cc(String ... emailAddresses) {
        for (String emailAddress : Preconditions.checkNonEmptyArgument(emailAddresses, "emailAddresses")) {
            this.recipients.add(new Recipient(null, emailAddress, Message.RecipientType.CC));
        }
        return this;
    }

    public EmailBuilder cc(@Nonnull String emailAddressList) {
        Preconditions.checkNonEmptyArgument(emailAddressList, "emailAddressList");
        return this.addCommaOrSemicolonSeparatedEmailAddresses(emailAddressList, Message.RecipientType.CC);
    }

    public EmailBuilder cc(Recipient ... recipientsToAdd) {
        for (Recipient recipient : Preconditions.checkNonEmptyArgument(recipientsToAdd, "recipientsToAdd")) {
            this.recipients.add(new Recipient(recipient.getName(), recipient.getAddress(), Message.RecipientType.CC));
        }
        return this;
    }

    public EmailBuilder bcc(@Nullable String name, @Nonnull String address) {
        Preconditions.checkNonEmptyArgument(address, "address");
        this.recipients.add(new Recipient(name, address, Message.RecipientType.BCC));
        return this;
    }

    public EmailBuilder bcc(String ... emailAddresses) {
        for (String emailAddress : Preconditions.checkNonEmptyArgument(emailAddresses, "emailAddresses")) {
            this.recipients.add(new Recipient(null, emailAddress, Message.RecipientType.BCC));
        }
        return this;
    }

    public EmailBuilder bcc(@Nonnull String emailAddressList) {
        Preconditions.checkNonEmptyArgument(emailAddressList, "emailAddressList");
        return this.addCommaOrSemicolonSeparatedEmailAddresses(emailAddressList, Message.RecipientType.BCC);
    }

    public EmailBuilder bcc(Recipient ... recipientsToAdd) {
        for (Recipient recipient : Preconditions.checkNonEmptyArgument(recipientsToAdd, "recipientsToAdd")) {
            this.recipients.add(new Recipient(recipient.getName(), recipient.getAddress(), Message.RecipientType.BCC));
        }
        return this;
    }

    public EmailBuilder embedImage(@Nonnull String name, @Nonnull byte[] data, @Nonnull String mimetype) {
        Preconditions.checkNonEmptyArgument(name, "name");
        Preconditions.checkNonEmptyArgument(data, "data");
        Preconditions.checkNonEmptyArgument(mimetype, "mimetype");
        ByteArrayDataSource dataSource = new ByteArrayDataSource(data, mimetype);
        dataSource.setName(name);
        return this.embedImage(name, (DataSource)dataSource);
    }

    public EmailBuilder embedImage(@Nullable String name, @Nonnull DataSource imagedata) {
        Preconditions.checkNonEmptyArgument(imagedata, "imagedata");
        if (MiscUtil.valueNullOrEmpty(name) && MiscUtil.valueNullOrEmpty(imagedata.getName())) {
            throw new EmailException("No name given for embedded image nor passed inside the data source");
        }
        this.embeddedImages.add(new AttachmentResource(name, imagedata));
        return this;
    }

    public EmailBuilder addHeader(@Nonnull String name, @Nonnull Object value) {
        Preconditions.checkNonEmptyArgument(name, "name");
        Preconditions.checkNonEmptyArgument(value, "value");
        this.headers.put(name, String.valueOf(value));
        return this;
    }

    public EmailBuilder addAttachment(@Nullable String name, @Nonnull byte[] data, @Nonnull String mimetype) {
        Preconditions.checkNonEmptyArgument(data, "data");
        Preconditions.checkNonEmptyArgument(mimetype, "mimetype");
        ByteArrayDataSource dataSource = new ByteArrayDataSource(data, mimetype);
        dataSource.setName(MiscUtil.encodeText(name));
        this.addAttachment(MiscUtil.encodeText(name), (DataSource)dataSource);
        return this;
    }

    public EmailBuilder addAttachment(@Nullable String name, @Nonnull DataSource filedata) {
        Preconditions.checkNonEmptyArgument(filedata, "filedata");
        this.attachments.add(new AttachmentResource(MiscUtil.encodeText(name), filedata));
        return this;
    }

    public EmailBuilder signWithDomainKey(@Nonnull byte[] dkimPrivateKey, @Nonnull String signingDomain, @Nonnull String selector) {
        this.dkimPrivateKeyInputStream = new ByteArrayInputStream(Preconditions.checkNonEmptyArgument(dkimPrivateKey, "dkimPrivateKey"));
        this.signingDomain = Preconditions.checkNonEmptyArgument(signingDomain, "signingDomain");
        this.selector = Preconditions.checkNonEmptyArgument(selector, "selector");
        return this;
    }

    public EmailBuilder signWithDomainKey(@Nonnull String dkimPrivateKey, @Nonnull String signingDomain, @Nonnull String selector) {
        Preconditions.checkNonEmptyArgument(dkimPrivateKey, "dkimPrivateKey");
        this.dkimPrivateKeyInputStream = new ByteArrayInputStream(dkimPrivateKey.getBytes(StandardCharsets.UTF_8));
        this.signingDomain = Preconditions.checkNonEmptyArgument(signingDomain, "signingDomain");
        this.selector = Preconditions.checkNonEmptyArgument(selector, "selector");
        return this;
    }

    public EmailBuilder signWithDomainKey(@Nonnull File dkimPrivateKeyFile, @Nonnull String signingDomain, @Nonnull String selector) {
        this.dkimPrivateKeyFile = Preconditions.checkNonEmptyArgument(dkimPrivateKeyFile, "dkimPrivateKeyFile");
        this.signingDomain = Preconditions.checkNonEmptyArgument(signingDomain, "signingDomain");
        this.selector = Preconditions.checkNonEmptyArgument(selector, "selector");
        return this;
    }

    public EmailBuilder signWithDomainKey(@Nonnull InputStream dkimPrivateKeyInputStream, @Nonnull String signingDomain, @Nonnull String selector) {
        this.dkimPrivateKeyInputStream = Preconditions.checkNonEmptyArgument(dkimPrivateKeyInputStream, "dkimPrivateKeyInputStream");
        this.signingDomain = Preconditions.checkNonEmptyArgument(signingDomain, "signingDomain");
        this.selector = Preconditions.checkNonEmptyArgument(selector, "selector");
        return this;
    }

    public String getId() {
        return this.id;
    }

    public Recipient getFromRecipient() {
        return this.fromRecipient;
    }

    public Recipient getReplyToRecipient() {
        return this.replyToRecipient;
    }

    public String getText() {
        return this.text;
    }

    public String getTextHTML() {
        return this.textHTML;
    }

    public String getSubject() {
        return this.subject;
    }

    public List<Recipient> getRecipients() {
        return this.recipients;
    }

    public List<AttachmentResource> getEmbeddedImages() {
        return this.embeddedImages;
    }

    public List<AttachmentResource> getAttachments() {
        return this.attachments;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public File getDkimPrivateKeyFile() {
        return this.dkimPrivateKeyFile;
    }

    public InputStream getDkimPrivateKeyInputStream() {
        return this.dkimPrivateKeyInputStream;
    }

    public String getSigningDomain() {
        return this.signingDomain;
    }

    public String getSelector() {
        return this.selector;
    }
}

