/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.internal.mailsender;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Phaser;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import org.simplejavamail.converter.EmailConverter;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageHelper;
import org.simplejavamail.email.Email;
import org.simplejavamail.mailer.config.ProxyConfig;
import org.simplejavamail.mailer.config.TransportStrategy;
import org.simplejavamail.mailer.internal.mailsender.MailSenderException;
import org.simplejavamail.mailer.internal.socks.AuthenticatingSocks5Bridge;
import org.simplejavamail.mailer.internal.socks.socks5server.AnonymousSocks5Server;
import org.simplejavamail.util.ConfigLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailSender.class);
    private static final boolean DEFAULT_MODE_LOGGING_ONLY = false;
    private static final int DEFAULT_SESSION_TIMEOUT_MILLIS = 60000;
    private static final int DEFAULT_POOL_SIZE = 10;
    private final Session session;
    private AnonymousSocks5Server proxyServer = null;
    private ExecutorService executor;
    private Phaser smtpRequestsPhaser;
    private int sessionTimeout;
    private int threadPoolSize;
    private boolean transportModeLoggingOnly;

    public MailSender(Session session, ProxyConfig proxyConfig, TransportStrategy transportStrategy) {
        this.session = session;
        this.proxyServer = MailSender.configureSessionWithProxy(proxyConfig, session, transportStrategy);
        this.threadPoolSize = ConfigLoader.valueOrProperty(null, ConfigLoader.Property.DEFAULT_POOL_SIZE, 10);
        this.sessionTimeout = ConfigLoader.valueOrProperty(null, ConfigLoader.Property.DEFAULT_SESSION_TIMEOUT_MILLIS, 60000);
        this.transportModeLoggingOnly = ConfigLoader.valueOrProperty(null, ConfigLoader.Property.TRANSPORT_MODE_LOGGING_ONLY, false);
    }

    private static AnonymousSocks5Server configureSessionWithProxy(ProxyConfig proxyConfig, Session session, TransportStrategy transportStrategy) {
        ProxyConfig effectiveProxyConfig;
        ProxyConfig proxyConfig2 = effectiveProxyConfig = proxyConfig != null ? proxyConfig : new ProxyConfig();
        if (!effectiveProxyConfig.requiresProxy()) {
            LOGGER.debug("No proxy set, skipping proxy.");
        } else {
            if (transportStrategy == TransportStrategy.SMTP_SSL) {
                throw new MailSenderException("Proxy is not supported for SSL connections (this is a limitation by the underlying JavaMail framework)");
            }
            Properties sessionProperties = session.getProperties();
            sessionProperties.put("mail.smtp.socks.host", effectiveProxyConfig.getRemoteProxyHost());
            sessionProperties.put("mail.smtp.socks.port", String.valueOf(effectiveProxyConfig.getRemoteProxyPort()));
            if (effectiveProxyConfig.requiresAuthentication()) {
                sessionProperties.put("mail.smtp.socks.host", "localhost");
                sessionProperties.put("mail.smtp.socks.port", String.valueOf(effectiveProxyConfig.getProxyBridgePort()));
                return new AnonymousSocks5Server(new AuthenticatingSocks5Bridge(effectiveProxyConfig), effectiveProxyConfig.getProxyBridgePort());
            }
        }
        return null;
    }

    public final synchronized void send(final Email email, boolean async) {
        if (this.smtpRequestsPhaser == null || this.smtpRequestsPhaser.isTerminated()) {
            this.smtpRequestsPhaser = new Phaser();
        }
        this.smtpRequestsPhaser.register();
        if (async) {
            if (this.executor == null || this.executor.isTerminated()) {
                this.executor = Executors.newFixedThreadPool(this.threadPoolSize);
            }
            this.configureSessionWithTimeout(this.session, this.sessionTimeout);
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    MailSender.this.sendMailClosure(MailSender.this.session, email);
                }

                public String toString() {
                    return "sendMail process";
                }
            });
        } else {
            this.sendMailClosure(this.session, email);
        }
    }

    private void configureSessionWithTimeout(Session session, int sessionTimeout) {
        Properties sessionProperties = session.getProperties();
        sessionProperties.put("mail.smtp.connectiontimeout", String.valueOf(sessionTimeout));
        sessionProperties.put("mail.smtp.timeout", String.valueOf(sessionTimeout));
        sessionProperties.put("mail.smtp.writetimeout", String.valueOf(sessionTimeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMailClosure(Session session, Email email) {
        block15: {
            LOGGER.trace("sending email...");
            try {
                MimeMessage message = MimeMessageHelper.produceMimeMessage(email, session);
                MailSender.logSession(session);
                message.saveChanges();
                Transport transport = session.getTransport();
                try {
                    MailSender mailSender = this;
                    synchronized (mailSender) {
                        if (this.proxyServer != null && !this.proxyServer.isRunning()) {
                            LOGGER.trace("starting proxy bridge");
                            this.proxyServer.start();
                        }
                    }
                    if (!this.transportModeLoggingOnly) {
                        LOGGER.trace("\t\nEmail: {}", (Object)email);
                        LOGGER.trace("\t\nMimeMessage: {}\n", (Object)EmailConverter.mimeMessageToEML(message));
                        try {
                            transport.connect();
                            transport.sendMessage((Message)message, message.getAllRecipients());
                            break block15;
                        }
                        finally {
                            LOGGER.trace("closing transport");
                            transport.close();
                        }
                    }
                    LOGGER.info("TRANSPORT_MODE_LOGGING_ONLY: skipping actual sending...");
                    LOGGER.info("\n\nEmail: {}\n", (Object)email);
                    LOGGER.info("\n\nMimeMessage: {}\n", (Object)EmailConverter.mimeMessageToEML(message));
                }
                finally {
                    this.checkShutDownRunningProcesses();
                }
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("Failed to send email:\n{}", (Object)email);
                throw new MailSenderException("Encoding not accepted", e);
            }
            catch (MessagingException e) {
                LOGGER.error("Failed to send email:\n{}", (Object)email);
                throw new MailSenderException("Third party error", (Exception)((Object)e));
            }
            catch (Exception e) {
                LOGGER.error("Failed to send email:\n{}", (Object)email);
                throw e;
            }
        }
    }

    private synchronized void checkShutDownRunningProcesses() {
        this.smtpRequestsPhaser.arriveAndDeregister();
        LOGGER.trace("SMTP request threads left: {}", (Object)this.smtpRequestsPhaser.getUnarrivedParties());
        if (this.smtpRequestsPhaser.getUnarrivedParties() == 0) {
            LOGGER.trace("all threads have finished processing");
            if (this.proxyServer != null && this.proxyServer.isRunning() && !this.proxyServer.isStopping()) {
                LOGGER.trace("stopping proxy bridge...");
                this.proxyServer.stop();
            }
            if (this.executor != null) {
                this.executor.shutdown();
            }
        }
    }

    private static void logSession(Session session) {
        TransportStrategy transportStrategy = TransportStrategy.findStrategyForSession(session);
        Properties properties = session.getProperties();
        String sessionDetails = transportStrategy != null ? transportStrategy.toString(properties) : properties.toString();
        LOGGER.debug("starting mail with " + sessionDetails);
    }

    public void setDebug(boolean debug) {
        this.session.setDebug(debug);
    }

    public void trustAllHosts(boolean trustAllHosts) {
        this.session.getProperties().remove("mail.smtp.ssl.trust");
        if (trustAllHosts) {
            this.session.getProperties().setProperty("mail.smtp.ssl.trust", "*");
        }
    }

    public void trustHosts(String ... hosts) {
        this.trustAllHosts(false);
        if (hosts.length > 0) {
            StringBuilder builder = new StringBuilder(hosts[0]);
            for (int i = 1; i < hosts.length; ++i) {
                builder.append(",").append(hosts[i]);
            }
            this.session.getProperties().setProperty("mail.smtp.ssl.trust", builder.toString());
        }
    }

    public void applyProperties(Properties properties) {
        this.session.getProperties().putAll((Map<?, ?>)properties);
    }

    public Session getSession() {
        return this.session;
    }

    public synchronized void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public synchronized void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public synchronized void setTransportModeLoggingOnly(boolean transportModeLoggingOnly) {
        this.transportModeLoggingOnly = transportModeLoggingOnly;
    }

    public boolean isTransportModeLoggingOnly() {
        return this.transportModeLoggingOnly;
    }
}

