/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.converter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataSource;
import javax.annotation.Nonnull;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.simplejavamail.converter.EmailConverterException;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageHelper;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageParser;
import org.simplejavamail.converter.internal.msgparser.OutlookMessageParser;
import org.simplejavamail.email.Email;
import org.simplejavamail.email.Recipient;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.Preconditions;
import org.simplejavamail.outlookmessageparser.model.OutlookFileAttachment;
import org.simplejavamail.outlookmessageparser.model.OutlookMessage;
import org.simplejavamail.outlookmessageparser.model.OutlookRecipient;

public final class EmailConverter {
    private EmailConverter() {
    }

    public static Email mimeMessageToEmail(@Nonnull MimeMessage mimeMessage) {
        Email email = new Email(false);
        try {
            EmailConverter.fillEmailFromMimeMessage(email, Preconditions.checkNonEmptyArgument(mimeMessage, "mimeMessage"));
        }
        catch (IOException | MessagingException e) {
            throw new EmailConverterException(String.format("Error parsing MimeMessage: %s", e.getMessage()), (Exception)e);
        }
        return email;
    }

    public static Email outlookMsgToEmail(@Nonnull String msgData) {
        Email email = new Email(false);
        OutlookMessage outlookMessage = OutlookMessageParser.parseOutlookMsg(Preconditions.checkNonEmptyArgument(msgData, "msgData"));
        EmailConverter.fillEmailFromOutlookMessage(email, outlookMessage);
        return email;
    }

    public static Email outlookMsgToEmail(@Nonnull File msgfile) {
        Email email = new Email(false);
        OutlookMessage outlookMessage = OutlookMessageParser.parseOutlookMsg(Preconditions.checkNonEmptyArgument(msgfile, "msgfile"));
        EmailConverter.fillEmailFromOutlookMessage(email, outlookMessage);
        return email;
    }

    public static Email outlookMsgToEmail(@Nonnull InputStream msgInputStream) {
        Email email = new Email(false);
        OutlookMessage outlookMessage = OutlookMessageParser.parseOutlookMsg(Preconditions.checkNonEmptyArgument(msgInputStream, "msgInputStream"));
        EmailConverter.fillEmailFromOutlookMessage(email, outlookMessage);
        return email;
    }

    public static Email emlToEmail(@Nonnull String eml) {
        MimeMessage mimeMessage = EmailConverter.emlToMimeMessage(Preconditions.checkNonEmptyArgument(eml, "eml"), EmailConverter.createDummySession());
        return EmailConverter.mimeMessageToEmail(mimeMessage);
    }

    @Nonnull
    public static MimeMessage outlookMsgToMimeMessage(@Nonnull String outlookMsgData) {
        Preconditions.checkNonEmptyArgument(outlookMsgData, "outlookMsgData");
        return EmailConverter.emailToMimeMessage(EmailConverter.outlookMsgToEmail(outlookMsgData));
    }

    @Nonnull
    public static MimeMessage outlookMsgToMimeMessage(@Nonnull File outlookMsgFile) {
        Preconditions.checkNonEmptyArgument(outlookMsgFile, "outlookMsgFile");
        return EmailConverter.emailToMimeMessage(EmailConverter.outlookMsgToEmail(outlookMsgFile));
    }

    @Nonnull
    public static MimeMessage outlookMsgToMimeMessage(@Nonnull InputStream outloookMsgInputStream) {
        Preconditions.checkNonEmptyArgument(outloookMsgInputStream, "outloookMsgInputStream");
        return EmailConverter.emailToMimeMessage(EmailConverter.outlookMsgToEmail(outloookMsgInputStream));
    }

    public static MimeMessage emailToMimeMessage(@Nonnull Email email) {
        return EmailConverter.emailToMimeMessage(Preconditions.checkNonEmptyArgument(email, "email"), EmailConverter.createDummySession());
    }

    public static MimeMessage emailToMimeMessage(@Nonnull Email email, @Nonnull Session session) {
        try {
            return MimeMessageHelper.produceMimeMessage(Preconditions.checkNonEmptyArgument(email, "email"), Preconditions.checkNonEmptyArgument(session, "session"));
        }
        catch (UnsupportedEncodingException | MessagingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static MimeMessage emlToMimeMessage(@Nonnull String eml) {
        return EmailConverter.emlToMimeMessage(Preconditions.checkNonEmptyArgument(eml, "eml"), EmailConverter.createDummySession());
    }

    public static MimeMessage emlToMimeMessage(@Nonnull String eml, @Nonnull Session session) {
        Preconditions.checkNonEmptyArgument(session, "session");
        Preconditions.checkNonEmptyArgument(eml, "eml");
        try {
            return new MimeMessage(session, (InputStream)new ByteArrayInputStream(eml.getBytes(StandardCharsets.UTF_8)));
        }
        catch (MessagingException e) {
            throw new EmailConverterException(String.format("Error parsing EML data: %s", e.getMessage()), (Exception)((Object)e));
        }
    }

    public static String mimeMessageToEML(@Nonnull MimeMessage mimeMessage) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            Preconditions.checkNonEmptyArgument(mimeMessage, "mimeMessage").writeTo((OutputStream)os);
            return os.toString(StandardCharsets.UTF_8.name());
        }
        catch (IOException | MessagingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String emailToEML(@Nonnull Email email) {
        return EmailConverter.mimeMessageToEML(EmailConverter.emailToMimeMessage(Preconditions.checkNonEmptyArgument(email, "email")));
    }

    @Nonnull
    public static String outlookMsgToEML(@Nonnull String outlookMsgData) {
        Preconditions.checkNonEmptyArgument(outlookMsgData, "outlookMsgData");
        return EmailConverter.emailToEML(EmailConverter.outlookMsgToEmail(outlookMsgData));
    }

    @Nonnull
    public static String outlookMsgToEML(@Nonnull File outlookMsgFile) {
        Preconditions.checkNonEmptyArgument(outlookMsgFile, "outlookMsgFile");
        return EmailConverter.emailToEML(EmailConverter.outlookMsgToEmail(outlookMsgFile));
    }

    @Nonnull
    public static String outlookMsgToEML(@Nonnull InputStream outloookMsgInputStream) {
        Preconditions.checkNonEmptyArgument(outloookMsgInputStream, "outloookMsgInputStream");
        return EmailConverter.emailToEML(EmailConverter.outlookMsgToEmail(outloookMsgInputStream));
    }

    private static void fillEmailFromMimeMessage(@Nonnull Email email, @Nonnull MimeMessage mimeMessage) throws MessagingException, IOException {
        Preconditions.checkNonEmptyArgument(email, "email");
        Preconditions.checkNonEmptyArgument(mimeMessage, "mimeMessage");
        MimeMessageParser parser = new MimeMessageParser(mimeMessage).parse();
        InternetAddress from = parser.getFrom();
        email.setFromAddress(from.getPersonal(), from.getAddress());
        InternetAddress replyTo = parser.getReplyTo();
        email.setReplyToAddress(replyTo.getPersonal(), replyTo.getAddress());
        for (Map.Entry<String, Object> entry : parser.getHeaders().entrySet()) {
            if (EmailConverter.fillPredefinedHeader(email, entry)) continue;
            email.addHeader(entry.getKey(), entry.getValue());
        }
        for (InternetAddress internetAddress : parser.getTo()) {
            email.addRecipient(internetAddress.getPersonal(), internetAddress.getAddress(), Message.RecipientType.TO);
        }
        for (InternetAddress internetAddress : parser.getCc()) {
            email.addRecipient(internetAddress.getPersonal(), internetAddress.getAddress(), Message.RecipientType.CC);
        }
        for (InternetAddress internetAddress : parser.getBcc()) {
            email.addRecipient(internetAddress.getPersonal(), internetAddress.getAddress(), Message.RecipientType.BCC);
        }
        email.setSubject(parser.getSubject());
        email.setText(parser.getPlainContent());
        email.setTextHTML(parser.getHtmlContent());
        for (Map.Entry<String, Object> entry : parser.getCidMap().entrySet()) {
            String cidName = Preconditions.checkNonEmptyArgument(entry.getKey(), "cid.key");
            email.addEmbeddedImage(MiscUtil.extractCID(cidName), (DataSource)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : parser.getAttachmentList().entrySet()) {
            email.addAttachment(MiscUtil.extractCID(entry.getKey()), (DataSource)entry.getValue());
        }
    }

    private static boolean fillPredefinedHeader(@Nonnull Email email, @Nonnull Map.Entry<String, Object> header) throws AddressException {
        if (header.getKey().equals("Disposition-Notification-To")) {
            email.setUseDispositionNotificationTo(true);
            InternetAddress internetAddress = new InternetAddress((String)header.getValue());
            email.setDispositionNotificationTo(new Recipient(internetAddress.getPersonal(), internetAddress.getAddress(), null));
            return true;
        }
        if (header.getKey().equals("Return-Receipt-To")) {
            email.setUseReturnReceiptTo(true);
            InternetAddress internetAddress = new InternetAddress((String)header.getValue());
            email.setReturnReceiptTo(new Recipient(internetAddress.getPersonal(), internetAddress.getAddress(), null));
            return true;
        }
        return false;
    }

    private static void fillEmailFromOutlookMessage(@Nonnull Email email, @Nonnull OutlookMessage outlookMessage) {
        Preconditions.checkNonEmptyArgument(email, "email");
        Preconditions.checkNonEmptyArgument(outlookMessage, "outlookMessage");
        email.setFromAddress(outlookMessage.getFromName(), outlookMessage.getFromEmail());
        if (!MiscUtil.valueNullOrEmpty(outlookMessage.getReplyToEmail())) {
            email.setReplyToAddress(outlookMessage.getReplyToName(), outlookMessage.getReplyToEmail());
        }
        for (OutlookRecipient outlookRecipient : outlookMessage.getRecipients()) {
            email.addRecipient(outlookRecipient.getName(), outlookRecipient.getAddress(), Message.RecipientType.TO);
        }
        for (OutlookRecipient outlookRecipient : outlookMessage.getCcRecipients()) {
            email.addRecipient(outlookRecipient.getName(), outlookRecipient.getAddress(), Message.RecipientType.CC);
        }
        for (OutlookRecipient outlookRecipient : outlookMessage.getBccRecipients()) {
            email.addRecipient(outlookRecipient.getName(), outlookRecipient.getAddress(), Message.RecipientType.BCC);
        }
        email.setSubject(outlookMessage.getSubject());
        email.setText(outlookMessage.getBodyText());
        email.setTextHTML(outlookMessage.getBodyHTML() != null ? outlookMessage.getBodyHTML() : outlookMessage.getConvertedBodyHTML());
        for (Map.Entry entry : outlookMessage.fetchCIDMap().entrySet()) {
            String cidName = (String)Preconditions.checkNonEmptyArgument(entry.getKey(), "cid.key");
            email.addEmbeddedImage(MiscUtil.extractCID(cidName), ((OutlookFileAttachment)entry.getValue()).getData(), ((OutlookFileAttachment)entry.getValue()).getMimeTag());
        }
        for (OutlookFileAttachment outlookFileAttachment : outlookMessage.fetchTrueAttachments()) {
            email.addAttachment(outlookFileAttachment.getLongFilename(), outlookFileAttachment.getData(), outlookFileAttachment.getMimeTag());
        }
    }

    private static Session createDummySession() {
        return Session.getDefaultInstance((Properties)new Properties());
    }
}

