/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.email;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.Message;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.util.ByteArrayDataSource;
import org.simplejavamail.email.AttachmentResource;
import org.simplejavamail.email.EmailBuilder;
import org.simplejavamail.email.EmailException;
import org.simplejavamail.email.EqualsHelper;
import org.simplejavamail.email.Recipient;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.Preconditions;
import org.simplejavamail.util.ConfigLoader;

public class Email {
    private String id;
    private Recipient fromRecipient;
    private Recipient replyToRecipient;
    private String text;
    private String textHTML;
    private String subject;
    private final List<Recipient> recipients;
    private final List<AttachmentResource> embeddedImages;
    private final List<AttachmentResource> attachments;
    private final Map<String, String> headers;
    private boolean useDispositionNotificationTo;
    private Recipient dispositionNotificationTo;
    private boolean useReturnReceiptTo;
    private Recipient returnReceiptTo;
    private boolean applyDKIMSignature;
    private InputStream dkimPrivateKeyInputStream;
    private File dkimPrivateKeyFile;
    private String dkimSigningDomain;
    private String dkimSelector;

    public Email() {
        this(true);
    }

    public Email(boolean readFromDefaults) {
        this.recipients = new ArrayList<Recipient>();
        this.embeddedImages = new ArrayList<AttachmentResource>();
        this.attachments = new ArrayList<AttachmentResource>();
        this.headers = new HashMap<String, String>();
        if (readFromDefaults) {
            if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_FROM_ADDRESS)) {
                this.setFromAddress((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_FROM_NAME), (String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_FROM_ADDRESS));
            }
            if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_REPLYTO_ADDRESS)) {
                this.setReplyToAddress((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_REPLYTO_NAME), (String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_REPLYTO_ADDRESS));
            }
            if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_TO_ADDRESS)) {
                if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_TO_NAME)) {
                    this.addNamedToRecipients((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_TO_NAME), (String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_TO_ADDRESS));
                } else {
                    this.addToRecipients((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_TO_ADDRESS));
                }
            }
            if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_CC_ADDRESS)) {
                if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_CC_NAME)) {
                    this.addNamedCcRecipients((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_CC_NAME), (String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_CC_ADDRESS));
                } else {
                    this.addCcRecipients((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_CC_ADDRESS));
                }
            }
            if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_BCC_ADDRESS)) {
                if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_BCC_NAME)) {
                    this.addNamedBccRecipients((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_BCC_NAME), (String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_BCC_ADDRESS));
                } else {
                    this.addBccRecipients((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_BCC_ADDRESS));
                }
            }
            if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_SUBJECT)) {
                this.setSubject((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_SUBJECT));
            }
        }
    }

    public void signWithDomainKey(@Nonnull File dkimPrivateKeyFile, @Nonnull String signingDomain, @Nonnull String dkimSelector) {
        this.applyDKIMSignature = true;
        this.dkimPrivateKeyFile = Preconditions.checkNonEmptyArgument(dkimPrivateKeyFile, "dkimPrivateKeyFile");
        this.dkimSigningDomain = Preconditions.checkNonEmptyArgument(signingDomain, "dkimSigningDomain");
        this.dkimSelector = Preconditions.checkNonEmptyArgument(dkimSelector, "dkimSelector");
    }

    public void signWithDomainKey(@Nonnull InputStream dkimPrivateKeyInputStream, @Nonnull String signingDomain, @Nonnull String dkimSelector) {
        this.applyDKIMSignature = true;
        this.dkimPrivateKeyInputStream = Preconditions.checkNonEmptyArgument(dkimPrivateKeyInputStream, "dkimPrivateKeyInputStream");
        this.dkimSigningDomain = Preconditions.checkNonEmptyArgument(signingDomain, "dkimSigningDomain");
        this.dkimSelector = Preconditions.checkNonEmptyArgument(dkimSelector, "dkimSelector");
    }

    public void setId(@Nullable String id) {
        this.id = id;
    }

    public void setFromAddress(@Nullable String name, @Nonnull String fromAddress) {
        this.fromRecipient = new Recipient(name, Preconditions.checkNonEmptyArgument(fromAddress, "fromAddress"), null);
    }

    public void setFromAddress(@Nonnull Recipient recipient) {
        this.fromRecipient = new Recipient(recipient.getName(), Preconditions.checkNonEmptyArgument(recipient.getAddress(), "fromAddress"), null);
    }

    public void setReplyToAddress(@Nullable String name, @Nonnull String replyToAddress) {
        this.replyToRecipient = new Recipient(name, Preconditions.checkNonEmptyArgument(replyToAddress, "replyToAddress"), null);
    }

    public void setReplyToAddress(@Nonnull Recipient recipient) {
        this.replyToRecipient = new Recipient(recipient.getName(), Preconditions.checkNonEmptyArgument(recipient.getAddress(), "replyToAddress"), null);
    }

    public void setSubject(@Nonnull String subject) {
        this.subject = Preconditions.checkNonEmptyArgument(subject, "subject");
    }

    public void setUseDispositionNotificationTo(boolean useDispositionNotificationTo) {
        this.useDispositionNotificationTo = useDispositionNotificationTo;
    }

    public void setDispositionNotificationTo(Recipient dispositionNotificationTo) {
        this.setUseDispositionNotificationTo(true);
        this.dispositionNotificationTo = dispositionNotificationTo;
    }

    public void setUseReturnReceiptTo(boolean useReturnReceiptTo) {
        this.useReturnReceiptTo = useReturnReceiptTo;
    }

    public void setReturnReceiptTo(Recipient returnReceiptTo) {
        this.setUseReturnReceiptTo(true);
        this.returnReceiptTo = returnReceiptTo;
    }

    public void setText(@Nullable String text) {
        this.text = text;
    }

    public void setTextHTML(@Nullable String textHTML) {
        this.textHTML = textHTML;
    }

    public void addToRecipients(String ... delimitedEmailAddresses) {
        Preconditions.checkNonEmptyArgument(delimitedEmailAddresses, "emailAddressList");
        this.addRecipients(null, Message.RecipientType.TO, delimitedEmailAddresses);
    }

    public void addCcRecipients(String ... delimitedEmailAddresses) {
        Preconditions.checkNonEmptyArgument(delimitedEmailAddresses, "emailAddressList");
        this.addRecipients(null, Message.RecipientType.CC, delimitedEmailAddresses);
    }

    public void addBccRecipients(String ... delimitedEmailAddresses) {
        Preconditions.checkNonEmptyArgument(delimitedEmailAddresses, "emailAddressList");
        this.addRecipients(null, Message.RecipientType.BCC, delimitedEmailAddresses);
    }

    public void addNamedToRecipients(@Nullable String name, String ... delimitedEmailAddresses) {
        Preconditions.checkNonEmptyArgument(delimitedEmailAddresses, "emailAddressList");
        this.addRecipients(name, Message.RecipientType.TO, delimitedEmailAddresses);
    }

    public void addNamedCcRecipients(@Nullable String name, String ... delimitedEmailAddresses) {
        Preconditions.checkNonEmptyArgument(delimitedEmailAddresses, "emailAddressList");
        this.addRecipients(name, Message.RecipientType.CC, delimitedEmailAddresses);
    }

    public void addNamedBccRecipients(@Nullable String name, String ... delimitedEmailAddresses) {
        Preconditions.checkNonEmptyArgument(delimitedEmailAddresses, "emailAddressList");
        this.addRecipients(name, Message.RecipientType.BCC, delimitedEmailAddresses);
    }

    public void addRecipients(@Nullable String recipientName, @Nonnull Message.RecipientType type, String ... recipientEmailAddressesToAdd) {
        Preconditions.checkNonEmptyArgument(type, "type");
        Preconditions.checkNonEmptyArgument(recipientEmailAddressesToAdd, "recipientEmailAddressesToAdd");
        for (String potentiallyCombinedEmailAddress : recipientEmailAddressesToAdd) {
            for (String emailAddress : MiscUtil.extractEmailAddresses(potentiallyCombinedEmailAddress)) {
                this.recipients.add(Email.interpretRecipientData(recipientName, emailAddress, type));
            }
        }
    }

    static Recipient interpretRecipientData(@Nullable String recipientName, @Nonnull String emailAddress, @Nullable Message.RecipientType type) {
        try {
            InternetAddress parsedAddress = InternetAddress.parse((String)emailAddress, (boolean)false)[0];
            String relevantName = parsedAddress.getPersonal() != null ? parsedAddress.getPersonal() : recipientName;
            return new Recipient(relevantName, parsedAddress.getAddress(), type);
        }
        catch (AddressException e) {
            return new Recipient(recipientName, emailAddress, type);
        }
    }

    public void addRecipients(Recipient ... recipientsToAdd) {
        for (Recipient recipient : Preconditions.checkNonEmptyArgument(recipientsToAdd, "recipientsToAdd")) {
            String address = Preconditions.checkNonEmptyArgument(recipient.getAddress(), "recipient.address");
            Message.RecipientType type = Preconditions.checkNonEmptyArgument(recipient.getType(), "recipient.type");
            this.recipients.add(new Recipient(recipient.getName(), address, type));
        }
    }

    public void addEmbeddedImage(@Nonnull String name, @Nonnull byte[] data, @Nonnull String mimetype) {
        Preconditions.checkNonEmptyArgument(name, "name");
        Preconditions.checkNonEmptyArgument(data, "data");
        Preconditions.checkNonEmptyArgument(mimetype, "mimetype");
        ByteArrayDataSource dataSource = new ByteArrayDataSource(data, mimetype);
        dataSource.setName(name);
        this.addEmbeddedImage(name, (DataSource)dataSource);
    }

    public void addEmbeddedImage(@Nullable String name, @Nonnull DataSource imagedata) {
        Preconditions.checkNonEmptyArgument(imagedata, "imagedata");
        if (MiscUtil.valueNullOrEmpty(name) && MiscUtil.valueNullOrEmpty(imagedata.getName())) {
            throw new EmailException("No name given for embedded image nor passed inside the data source");
        }
        this.embeddedImages.add(new AttachmentResource(name, imagedata));
    }

    public void addHeader(@Nonnull String name, @Nonnull Object value) {
        Preconditions.checkNonEmptyArgument(name, "name");
        Preconditions.checkNonEmptyArgument(value, "value");
        this.headers.put(name, String.valueOf(value));
    }

    public void addAttachment(@Nonnull String name, @Nonnull byte[] data, @Nonnull String mimetype) {
        Preconditions.checkNonEmptyArgument(name, "name");
        Preconditions.checkNonEmptyArgument(data, "data");
        Preconditions.checkNonEmptyArgument(mimetype, "mimetype");
        ByteArrayDataSource dataSource = new ByteArrayDataSource(data, mimetype);
        dataSource.setName(MiscUtil.encodeText(name));
        this.addAttachment(MiscUtil.encodeText(name), (DataSource)dataSource);
    }

    public void addAttachment(@Nullable String name, @Nonnull DataSource filedata) {
        Preconditions.checkNonEmptyArgument(filedata, "filedata");
        this.attachments.add(new AttachmentResource(MiscUtil.encodeText(name), filedata));
    }

    public String getId() {
        return this.id;
    }

    public Recipient getFromRecipient() {
        return this.fromRecipient;
    }

    public Recipient getReplyToRecipient() {
        return this.replyToRecipient;
    }

    public String getSubject() {
        return this.subject;
    }

    public boolean isUseDispositionNotificationTo() {
        return this.useDispositionNotificationTo;
    }

    public Recipient getDispositionNotificationTo() {
        return this.dispositionNotificationTo;
    }

    public boolean isUseReturnReceiptTo() {
        return this.useReturnReceiptTo;
    }

    public Recipient getReturnReceiptTo() {
        return this.returnReceiptTo;
    }

    public String getText() {
        return this.text;
    }

    public String getTextHTML() {
        return this.textHTML;
    }

    public List<AttachmentResource> getAttachments() {
        return Collections.unmodifiableList(this.attachments);
    }

    public List<AttachmentResource> getEmbeddedImages() {
        return Collections.unmodifiableList(this.embeddedImages);
    }

    public List<Recipient> getRecipients() {
        return Collections.unmodifiableList(this.recipients);
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public boolean isApplyDKIMSignature() {
        return this.applyDKIMSignature;
    }

    public InputStream getDkimPrivateKeyInputStream() {
        return this.dkimPrivateKeyInputStream;
    }

    public File getDkimPrivateKeyFile() {
        return this.dkimPrivateKeyFile;
    }

    public String getDkimSigningDomain() {
        return this.dkimSigningDomain;
    }

    public String getDkimSelector() {
        return this.dkimSelector;
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && EqualsHelper.equalsEmail(this, (Email)o);
    }

    public String toString() {
        String s = "Email{\n\tid=" + this.id + "\n\tfromRecipient=" + this.fromRecipient + ",\n\treplyToRecipient=" + this.replyToRecipient + ",\n\ttext='" + this.text + '\'' + ",\n\ttextHTML='" + this.textHTML + '\'' + ",\n\tsubject='" + this.subject + '\'' + ",\n\trecipients=" + this.recipients;
        if (this.applyDKIMSignature) {
            s = s + ",\n\tapplyDKIMSignature=true,\n\t\tdkimSelector=" + this.dkimSelector + ",\n\t\tdkimSigningDomain=" + this.dkimSigningDomain;
        }
        if (this.useDispositionNotificationTo) {
            s = s + ",\n\tuseDispositionNotificationTo=true,\n\t\tdispositionNotificationTo=" + this.dispositionNotificationTo;
        }
        if (this.useReturnReceiptTo) {
            s = s + ",\n\tuseReturnReceiptTo=true,\n\t\treturnReceiptTo=" + this.returnReceiptTo;
        }
        if (!this.headers.isEmpty()) {
            s = s + ",\n\theaders=" + this.headers;
        }
        if (!this.embeddedImages.isEmpty()) {
            s = s + ",\n\tembeddedImages=" + this.embeddedImages;
        }
        if (!this.attachments.isEmpty()) {
            s = s + ",\n\tattachments=" + this.attachments;
        }
        s = s + "\n}";
        return s;
    }

    Email(@Nonnull EmailBuilder builder) {
        Preconditions.checkNonEmptyArgument(builder, "builder");
        this.recipients = builder.getRecipients();
        this.embeddedImages = builder.getEmbeddedImages();
        this.attachments = builder.getAttachments();
        this.headers = builder.getHeaders();
        this.id = builder.getId();
        this.fromRecipient = builder.getFromRecipient();
        this.replyToRecipient = builder.getReplyToRecipient();
        this.text = builder.getText();
        this.textHTML = builder.getTextHTML();
        this.subject = builder.getSubject();
        this.useDispositionNotificationTo = builder.isUseDispositionNotificationTo();
        this.useReturnReceiptTo = builder.isUseReturnReceiptTo();
        this.dispositionNotificationTo = builder.getDispositionNotificationTo();
        this.returnReceiptTo = builder.getReturnReceiptTo();
        if (this.useDispositionNotificationTo && MiscUtil.valueNullOrEmpty(builder.getDispositionNotificationTo())) {
            this.dispositionNotificationTo = builder.getReplyToRecipient() != null ? builder.getReplyToRecipient() : builder.getFromRecipient();
        }
        if (this.useReturnReceiptTo && MiscUtil.valueNullOrEmpty(builder.getDispositionNotificationTo())) {
            this.returnReceiptTo = builder.getReplyToRecipient() != null ? builder.getReplyToRecipient() : builder.getFromRecipient();
        }
        if (builder.getDkimPrivateKeyFile() != null) {
            this.signWithDomainKey(builder.getDkimPrivateKeyFile(), builder.getSigningDomain(), builder.getDkimSelector());
        } else if (builder.getDkimPrivateKeyInputStream() != null) {
            this.signWithDomainKey(builder.getDkimPrivateKeyInputStream(), builder.getSigningDomain(), builder.getDkimSelector());
        }
    }
}

