/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.internet.MimeUtility;
import org.simplejavamail.internal.util.Preconditions;

public final class MiscUtil {
    private static final Pattern MATCH_INSIDE_CIDBRACKETS = Pattern.compile("<?([^>]*)>?");

    public static <T> T checkNotNull(T value, String msg) {
        if (value == null) {
            throw new NullPointerException(msg);
        }
        return value;
    }

    public static <T> T checkArgumentNotEmpty(T value, String msg) {
        if (MiscUtil.valueNullOrEmpty(value)) {
            throw new IllegalArgumentException(msg);
        }
        return value;
    }

    public static <T> boolean valueNullOrEmpty(T value) {
        return value == null || value instanceof String && ((String)value).isEmpty() || value instanceof Collection && ((Collection)value).isEmpty() || value instanceof byte[] && ((byte[])value).length == 0;
    }

    public static String buildLogString(byte[] bytes, boolean isReceived) {
        StringBuilder debugMsg = new StringBuilder();
        debugMsg.append(isReceived ? "Received: " : "Sent: ");
        for (byte aByte : bytes) {
            debugMsg.append(Integer.toHexString(MiscUtil.toInt(aByte))).append(" ");
        }
        return debugMsg.toString();
    }

    public static int toInt(byte b) {
        return b & 0xFF;
    }

    public static String encodeText(@Nullable String name) {
        if (name == null) {
            return null;
        }
        try {
            return MimeUtility.encodeText((String)name);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Nullable
    public static String extractCID(@Nullable String cid) {
        return cid != null ? MATCH_INSIDE_CIDBRACKETS.matcher(cid).replaceAll("$1") : null;
    }

    @Nonnull
    public static String readInputStreamToString(@Nonnull InputStream inputStream, @Nonnull Charset charset) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int result = bufferedInputStream.read();
        while (result != -1) {
            byteArrayOutputStream.write((byte)result);
            result = bufferedInputStream.read();
        }
        return byteArrayOutputStream.toString(Preconditions.checkNonEmptyArgument(charset, "charset").name());
    }

    @Nonnull
    public static String[] extractEmailAddresses(@Nonnull String emailAddressList) {
        return Preconditions.checkNonEmptyArgument(emailAddressList, "emailAddressList").replaceAll("(@.*?>?)\\s*[,;]", "$1<|>").replaceAll("<\\|>$", "").split("\\s*<\\|>\\s*");
    }
}

