/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.internal.socks.socks5client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import org.simplejavamail.mailer.internal.socks.socks5client.ProxyCredentials;
import org.simplejavamail.mailer.internal.socks.socks5client.SocksAuthenticationHelper;
import org.simplejavamail.mailer.internal.socks.socks5client.SocksCommandSender;

public class Socks5 {
    private static final int SOCKS_DEFAULT_PORT = 1080;
    public static final byte AUTHENTICATION_SUCCEEDED = 0;
    private Socks5 chainProxy;
    private ProxyCredentials credentials = new ProxyCredentials();
    private InetAddress inetAddress;
    private int port = 1080;
    private Socket proxySocket;
    private SocksAuthenticationHelper socksAuthenticationHelper = new SocksAuthenticationHelper();
    private boolean alwaysResolveAddressLocally = false;

    Socks5(InetAddress inetAddress, int port) {
        this(new InetSocketAddress(inetAddress, port));
    }

    public Socks5(InetSocketAddress socketAddress) {
        this(null, socketAddress);
    }

    private Socks5(Socks5 chainProxy, InetSocketAddress socketAddress) {
        this.inetAddress = socketAddress.getAddress();
        this.port = socketAddress.getPort();
        this.setChainProxy(chainProxy);
    }

    public void buildConnection() throws IOException {
        if (this.inetAddress == null) {
            throw new IllegalArgumentException("Please set inetAddress before calling buildConnection.");
        }
        if (this.proxySocket == null) {
            this.proxySocket = this.createProxySocket(this.inetAddress, this.port);
        } else if (!this.proxySocket.isConnected()) {
            this.proxySocket.connect(new InetSocketAddress(this.inetAddress, this.port));
        }
        if (SocksAuthenticationHelper.shouldAuthenticate(this.proxySocket)) {
            SocksAuthenticationHelper.performUserPasswordAuthentication(this);
        }
    }

    public void requestConnect(String host, int port) throws IOException {
        if (!this.alwaysResolveAddressLocally) {
            SocksCommandSender.send(this.proxySocket, host, port);
        } else {
            InetAddress address = InetAddress.getByName(host);
            SocksCommandSender.send(this.proxySocket, address, port);
        }
    }

    public void requestConnect(InetAddress address, int port) throws IOException {
        SocksCommandSender.send(this.proxySocket, address, port);
    }

    public void requestConnect(SocketAddress address) throws IOException {
        SocksCommandSender.send(this.proxySocket, address);
    }

    public int getPort() {
        return this.port;
    }

    Socks5 setPort(int port) {
        this.port = port;
        return this;
    }

    public Socket getProxySocket() {
        return this.proxySocket;
    }

    public void setProxySocket(Socket proxySocket) {
        this.proxySocket = proxySocket;
    }

    public InputStream getInputStream() throws IOException {
        return this.proxySocket.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.proxySocket.getOutputStream();
    }

    public ProxyCredentials getCredentials() {
        return this.credentials;
    }

    public Socks5 setCredentials(ProxyCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    SocksAuthenticationHelper getSocksAuthenticationHelper() {
        return this.socksAuthenticationHelper;
    }

    Socks5 setSocksAuthenticationHelper(SocksAuthenticationHelper requester) {
        this.socksAuthenticationHelper = requester;
        return this;
    }

    public Socks5 copy() {
        Socks5 socks5 = new Socks5(this.inetAddress, this.port);
        socks5.setAlwaysResolveAddressLocally(this.alwaysResolveAddressLocally).setCredentials(this.credentials).setSocksAuthenticationHelper(this.socksAuthenticationHelper).setChainProxy(this.chainProxy);
        return socks5;
    }

    public Socks5 getChainProxy() {
        return this.chainProxy;
    }

    Socks5 setChainProxy(Socks5 chainProxy) {
        this.chainProxy = chainProxy;
        return this;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    Socks5 setInetAddress(InetAddress inetAddress) {
        this.inetAddress = inetAddress;
        return this;
    }

    public String toString() {
        StringBuilder stringBuffer = new StringBuilder("[SOCKS5:");
        stringBuffer.append(new InetSocketAddress(this.inetAddress, this.port)).append("]");
        if (this.getChainProxy() != null) {
            return stringBuffer.append(" --> ").append(this.getChainProxy()).toString();
        }
        return stringBuffer.toString();
    }

    Socket createProxySocket(InetAddress address, int port) throws IOException {
        return new Socket(address, port);
    }

    public Socket createProxySocket() throws IOException {
        return new Socket();
    }

    boolean isAlwaysResolveAddressLocally() {
        return this.alwaysResolveAddressLocally;
    }

    Socks5 setAlwaysResolveAddressLocally(boolean alwaysResolveAddressLocally) {
        this.alwaysResolveAddressLocally = alwaysResolveAddressLocally;
        return this;
    }
}

