/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.email;

import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.mail.internet.MimeMessage;
import org.simplejavamail.email.AttachmentResource;
import org.simplejavamail.email.EmailPopulatingBuilder;
import org.simplejavamail.email.EqualsHelper;
import org.simplejavamail.email.Recipient;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.Preconditions;

public class Email {
    private String id;
    private final Recipient fromRecipient;
    private final Recipient replyToRecipient;
    private final Recipient bounceToRecipient;
    private final String text;
    private final String textHTML;
    private final String subject;
    private final List<Recipient> recipients;
    private final List<AttachmentResource> embeddedImages;
    private final List<AttachmentResource> attachments;
    private final Map<String, String> headers;
    private final boolean useDispositionNotificationTo;
    private Recipient dispositionNotificationTo;
    private final boolean useReturnReceiptTo;
    private Recipient returnReceiptTo;
    private final MimeMessage emailToForward;
    private InputStream dkimPrivateKeyInputStream;
    private File dkimPrivateKeyFile;
    private String dkimSigningDomain;
    private String dkimSelector;

    public Email(@Nonnull EmailPopulatingBuilder builder) {
        Preconditions.checkNonEmptyArgument(builder, "builder");
        this.recipients = Collections.unmodifiableList(builder.getRecipients());
        this.embeddedImages = Collections.unmodifiableList(builder.getEmbeddedImages());
        this.attachments = Collections.unmodifiableList(builder.getAttachments());
        this.headers = Collections.unmodifiableMap(builder.getHeaders());
        this.id = builder.getId();
        this.fromRecipient = builder.getFromRecipient();
        this.replyToRecipient = builder.getReplyToRecipient();
        this.bounceToRecipient = builder.getBounceToRecipient();
        this.text = builder.getText();
        this.textHTML = builder.getTextHTML();
        this.subject = builder.getSubject();
        this.useDispositionNotificationTo = builder.isUseDispositionNotificationTo();
        this.useReturnReceiptTo = builder.isUseReturnReceiptTo();
        this.dispositionNotificationTo = builder.getDispositionNotificationTo();
        this.returnReceiptTo = builder.getReturnReceiptTo();
        this.emailToForward = builder.getEmailToForward();
        if (this.useDispositionNotificationTo && MiscUtil.valueNullOrEmpty(builder.getDispositionNotificationTo())) {
            this.dispositionNotificationTo = builder.getReplyToRecipient() != null ? builder.getReplyToRecipient() : builder.getFromRecipient();
        }
        if (this.useReturnReceiptTo && MiscUtil.valueNullOrEmpty(builder.getDispositionNotificationTo())) {
            this.returnReceiptTo = builder.getReplyToRecipient() != null ? builder.getReplyToRecipient() : builder.getFromRecipient();
        }
        if (builder.getDkimPrivateKeyFile() != null) {
            this.dkimPrivateKeyFile = builder.getDkimPrivateKeyFile();
            this.dkimSigningDomain = builder.getDkimSigningDomain();
            this.dkimSelector = builder.getDkimSelector();
        } else if (builder.getDkimPrivateKeyInputStream() != null) {
            this.dkimPrivateKeyInputStream = builder.getDkimPrivateKeyInputStream();
            this.dkimSigningDomain = builder.getDkimSigningDomain();
            this.dkimSelector = builder.getDkimSelector();
        }
    }

    @Deprecated
    public void internalSetId(@Nonnull String id) {
        this.id = id;
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && EqualsHelper.equalsEmail(this, (Email)o);
    }

    public String toString() {
        String s = "Email{\n\tid=" + this.id + "\n\tfromRecipient=" + this.fromRecipient + ",\n\treplyToRecipient=" + this.replyToRecipient + ",\n\tbounceToRecipient=" + this.bounceToRecipient + ",\n\ttext='" + this.text + '\'' + ",\n\ttextHTML='" + this.textHTML + '\'' + ",\n\tsubject='" + this.subject + '\'' + ",\n\trecipients=" + this.recipients;
        if (!MiscUtil.valueNullOrEmpty(this.dkimSigningDomain)) {
            s = s + ",\n\tapplyDKIMSignature=true,\n\t\tdkimSelector=" + this.dkimSelector + ",\n\t\tdkimSigningDomain=" + this.dkimSigningDomain;
        }
        if (this.useDispositionNotificationTo) {
            s = s + ",\n\tuseDispositionNotificationTo=true,\n\t\tdispositionNotificationTo=" + this.dispositionNotificationTo;
        }
        if (this.useReturnReceiptTo) {
            s = s + ",\n\tuseReturnReceiptTo=true,\n\t\treturnReceiptTo=" + this.returnReceiptTo;
        }
        if (!this.headers.isEmpty()) {
            s = s + ",\n\theaders=" + this.headers;
        }
        if (!this.embeddedImages.isEmpty()) {
            s = s + ",\n\tembeddedImages=" + this.embeddedImages;
        }
        if (!this.attachments.isEmpty()) {
            s = s + ",\n\tattachments=" + this.attachments;
        }
        if (this.emailToForward != null) {
            s = s + ",\n\tforwardingEmail=true";
        }
        s = s + "\n}";
        return s;
    }

    public String getId() {
        return this.id;
    }

    public Recipient getFromRecipient() {
        return this.fromRecipient;
    }

    public Recipient getReplyToRecipient() {
        return this.replyToRecipient;
    }

    public Recipient getBounceToRecipient() {
        return this.bounceToRecipient;
    }

    public String getSubject() {
        return this.subject;
    }

    public boolean isUseDispositionNotificationTo() {
        return this.useDispositionNotificationTo;
    }

    public Recipient getDispositionNotificationTo() {
        return this.dispositionNotificationTo;
    }

    public boolean isUseReturnReceiptTo() {
        return this.useReturnReceiptTo;
    }

    public Recipient getReturnReceiptTo() {
        return this.returnReceiptTo;
    }

    public MimeMessage getEmailToForward() {
        return this.emailToForward;
    }

    public String getPlainText() {
        return this.text;
    }

    public String getHTMLText() {
        return this.textHTML;
    }

    public List<AttachmentResource> getAttachments() {
        return this.attachments;
    }

    public List<AttachmentResource> getEmbeddedImages() {
        return this.embeddedImages;
    }

    public List<Recipient> getRecipients() {
        return this.recipients;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public InputStream getDkimPrivateKeyInputStream() {
        return this.dkimPrivateKeyInputStream;
    }

    public File getDkimPrivateKeyFile() {
        return this.dkimPrivateKeyFile;
    }

    public String getDkimSigningDomain() {
        return this.dkimSigningDomain;
    }

    public String getDkimSelector() {
        return this.dkimSelector;
    }
}

