/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.converter.internal.msgparser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.simplejavamail.converter.internal.msgparser.OutlookMessageException;
import org.simplejavamail.internal.util.Preconditions;
import org.simplejavamail.outlookmessageparser.simplejavamail.model.OutlookMessage;

public final class OutlookMessageParser {
    private OutlookMessageParser() {
    }

    @Nonnull
    public static OutlookMessage parseOutlookMsg(@Nonnull File msgFile) {
        Preconditions.checkNonEmptyArgument(msgFile, "msgFile");
        try {
            return new org.simplejavamail.outlookmessageparser.simplejavamail.OutlookMessageParser().parseMsg(msgFile);
        }
        catch (IOException e) {
            throw new OutlookMessageException("Unable to parse Outlook message", e);
        }
    }

    @Nonnull
    public static OutlookMessage parseOutlookMsg(@Nonnull InputStream msgInputStream) {
        Preconditions.checkNonEmptyArgument(msgInputStream, "msgInputStream");
        try {
            return new org.simplejavamail.outlookmessageparser.simplejavamail.OutlookMessageParser().parseMsg(msgInputStream);
        }
        catch (IOException e) {
            throw new OutlookMessageException("Unable to parse Outlook message", e);
        }
    }

    @Nonnull
    public static OutlookMessage parseOutlookMsg(@Nonnull String msgData) {
        Preconditions.checkNonEmptyArgument(msgData, "msgData");
        try {
            return new org.simplejavamail.outlookmessageparser.simplejavamail.OutlookMessageParser().parseMsg(msgData);
        }
        catch (IOException e) {
            throw new OutlookMessageException("Unable to parse Outlook message", e);
        }
    }
}

